/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.core.classes;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.burningwave.core.assembler.StaticComponentContainer;
import org.burningwave.core.classes.Members;
import org.burningwave.core.classes.MethodCriteria;
import org.burningwave.core.function.Executor;
import org.burningwave.core.function.ThrowingFunction;

public class Methods
extends Members.Handler.OfExecutable<Method, MethodCriteria> {
    public static Methods create() {
        return new Methods();
    }

    String createGetterMethodNameByPropertyName(String property) {
        String methodName = "get" + StaticComponentContainer.Strings.capitalizeFirstCharacter(property);
        return methodName;
    }

    String createSetterMethodNameByPropertyName(String property) {
        String methodName = "set" + StaticComponentContainer.Strings.capitalizeFirstCharacter(property);
        return methodName;
    }

    public Method findOneAndMakeItAccessible(Class<?> targetClass, String memberName, Class<?> ... inputParameterTypesOrSubTypes) {
        Collection<Method> members = this.findAllByExactNameAndMakeThemAccessible(targetClass, memberName, inputParameterTypesOrSubTypes);
        if (members.size() == 1) {
            return members.stream().findFirst().get();
        }
        if (members.size() > 1) {
            Collection<Method> membersThatMatch = this.searchForExactMatch(members, inputParameterTypesOrSubTypes);
            if (membersThatMatch.size() == 1) {
                return membersThatMatch.stream().findFirst().get();
            }
            StaticComponentContainer.Throwables.throwException("Found more than one of method named {} with argument types {} in {} hierarchy", memberName, String.join((CharSequence)", ", Arrays.asList(inputParameterTypesOrSubTypes).stream().map(cls -> cls.getName()).collect(Collectors.toList())), targetClass.getName());
        }
        return null;
    }

    public Method findFirstAndMakeItAccessible(Class<?> targetClass, String memberName, Class<?> ... inputParameterTypesOrSubTypes) {
        Collection<Method> members = this.findAllByExactNameAndMakeThemAccessible(targetClass, memberName, inputParameterTypesOrSubTypes);
        if (members.size() == 1) {
            return members.stream().findFirst().get();
        }
        if (members.size() > 1) {
            Collection<Method> membersThatMatch = this.searchForExactMatch(members, inputParameterTypesOrSubTypes);
            if (!membersThatMatch.isEmpty()) {
                return membersThatMatch.stream().findFirst().get();
            }
            return members.stream().findFirst().get();
        }
        return null;
    }

    public Collection<Method> findAllByExactNameAndMakeThemAccessible(Class<?> targetClass, String methodName, Class<?> ... inputParameterTypesOrSubTypes) {
        return this.findAllByNamePredicateAndMakeThemAccessible(targetClass, "equals " + methodName, methodName::equals, inputParameterTypesOrSubTypes);
    }

    public Collection<Method> findAllByMatchedNameAndMakeThemAccessible(Class<?> targetClass, String methodName, Class<?> ... inputParameterTypesOrSubTypes) {
        return this.findAllByNamePredicateAndMakeThemAccessible(targetClass, "match " + methodName, methodName::matches, inputParameterTypesOrSubTypes);
    }

    private Collection<Method> findAllByNamePredicateAndMakeThemAccessible(Class<?> targetClass, String cacheKeyPrefix, Predicate<String> namePredicate, Class<?> ... inputParameterTypesOrSubTypes) {
        String cacheKey = this.getCacheKey(targetClass, cacheKeyPrefix, inputParameterTypesOrSubTypes);
        ClassLoader targetClassClassLoader = StaticComponentContainer.Classes.getClassLoader(targetClass);
        return StaticComponentContainer.Cache.uniqueKeyForMethods.getOrUploadIfAbsent(targetClassClassLoader, cacheKey, () -> {
            MethodCriteria criteria = (MethodCriteria)((MethodCriteria)((MethodCriteria)MethodCriteria.forEntireClassHierarchy().name(namePredicate)).and()).parameterTypesAreAssignableFrom(inputParameterTypesOrSubTypes);
            if (inputParameterTypesOrSubTypes != null && inputParameterTypesOrSubTypes.length == 0) {
                criteria = criteria.or((MethodCriteria)((MethodCriteria)((MethodCriteria)MethodCriteria.forEntireClassHierarchy().name(namePredicate)).and()).parameter((parameters, idx) -> ((Parameter[])parameters).length == 1 && parameters[0].isVarArgs()));
            }
            MethodCriteria finalCriteria = criteria;
            return StaticComponentContainer.Cache.uniqueKeyForMethods.getOrUploadIfAbsent(targetClassClassLoader, cacheKey, () -> this.findAllAndApply(finalCriteria, targetClass, member -> this.setAccessible(member, true)));
        });
    }

    public Collection<Method> findAllAndMakeThemAccessible(Class<?> targetClass) {
        String cacheKey = this.getCacheKey(targetClass, "all methods", new Class[0]);
        ClassLoader targetClassClassLoader = StaticComponentContainer.Classes.getClassLoader(targetClass);
        Collection members = StaticComponentContainer.Cache.uniqueKeyForMethods.getOrUploadIfAbsent(targetClassClassLoader, cacheKey, () -> this.findAllAndMakeThemAccessible(MethodCriteria.forEntireClassHierarchy(), targetClass));
        return members;
    }

    public <T> T invokeStatic(Class<?> targetClass, String methodName, Object ... arguments) {
        return (T)this.invoke(targetClass, null, methodName, (Method method) -> this.invoke((Object)null, (Method)method, this.getArgumentArray(method, this::getArgumentListWithArrayForVarArgs, ArrayList::new, arguments)), arguments);
    }

    public <T> T invoke(Object target, String methodName, Object ... arguments) {
        return (T)this.invoke(StaticComponentContainer.Classes.retrieveFrom(target), null, methodName, (Method method) -> this.invoke(target, (Method)method, this.getArgumentArray(method, this::getArgumentListWithArrayForVarArgs, ArrayList::new, arguments)), arguments);
    }

    public <T> T invoke(Object target, Method method, Object ... params) {
        if (params == null) {
            params = new Object[]{null};
        }
        try {
            return (T)method.invoke(target, params);
        }
        catch (Throwable exc) {
            return (T)StaticComponentContainer.Driver.invoke(method, target, params);
        }
    }

    private <T> T invoke(Class<?> targetClass, Object target, String methodName, ThrowingFunction<Method, T, Throwable> methodInvoker, Object ... arguments) {
        return (T)Executor.get(() -> {
            Method method = this.findFirstAndMakeItAccessible(targetClass, methodName, StaticComponentContainer.Classes.retrieveFrom(arguments));
            if (method == null) {
                StaticComponentContainer.Throwables.throwException("Method {} not found in {} hierarchy", methodName, targetClass.getName());
            }
            return methodInvoker.apply(method);
        });
    }

    public <T> T invokeStaticDirect(Class<?> targetClass, String methodName, Object ... arguments) {
        return this.invokeDirect(targetClass, (Object)null, methodName, ArrayList::new, arguments);
    }

    public <T> T invokeDirect(Object target, String methodName, Object ... arguments) {
        return this.invokeDirect(StaticComponentContainer.Classes.retrieveFrom(target), target, methodName, () -> {
            ArrayList<Object> argumentList = new ArrayList<Object>();
            argumentList.add(target);
            return argumentList;
        }, arguments);
    }

    private <T> T invokeDirect(Class<?> targetClass, Object target, String methodName, Supplier<List<Object>> listSupplier, Object ... arguments) {
        Class<?>[] argsType = StaticComponentContainer.Classes.retrieveFrom(arguments);
        Members.Handler.OfExecutable.Box<Method> methodHandleBox = this.findDirectHandleBox(targetClass, methodName, argsType);
        return (T)Executor.get(() -> {
            Method method = (Method)methodHandleBox.getExecutable();
            List<Object> argumentList = this.getFlatArgumentList(method, listSupplier, arguments);
            return methodHandleBox.getHandler().invokeWithArguments(argumentList);
        });
    }

    public MethodHandle findDirectHandle(Class<?> targetClass, String methodName, Class<?> ... inputParameterTypesOrSubTypes) {
        return this.findDirectHandleBox(targetClass, methodName, inputParameterTypesOrSubTypes).getHandler();
    }

    private Members.Handler.OfExecutable.Box<Method> findDirectHandleBox(Class<?> targetClass, String methodName, Class<?> ... inputParameterTypesOrSubTypes) {
        String cacheKey = this.getCacheKey(targetClass, "equals " + methodName, inputParameterTypesOrSubTypes);
        ClassLoader targetClassClassLoader = StaticComponentContainer.Classes.getClassLoader(targetClass);
        Members.Handler.OfExecutable.Box<Method> entry = StaticComponentContainer.Cache.uniqueKeyForExecutableAndMethodHandle.get(targetClassClassLoader, cacheKey);
        if (entry == null) {
            Method method = this.findFirstAndMakeItAccessible(targetClass, methodName, inputParameterTypesOrSubTypes);
            if (method == null) {
                StaticComponentContainer.Throwables.throwException("Method {} not found in {} hierarchy", methodName, targetClass.getName());
            }
            entry = this.findDirectHandleBox(method, targetClassClassLoader, cacheKey);
        }
        return entry;
    }

    @Override
    MethodHandle retrieveMethodHandle(MethodHandles.Lookup consulter, Method method) throws NoSuchMethodException, IllegalAccessException {
        Class<?> methodDeclaringClass = method.getDeclaringClass();
        return !Modifier.isStatic(method.getModifiers()) ? consulter.findSpecial(methodDeclaringClass, this.retrieveNameForCaching(method), MethodType.methodType(method.getReturnType(), method.getParameterTypes()), methodDeclaringClass) : consulter.findStatic(methodDeclaringClass, this.retrieveNameForCaching(method), MethodType.methodType(method.getReturnType(), method.getParameterTypes()));
    }

    @Override
    String retrieveNameForCaching(Method method) {
        return method.getName();
    }
}

