/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.core.classes;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.burningwave.core.assembler.StaticComponentContainer;
import org.burningwave.core.function.TriConsumer;

public class Modules {
    private Class<?> moduleClass;
    private Set<?> allSet = new HashSet();
    private Set<?> everyOneSet = new HashSet();
    private Set<?> allUnnamedSet = new HashSet();
    private Map<String, ?> nameToModule;

    Modules() {
        try {
            this.moduleClass = Class.forName("java.lang.Module");
            Class<?> moduleLayerClass = Class.forName("java.lang.ModuleLayer");
            Object moduleLayer = StaticComponentContainer.Methods.invokeStaticDirect(moduleLayerClass, "boot", new Object[0]);
            this.nameToModule = (Map)StaticComponentContainer.Fields.getDirect(moduleLayer, "nameToModule");
            this.allSet = new HashSet();
            this.allSet.add(StaticComponentContainer.Fields.getStaticDirect(this.moduleClass, "ALL_UNNAMED_MODULE"));
            this.allSet.add(StaticComponentContainer.Fields.getStaticDirect(this.moduleClass, "EVERYONE_MODULE"));
            this.everyOneSet = new HashSet();
            this.everyOneSet.add(StaticComponentContainer.Fields.getStaticDirect(this.moduleClass, "EVERYONE_MODULE"));
            this.allUnnamedSet = new HashSet();
            this.allUnnamedSet.add(StaticComponentContainer.Fields.getStaticDirect(this.moduleClass, "ALL_UNNAMED_MODULE"));
        }
        catch (Throwable exc) {
            StaticComponentContainer.Throwables.throwException(exc, new Object[0]);
        }
    }

    public static Modules create() {
        return new Modules();
    }

    public void exportAllToAll() {
        try {
            this.nameToModule.forEach((name, module) -> ((Set)StaticComponentContainer.Methods.invokeDirect(module, "getPackages", new Object[0])).forEach(pkgName -> {
                this.exportToAll("exportedPackages", module, (String)pkgName);
                this.exportToAll("openPackages", module, (String)pkgName);
            }));
        }
        catch (Throwable exc) {
            StaticComponentContainer.Throwables.throwException(exc, new Object[0]);
        }
    }

    public void exportToAllUnnamed(String name) {
        this.exportTo(name, this::exportToAllUnnamed);
    }

    public void exportToAll(String name) {
        this.exportTo(name, this::exportToAll);
    }

    public void exportPackage(String moduleFromName, String moduleToName, String ... packageNames) {
        Object moduleFrom = this.checkAndGetModule(moduleFromName);
        Object moduleTo = this.checkAndGetModule(moduleToName);
        this.exportPackage(moduleFrom, moduleTo, packageNames);
    }

    public void exportPackageToAll(String moduleFromName, String ... packageNames) {
        Object moduleFrom = this.checkAndGetModule(moduleFromName);
        this.exportPackage(moduleFrom, this.everyOneSet.iterator().next(), packageNames);
    }

    public void exportPackageToAllUnnamed(String moduleFromName, String ... packageNames) {
        Object moduleFrom = this.checkAndGetModule(moduleFromName);
        this.exportPackage(moduleFrom, this.allUnnamedSet.iterator().next(), packageNames);
    }

    public void export(String moduleFromName, String moduleToName) {
        try {
            Object moduleFrom = this.checkAndGetModule(moduleFromName);
            Object moduleTo = this.checkAndGetModule(moduleToName);
            ((Set)StaticComponentContainer.Methods.invokeDirect(moduleFrom, "getPackages", new Object[0])).forEach(pkgName -> {
                this.export("exportedPackages", moduleFrom, (String)pkgName, moduleTo);
                this.export("openPackages", moduleFrom, (String)pkgName, moduleTo);
            });
        }
        catch (Throwable exc) {
            StaticComponentContainer.Throwables.throwException(exc, new Object[0]);
        }
    }

    void exportPackage(Object moduleFrom, Object moduleTo, String ... packageNames) {
        Set modulePackages = (Set)StaticComponentContainer.Methods.invokeDirect(moduleFrom, "getPackages", new Object[0]);
        Stream.of(packageNames).forEach(pkgName -> {
            if (!modulePackages.contains(pkgName)) {
                throw new PackageNotFoundException(StaticComponentContainer.Strings.compile("Package {} not found in module {}", pkgName, StaticComponentContainer.Fields.getDirect(moduleFrom, "name")));
            }
            this.export("exportedPackages", moduleFrom, (String)pkgName, moduleTo);
            this.export("openPackages", moduleFrom, (String)pkgName, moduleTo);
        });
    }

    Object checkAndGetModule(String name) {
        Object module = this.nameToModule.get(name);
        if (module == null) {
            throw new NotFoundException(StaticComponentContainer.Strings.compile("Module named name {} not found", name));
        }
        return module;
    }

    void exportTo(String name, TriConsumer<String, Object, String> exporter) {
        try {
            Object module = this.checkAndGetModule(name);
            ((Set)StaticComponentContainer.Methods.invokeDirect(module, "getPackages", new Object[0])).forEach(pkgName -> {
                exporter.accept("exportedPackages", module, (String)pkgName);
                exporter.accept("openPackages", module, (String)pkgName);
            });
        }
        catch (Throwable exc) {
            StaticComponentContainer.Throwables.throwException(exc, new Object[0]);
        }
    }

    void exportToAll(String fieldName, Object module, String pkgName) {
        HashMap pckgForModule = (HashMap)StaticComponentContainer.Fields.getDirect(module, fieldName);
        if (pckgForModule == null) {
            pckgForModule = new HashMap();
            StaticComponentContainer.Fields.setDirect(module, fieldName, pckgForModule);
        }
        pckgForModule.put(pkgName, this.allSet);
        if (fieldName.startsWith("exported")) {
            StaticComponentContainer.Methods.invokeStaticDirect(this.moduleClass, "addExportsToAll0", module, pkgName);
        }
    }

    void exportToAllUnnamed(String fieldName, Object module, String pkgName) {
        HashMap pckgForModule = (HashMap)StaticComponentContainer.Fields.getDirect(module, fieldName);
        if (pckgForModule == null) {
            pckgForModule = new HashMap();
            StaticComponentContainer.Fields.setDirect(module, fieldName, pckgForModule);
        }
        pckgForModule.put(pkgName, this.allUnnamedSet);
        if (fieldName.startsWith("exported")) {
            StaticComponentContainer.Methods.invokeStaticDirect(this.moduleClass, "addExportsToAllUnnamed0", module, pkgName);
        }
    }

    void export(String fieldName, Object moduleFrom, String pkgName, Object moduleTo) {
        HashSet<Object> moduleSet;
        HashMap<String, HashSet<Object>> pckgForModule = (HashMap<String, HashSet<Object>>)StaticComponentContainer.Fields.getDirect(moduleFrom, fieldName);
        if (pckgForModule == null) {
            pckgForModule = new HashMap<String, HashSet<Object>>();
            StaticComponentContainer.Fields.setDirect(moduleFrom, fieldName, pckgForModule);
        }
        if (!((moduleSet = (HashSet<Object>)pckgForModule.get(pkgName)) instanceof HashSet)) {
            moduleSet = moduleSet != null ? new HashSet(moduleSet) : new HashSet<Object>();
            pckgForModule.put(pkgName, moduleSet);
        }
        moduleSet.add(moduleTo);
        if (fieldName.startsWith("exported")) {
            StaticComponentContainer.Methods.invokeStaticDirect(this.moduleClass, "addExports0", moduleFrom, pkgName, moduleTo);
        }
    }

    public static class NotFoundException
    extends RuntimeException {
        private static final long serialVersionUID = 3095842376538548262L;

        public NotFoundException(String message) {
            super(message);
        }
    }

    public static class PackageNotFoundException
    extends RuntimeException {
        private static final long serialVersionUID = 7545728769111299062L;

        public PackageNotFoundException(String message) {
            super(message);
        }
    }
}

