/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.core.classes;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.burningwave.core.assembler.StaticComponentContainer;
import org.burningwave.core.classes.JavaClass;
import org.burningwave.core.classes.MemoryClassLoader;
import org.burningwave.core.io.FileSystemItem;
import org.burningwave.core.io.PathHelper;

public class PathScannerClassLoader
extends MemoryClassLoader {
    Collection<String> loadedPaths;
    PathHelper pathHelper;
    FileSystemItem.Criteria classFileCriteriaAndConsumer;

    protected PathScannerClassLoader(ClassLoader parentClassLoader, PathHelper pathHelper, FileSystemItem.Criteria scanFileCriteria) {
        super(parentClassLoader);
        this.pathHelper = pathHelper;
        this.loadedPaths = ConcurrentHashMap.newKeySet();
        this.classFileCriteriaAndConsumer = ((FileSystemItem.Criteria)scanFileCriteria.createCopy().and()).allFileThat((child, pathFIS) -> {
            JavaClass.use(child.toByteBuffer(), javaClass -> this.addByteCode0(javaClass.getName(), javaClass.getByteCode()));
            return true;
        }).setExceptionHandler((exc, childAndPath) -> {
            if (!this.isClosed) {
                StaticComponentContainer.ManagedLoggersRepository.logError(this.getClass()::getName, "Exception occurred while scanning {}", (Throwable)exc, (Object)childAndPath[0].getAbsolutePath());
            } else {
                StaticComponentContainer.Throwables.throwException(exc, new Object[0]);
            }
            return false;
        });
    }

    public static PathScannerClassLoader create(ClassLoader parentClassLoader, PathHelper pathHelper, FileSystemItem.Criteria scanFileCriteria) {
        return new PathScannerClassLoader(parentClassLoader, pathHelper, scanFileCriteria);
    }

    public Collection<String> scanPathsAndAddAllByteCodesFound(Collection<String> paths) {
        return this.scanPathsAndAddAllByteCodesFound(paths, path -> false);
    }

    public Collection<String> scanPathsAndAddAllByteCodesFound(Collection<String> paths, Predicate<String> checkForAddedClasses) {
        HashSet<String> scannedPaths = new HashSet<String>();
        try {
            for (String path : paths) {
                if (!checkForAddedClasses.test(path) && this.hasBeenLoaded(path)) continue;
                StaticComponentContainer.Synchronizer.execute(this.instanceId + "_" + path, () -> {
                    if (checkForAddedClasses.test(path) || !this.hasBeenLoaded(path)) {
                        FileSystemItem pathFIS = FileSystemItem.ofPath(path);
                        if (checkForAddedClasses.test(path)) {
                            pathFIS.refresh();
                        }
                        Predicate<FileSystemItem[]> classFilePredicateAndConsumer = this.classFileCriteriaAndConsumer.getPredicateOrTruePredicateIfPredicateIsNull();
                        for (FileSystemItem child : pathFIS.getAllChildren()) {
                            classFilePredicateAndConsumer.test(new FileSystemItem[]{child, pathFIS});
                        }
                        this.loadedPaths.add(path);
                        scannedPaths.add(path);
                    }
                });
            }
        }
        catch (Throwable exc) {
            if (this.isClosed) {
                StaticComponentContainer.ManagedLoggersRepository.logWarn(this.getClass()::getName, "Could not execute scanPathsAndAddAllByteCodesFound because {} has been closed", this.toString());
            }
            throw exc;
        }
        return scannedPaths;
    }

    public URL[] getURLs() {
        Collection urls = this.loadedPaths.stream().map(absolutePath -> FileSystemItem.ofPath(absolutePath).getURL()).collect(Collectors.toSet());
        return urls.toArray(new URL[urls.size()]);
    }

    @Override
    public URL getResource(String name) {
        ClassLoader parentClassLoader = StaticComponentContainer.ClassLoaders.getParent(this);
        URL url = null;
        if (parentClassLoader != null) {
            url = parentClassLoader.getResource(name);
        }
        if (url != null) {
            return url;
        }
        AtomicReference inputStreamWrapper = new AtomicReference();
        FileSystemItem.Criteria scanFileCriteria = FileSystemItem.Criteria.forAllFileThat(child -> {
            if (child.isFile() && child.getAbsolutePath().endsWith("/" + name)) {
                inputStreamWrapper.set(child.getURL());
                return true;
            }
            return false;
        });
        for (String loadedPath : this.loadedPaths) {
            FileSystemItem.ofPath(loadedPath).findFirstInAllChildren(scanFileCriteria);
            if (inputStreamWrapper.get() == null) continue;
            return (URL)inputStreamWrapper.get();
        }
        return null;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        List<URL> resourcesFound = this.getResourcesURLFromParent(name);
        FileSystemItem.Criteria scanFileCriteria = FileSystemItem.Criteria.forAllFileThat(child -> {
            if (child.isFile() && child.getAbsolutePath().endsWith("/" + name)) {
                resourcesFound.add(child.getURL());
                return true;
            }
            return false;
        });
        for (String loadedPath : this.loadedPaths) {
            FileSystemItem.ofPath(loadedPath).findInAllChildren(scanFileCriteria);
        }
        return Collections.enumeration(resourcesFound);
    }

    List<URL> getResourcesURLFromParent(String name) throws IOException {
        ClassLoader parentClassLoader = StaticComponentContainer.ClassLoaders.getParent(this);
        CopyOnWriteArrayList<URL> resourcesFound = new CopyOnWriteArrayList<URL>();
        if (parentClassLoader != null) {
            Enumeration<URL> urlEnum = parentClassLoader.getResources(name);
            while (urlEnum.hasMoreElements()) {
                resourcesFound.add(urlEnum.nextElement());
            }
        }
        return resourcesFound;
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        InputStream inputStream = super.getResourceAsStream(name);
        if (inputStream != null) {
            return inputStream;
        }
        AtomicReference inputStreamWrapper = new AtomicReference();
        FileSystemItem.Criteria scanFileCriteria = FileSystemItem.Criteria.forAllFileThat(child -> {
            if (child.isFile() && child.getAbsolutePath().endsWith("/" + name)) {
                inputStreamWrapper.set(child.toInputStream());
                return true;
            }
            return false;
        });
        for (String loadedPath : this.loadedPaths) {
            FileSystemItem.ofPath(loadedPath).findFirstInAllChildren(scanFileCriteria);
            if (inputStreamWrapper.get() == null) continue;
            return (InputStream)inputStreamWrapper.get();
        }
        return null;
    }

    public Map<String, InputStream> getResourcesAsStream(String name) {
        ConcurrentHashMap<String, InputStream> inputStreams = new ConcurrentHashMap<String, InputStream>();
        FileSystemItem.Criteria scanFileCriteria = FileSystemItem.Criteria.forAllFileThat(child -> {
            if (child.isFile() && child.getAbsolutePath().endsWith("/" + name)) {
                inputStreams.put(child.getAbsolutePath(), child.toInputStream());
                return true;
            }
            return false;
        });
        for (String loadedPath : this.loadedPaths) {
            FileSystemItem.ofPath(loadedPath).findInAllChildren(scanFileCriteria);
        }
        return inputStreams;
    }

    public boolean hasBeenLoaded(String path) {
        if (this.loadedPaths.contains(path)) {
            return true;
        }
        FileSystemItem pathFIS = FileSystemItem.ofPath(path);
        for (String loadedPath : StaticComponentContainer.ClassLoaders.getAllLoadedPaths(StaticComponentContainer.ClassLoaders.getParent(this))) {
            FileSystemItem loadedPathFIS = FileSystemItem.ofPath(loadedPath);
            if (!pathFIS.isChildOf(loadedPathFIS) && !pathFIS.equals(loadedPathFIS)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void close() {
        this.closeResources(() -> this.loadedPaths == null, () -> {
            super.close();
            this.loadedPaths.clear();
            this.loadedPaths = null;
            this.pathHelper = null;
            this.classFileCriteriaAndConsumer = null;
        });
    }

    static {
        ClassLoader.registerAsParallelCapable();
    }

    public static class Configuration {
        public static final Map<String, Object> DEFAULT_VALUES;

        static {
            HashMap<String, Object> defaultValues = new HashMap<String, Object>();
            defaultValues = new HashMap();
            defaultValues.put("path-scanner-class-loader.parent.supplier.imports", "${code-executor.common.imports};${path-scanner-class-loader.parent.supplier.additional-imports};");
            defaultValues.put("path-scanner-class-loader.parent.supplier.name", PathScannerClassLoader.class.getPackage().getName() + ".ParentClassLoaderRetrieverForPathScannerClassLoader");
            defaultValues.put("path-scanner-class-loader.parent", Thread.currentThread().getContextClassLoader());
            defaultValues.put("path-scanner-class-loader.search-config.check-file-option", FileSystemItem.CheckingOption.FOR_NAME.getLabel());
            DEFAULT_VALUES = Collections.unmodifiableMap(defaultValues);
        }

        public static class Key {
            public static final String PARENT_CLASS_LOADER = "path-scanner-class-loader.parent";
            public static final String SEARCH_CONFIG_CHECK_FILE_OPTION = "path-scanner-class-loader.search-config.check-file-option";
        }
    }
}

