/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.core.classes;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.burningwave.core.classes.CacheableSearchConfig;
import org.burningwave.core.classes.ClassCriteria;
import org.burningwave.core.classes.SearchConfigAbst;

public class SearchConfig
extends SearchConfigAbst<SearchConfig> {
    @SafeVarargs
    SearchConfig(Collection<String> ... pathsColl) {
        super(pathsColl);
    }

    public static CacheableSearchConfig create() {
        return new CacheableSearchConfig(new HashSet());
    }

    public static SearchConfig withoutUsingCache() {
        return new SearchConfig(new HashSet());
    }

    @SafeVarargs
    public static CacheableSearchConfig forPaths(Collection<String> ... pathsColl) {
        return new CacheableSearchConfig(pathsColl);
    }

    @SafeVarargs
    public static CacheableSearchConfig forPaths(String ... paths) {
        return SearchConfig.forPaths(Stream.of(paths).collect(Collectors.toCollection(HashSet::new)));
    }

    @SafeVarargs
    public static CacheableSearchConfig forResources(String ... paths) {
        return SearchConfig.forResources(null, paths);
    }

    @SafeVarargs
    public static CacheableSearchConfig forResources(ClassLoader classLoader, String ... paths) {
        return SearchConfig.forResources(classLoader, Arrays.asList(paths));
    }

    @SafeVarargs
    public static CacheableSearchConfig forResources(Collection<String> ... pathCollections) {
        return SearchConfig.forResources(null, pathCollections);
    }

    @SafeVarargs
    public static CacheableSearchConfig forResources(ClassLoader classLoader, Collection<String> ... pathCollections) {
        return (CacheableSearchConfig)new CacheableSearchConfig(new HashSet()).addResources(classLoader, pathCollections);
    }

    public static CacheableSearchConfig byCriteria(ClassCriteria classCriteria) {
        return (CacheableSearchConfig)SearchConfig.forPaths(new HashSet()).by(classCriteria);
    }

    @Override
    SearchConfig newInstance() {
        return new SearchConfig(this.paths);
    }
}

