/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.core.classes;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.burningwave.core.Closeable;
import org.burningwave.core.ManagedLogger;
import org.burningwave.core.assembler.StaticComponentContainer;
import org.burningwave.core.classes.ClassCriteria;
import org.burningwave.core.classes.PathScannerClassLoader;
import org.burningwave.core.io.FileSystemItem;

abstract class SearchConfigAbst<S extends SearchConfigAbst<S>>
implements Closeable,
ManagedLogger {
    ClassCriteria classCriteria;
    Collection<String> paths;
    BiConsumer<ClassLoader, Collection<String>> resourceSupplier;
    ClassLoader parentClassLoaderForPathScannerClassLoader;
    Supplier<FileSystemItem.Criteria> defaultScanFileCriteriaSupplier;
    Supplier<FileSystemItem.Criteria> scanFileCriteriaSupplier;
    boolean optimizePaths;
    boolean useDefaultPathScannerClassLoader;
    boolean useDefaultPathScannerClassLoaderAsParent;
    boolean waitForSearchEnding;
    protected BiPredicate<SearchConfigAbst<?>, String> checkForAddedClassesForAllPathThat;
    protected FileSystemItem.Criteria scanFileCriteriaModifier;

    SearchConfigAbst(Collection<String> ... pathsColl) {
        this.useDefaultPathScannerClassLoader(true);
        this.waitForSearchEnding = true;
        this.paths = new HashSet<String>();
        this.addPaths(pathsColl);
        this.classCriteria = ClassCriteria.create();
        this.checkForAddedClassesForAllPathThat = (searchConfig, path) -> false;
    }

    void init(PathScannerClassLoader classSupplier) {
        this.classCriteria.init(classSupplier);
    }

    @SafeVarargs
    public final S addPaths(Collection<String> ... pathColls) {
        for (Collection<String> paths : pathColls) {
            this.paths.addAll(paths);
        }
        return (S)this;
    }

    public S addPaths(String ... paths) {
        return this.addPaths(Arrays.asList(paths));
    }

    @SafeVarargs
    public final S addResources(ClassLoader classLoader, Collection<String> ... pathColls) {
        if (classLoader == null) {
            this.resourceSupplier = this.resourceSupplier == null ? (cl, paths) -> {
                Collection resourcesPaths = StaticComponentContainer.ClassLoaders.getResources((ClassLoader)cl, pathColls).stream().map(file -> file.getAbsolutePath()).collect(Collectors.toSet());
                if (resourcesPaths.isEmpty()) {
                    Stream.of(pathColls).forEach(pathColl -> resourcesPaths.addAll(pathColl));
                }
                paths.addAll(resourcesPaths);
            } : this.resourceSupplier.andThen((cl, paths) -> {
                Collection resourcesPaths = StaticComponentContainer.ClassLoaders.getResources((ClassLoader)cl, pathColls).stream().map(file -> file.getAbsolutePath()).collect(Collectors.toSet());
                if (resourcesPaths.isEmpty()) {
                    Stream.of(pathColls).forEach(pathColl -> resourcesPaths.addAll(pathColl));
                }
                paths.addAll(resourcesPaths);
            });
            return (S)this;
        }
        return this.addPaths(StaticComponentContainer.ClassLoaders.getResources(classLoader, pathColls).stream().map(file -> file.getAbsolutePath()).collect(Collectors.toSet()));
    }

    @SafeVarargs
    public final S addResources(ClassLoader classLoader, String ... paths) {
        return this.addResources(classLoader, Arrays.asList(paths));
    }

    @SafeVarargs
    public final S addResources(String ... paths) {
        return this.addResources(Arrays.asList(paths));
    }

    @SafeVarargs
    public final S addResources(Collection<String> ... pathCollections) {
        return this.addResources((ClassLoader)null, pathCollections);
    }

    Collection<String> getPaths() {
        return this.paths;
    }

    public S by(ClassCriteria classCriteria) {
        this.classCriteria = classCriteria;
        return (S)this;
    }

    @SafeVarargs
    public final S excludePathsThatMatch(Collection<String> ... pathRegExCollections) {
        for (Collection<String> pathRegExCollection : pathRegExCollections) {
            for (String pathRegEx : pathRegExCollection) {
                if (this.scanFileCriteriaModifier == null) {
                    this.scanFileCriteriaModifier = FileSystemItem.Criteria.create().excludePathsThatMatch(pathRegEx);
                    continue;
                }
                ((FileSystemItem.Criteria)this.scanFileCriteriaModifier.and()).excludePathsThatMatch(pathRegEx);
            }
        }
        return (S)this;
    }

    @SafeVarargs
    public final S excludePathsThatMatch(String ... regex) {
        return this.excludePathsThatMatch(Arrays.asList(regex));
    }

    public S notRecursiveOnPath(String path, boolean isAbsolute) {
        if (this.scanFileCriteriaModifier == null) {
            this.scanFileCriteriaModifier = FileSystemItem.Criteria.create().notRecursiveOnPath(path, isAbsolute);
        } else {
            ((FileSystemItem.Criteria)this.scanFileCriteriaModifier.and()).notRecursiveOnPath(path, isAbsolute);
        }
        return (S)this;
    }

    S withDefaultScanFileCriteria(FileSystemItem.Criteria scanFileCriteria) {
        this.defaultScanFileCriteriaSupplier = () -> scanFileCriteria;
        return (S)this;
    }

    public S withScanFileCriteria(FileSystemItem.Criteria scanFileCriteria) {
        this.scanFileCriteriaSupplier = () -> scanFileCriteria;
        return (S)this;
    }

    FileSystemItem.Criteria buildScanFileCriteria() {
        FileSystemItem.Criteria criteria;
        FileSystemItem.Criteria criteria2 = criteria = this.scanFileCriteriaSupplier == null ? this.defaultScanFileCriteriaSupplier.get() : this.scanFileCriteriaSupplier.get();
        if (this.scanFileCriteriaModifier != null) {
            criteria = criteria.and(this.scanFileCriteriaModifier);
        }
        return criteria;
    }

    boolean scanFileCriteriaHasNoPredicate() {
        return this.scanFileCriteriaSupplier == null && this.scanFileCriteriaModifier == null;
    }

    ClassCriteria getClassCriteria() {
        return this.classCriteria;
    }

    BiConsumer<ClassLoader, Collection<String>> getResourceSupllier() {
        return this.resourceSupplier;
    }

    public S useDefaultPathScannerClassLoader(boolean value) {
        this.useDefaultPathScannerClassLoader = value;
        this.useDefaultPathScannerClassLoaderAsParent = !this.useDefaultPathScannerClassLoader;
        this.parentClassLoaderForPathScannerClassLoader = null;
        return (S)this;
    }

    public S useAsParentClassLoader(ClassLoader classLoader) {
        if (classLoader == null) {
            StaticComponentContainer.Throwables.throwException("Parent class loader could not be null", new Object[0]);
        }
        this.useDefaultPathScannerClassLoader = false;
        this.useDefaultPathScannerClassLoaderAsParent = false;
        this.parentClassLoaderForPathScannerClassLoader = classLoader;
        return (S)this;
    }

    public S useDefaultPathScannerClassLoaderAsParent(boolean value) {
        this.useDefaultPathScannerClassLoaderAsParent = value;
        this.useDefaultPathScannerClassLoader = !this.useDefaultPathScannerClassLoaderAsParent;
        this.parentClassLoaderForPathScannerClassLoader = null;
        return (S)this;
    }

    public S useNewIsolatedClassLoader() {
        this.useDefaultPathScannerClassLoaderAsParent = false;
        this.useDefaultPathScannerClassLoader = false;
        this.parentClassLoaderForPathScannerClassLoader = null;
        return (S)this;
    }

    public S waitForSearchEnding(boolean waitForSearchEnding) {
        this.waitForSearchEnding = waitForSearchEnding;
        return (S)this;
    }

    public S optimizePaths(boolean flag) {
        this.optimizePaths = flag;
        return (S)this;
    }

    public S checkForAddedClasses() {
        this.checkForAddedClassesForAllPathThat = (searchConfig, path) -> searchConfig.getPaths().contains(path);
        return (S)this;
    }

    public S checkForAddedClassesForAllPathThat(Predicate<String> refreshCacheFor) {
        this.checkForAddedClassesForAllPathThat = (searchConfig, path) -> refreshCacheFor.test((String)path);
        return (S)this;
    }

    BiPredicate<SearchConfigAbst<?>, String> getCheckForAddedClassesPredicate() {
        return this.checkForAddedClassesForAllPathThat;
    }

    abstract S newInstance();

    public <S extends SearchConfigAbst<S>> S copyTo(S destConfig) {
        destConfig.classCriteria = this.classCriteria.createCopy();
        destConfig.paths = new HashSet<String>();
        destConfig.paths.addAll(this.paths);
        destConfig.resourceSupplier = this.resourceSupplier;
        destConfig.scanFileCriteriaSupplier = this.scanFileCriteriaSupplier;
        destConfig.defaultScanFileCriteriaSupplier = this.defaultScanFileCriteriaSupplier;
        if (this.scanFileCriteriaModifier != null) {
            destConfig.scanFileCriteriaModifier = this.scanFileCriteriaModifier.createCopy();
        }
        destConfig.optimizePaths = this.optimizePaths;
        destConfig.useDefaultPathScannerClassLoader = this.useDefaultPathScannerClassLoader;
        destConfig.parentClassLoaderForPathScannerClassLoader = this.parentClassLoaderForPathScannerClassLoader;
        destConfig.useDefaultPathScannerClassLoaderAsParent = this.useDefaultPathScannerClassLoaderAsParent;
        destConfig.waitForSearchEnding = this.waitForSearchEnding;
        destConfig.checkForAddedClassesForAllPathThat = this.checkForAddedClassesForAllPathThat;
        return destConfig;
    }

    public S createCopy() {
        return this.copyTo(this.newInstance());
    }

    @Override
    public void close() {
        this.classCriteria.close();
        this.classCriteria = null;
        this.scanFileCriteriaSupplier = null;
        this.defaultScanFileCriteriaSupplier = null;
        this.resourceSupplier = null;
        if (this.scanFileCriteriaModifier != null) {
            this.scanFileCriteriaModifier.close();
            this.scanFileCriteriaModifier = null;
        }
        this.paths.clear();
        this.paths = null;
        this.parentClassLoaderForPathScannerClassLoader = null;
    }
}

