/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.core.classes;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.burningwave.core.Closeable;
import org.burningwave.core.Context;
import org.burningwave.core.ManagedLogger;
import org.burningwave.core.assembler.StaticComponentContainer;
import org.burningwave.core.classes.ClassCriteria;
import org.burningwave.core.classes.JavaClass;
import org.burningwave.core.classes.PathScannerClassLoader;
import org.burningwave.core.classes.SearchConfigAbst;
import org.burningwave.core.concurrent.QueuedTasksExecutor;
import org.burningwave.core.function.Executor;
import org.burningwave.core.function.ThrowingSupplier;

class SearchContext<T>
implements Closeable,
ManagedLogger {
    SearchConfigAbst<?> searchConfig;
    Map<String, T> itemsFoundFlatMap = new ConcurrentHashMap<String, T>();
    Map<String, Map<String, T>> itemsFoundMap = new ConcurrentHashMap<String, Map<String, T>>();
    PathScannerClassLoader sharedPathScannerClassLoader;
    PathScannerClassLoader pathScannerClassLoader;
    Collection<String> skippedClassNames = ConcurrentHashMap.newKeySet();
    QueuedTasksExecutor.Task searchTask;
    Collection<String> pathScannerClassLoaderScannedPaths = new HashSet<String>();
    Collection<T> itemsFound;

    Collection<String> getSkippedClassNames() {
        return this.skippedClassNames;
    }

    SearchContext(InitContext initContext) {
        this.sharedPathScannerClassLoader = initContext.getSharedPathScannerClassLoader();
        this.pathScannerClassLoader = initContext.getPathScannerClassLoader();
        this.searchConfig = initContext.getSearchConfig();
        this.pathScannerClassLoader.register(this);
        this.sharedPathScannerClassLoader.register(this);
        this.sharedPathScannerClassLoader.unregister(this.searchConfig, true);
    }

    public static <T> SearchContext<T> create(InitContext initContext) {
        return new SearchContext<T>(initContext);
    }

    void executeSearch(Consumer<SearchContext<T>> searcher) {
        if (this.searchConfig.waitForSearchEnding) {
            searcher.accept(this);
        } else {
            this.searchTask = (QueuedTasksExecutor.Task)StaticComponentContainer.BackgroundExecutor.createTask(() -> searcher.accept(this)).submit();
        }
    }

    void waitForSearchEnding() {
        try {
            QueuedTasksExecutor.Task searchTask = this.searchTask;
            if (searchTask != null) {
                searchTask.waitForFinish();
                this.searchTask = null;
            }
        }
        catch (Throwable exc) {
            StaticComponentContainer.Throwables.throwException(exc, new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addItemFound(String path, String key, T item) {
        this.retrieveCollectionForPath(this.itemsFoundMap, ConcurrentHashMap::new, path).put(key, item);
        Map<String, T> map = this.itemsFoundFlatMap;
        synchronized (map) {
            this.itemsFoundFlatMap.put(key, item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addAllItemsFound(String path, Map<String, T> items) {
        this.retrieveCollectionForPath(this.itemsFoundMap, ConcurrentHashMap::new, path).putAll(items);
        for (Map.Entry<String, T> item : items.entrySet()) {
            Map<String, T> map = this.itemsFoundFlatMap;
            synchronized (map) {
                this.itemsFoundFlatMap.put(item.getKey(), item.getValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<String, T> retrieveCollectionForPath(Map<String, Map<String, T>> allItems, Supplier<Map<String, T>> mapForPathSupplier, String path) {
        Map<String, T> items = null;
        if (mapForPathSupplier != null) {
            if (allItems != null) {
                items = allItems.get(path);
                if (items == null) {
                    Map<String, Map<String, T>> map = allItems;
                    synchronized (map) {
                        items = allItems.get(path);
                        if (items == null) {
                            items = mapForPathSupplier.get();
                            allItems.put(path, items);
                        }
                    }
                }
            } else {
                items = mapForPathSupplier.get();
            }
        }
        return items;
    }

    Collection<String> getPathsToBeScanned() {
        return this.searchConfig.getPaths();
    }

    <C extends SearchConfigAbst<C>> C getSearchConfig() {
        return (C)this.searchConfig;
    }

    Map<String, T> getItemsFoundFlatMap() {
        return this.itemsFoundFlatMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<T> getItemsFound() {
        if (this.itemsFound == null) {
            Map<String, T> map = this.itemsFoundFlatMap;
            synchronized (map) {
                if (this.itemsFound == null) {
                    this.itemsFound = ConcurrentHashMap.newKeySet();
                    this.itemsFound.addAll(this.itemsFoundFlatMap.values());
                }
            }
        }
        return this.itemsFound;
    }

    Map<String, T> getItemsFound(String path) {
        return this.itemsFoundMap.get(path);
    }

    public void addByteCodeClassesToClassLoader(String className, ByteBuffer byteCode) {
        this.pathScannerClassLoader.addByteCode(className, byteCode);
    }

    <O> O execute(ThrowingSupplier<O, Throwable> supplier, Supplier<O> defaultValueSupplier, Supplier<String> classNameSupplier) {
        return this.execute(supplier, defaultValueSupplier, classNameSupplier, false);
    }

    <O> O execute(ThrowingSupplier<O, Throwable> supplier, Supplier<O> defaultValueSupplier, Supplier<String> classNameSupplier, boolean isARecursiveCall) {
        return (O)Executor.get(() -> {
            try {
                return supplier.get();
            }
            catch (ClassNotFoundException | NoClassDefFoundError exc) {
                String notFoundClassName = StaticComponentContainer.Classes.retrieveName(exc);
                if (notFoundClassName != null) {
                    if (!this.skippedClassNames.contains(notFoundClassName)) {
                        if (!isARecursiveCall) {
                            if (this.pathScannerClassLoaderScannedPaths.isEmpty()) {
                                Collection<String> collection = this.pathScannerClassLoaderScannedPaths;
                                synchronized (collection) {
                                    if (this.pathScannerClassLoaderScannedPaths.isEmpty()) {
                                        this.pathScannerClassLoader.scanPathsAndAddAllByteCodesFound(this.getPathsToBeScanned(), path -> this.searchConfig.getCheckForAddedClassesPredicate().and((searchConfig, _path) -> !this.pathScannerClassLoaderScannedPaths.contains(_path)).test(this.searchConfig, (String)path));
                                        this.pathScannerClassLoaderScannedPaths.addAll(this.getPathsToBeScanned());
                                    }
                                }
                            }
                            return this.execute(supplier, defaultValueSupplier, classNameSupplier, true);
                        }
                        this.skippedClassNames.add((String)classNameSupplier.get());
                        this.skippedClassNames.add(notFoundClassName);
                    }
                } else {
                    StaticComponentContainer.ManagedLoggersRepository.logError(this.getClass()::getName, "Could not retrieve className from exception", exc);
                }
                return defaultValueSupplier.get();
            }
            catch (InternalError | LinkageError | SecurityException exc) {
                StaticComponentContainer.ManagedLoggersRepository.logWarn(this.getClass()::getName, "Could not load class {}: {}", classNameSupplier.get(), exc.toString());
                return defaultValueSupplier.get();
            }
        });
    }

    Class<?> loadClass(String className) {
        return this.execute(() -> this.pathScannerClassLoader.loadClass(className), () -> null, () -> className);
    }

    Class<?> loadClass(Class<?> cls) {
        return this.execute(() -> this.pathScannerClassLoader.loadOrDefineClass(cls), () -> null, () -> cls.getName());
    }

    Class<?> loadClass(JavaClass cls) {
        return this.execute(() -> this.pathScannerClassLoader.loadOrDefineClass(cls), () -> null, () -> cls.getName());
    }

    Class<?> retrieveClass(Class<?> cls) {
        return StaticComponentContainer.Classes.isLoadedBy(cls, this.pathScannerClassLoader) ? cls : this.loadClass(cls.getName());
    }

    <C extends SearchConfigAbst<C>> ClassCriteria.TestContext test(Class<?> cls) {
        return this.execute(() -> (ClassCriteria.TestContext)this.searchConfig.getClassCriteria().testWithFalseResultForNullEntityOrTrueResultForNullPredicate(cls), () -> (ClassCriteria.TestContext)this.searchConfig.getClassCriteria().testWithFalseResultForNullEntityOrFalseResultForNullPredicate(null), () -> cls.getName());
    }

    @Override
    public void close() {
        this.pathScannerClassLoader.unregister(this, true);
        if (this.sharedPathScannerClassLoader != null) {
            this.sharedPathScannerClassLoader.unregister(this, true);
        }
        this.itemsFoundFlatMap = null;
        this.itemsFoundMap = null;
        this.itemsFound = null;
        this.searchConfig.close();
        this.searchConfig = null;
        this.pathScannerClassLoader = null;
        this.sharedPathScannerClassLoader = null;
        this.skippedClassNames.clear();
        this.skippedClassNames = null;
        this.searchTask = null;
    }

    static class InitContext
    extends Context {
        InitContext(PathScannerClassLoader sharedPathMemoryClassLoader, PathScannerClassLoader pathScannerClassLoader, SearchConfigAbst<?> searchConfig) {
            this.put(Elements.SHARED_PATH_SCANNER_CLASS_LOADER, sharedPathMemoryClassLoader);
            this.put(Elements.PATH_SCANNER_CLASS_LOADER, pathScannerClassLoader);
            this.put(Elements.SEARCH_CONFIG, searchConfig);
        }

        static InitContext create(PathScannerClassLoader sharedPathMemoryClassLoader, PathScannerClassLoader pathScannerClassLoader, SearchConfigAbst<?> searchConfig) {
            return new InitContext(sharedPathMemoryClassLoader, pathScannerClassLoader, searchConfig);
        }

        PathScannerClassLoader getSharedPathScannerClassLoader() {
            return (PathScannerClassLoader)this.get(Elements.SHARED_PATH_SCANNER_CLASS_LOADER);
        }

        PathScannerClassLoader getPathScannerClassLoader() {
            return (PathScannerClassLoader)this.get(Elements.PATH_SCANNER_CLASS_LOADER);
        }

        <C extends SearchConfigAbst<C>> C getSearchConfig() {
            return (C)((SearchConfigAbst)this.get(Elements.SEARCH_CONFIG));
        }

        static enum Elements {
            SHARED_PATH_SCANNER_CLASS_LOADER,
            PATH_SCANNER_CLASS_LOADER,
            SEARCH_CONFIG;

        }
    }
}

