/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.core.concurrent;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.burningwave.core.Closeable;
import org.burningwave.core.ManagedLogger;
import org.burningwave.core.assembler.StaticComponentContainer;

public class Thread
extends java.lang.Thread
implements ManagedLogger {
    Consumer<Thread> originalExecutable;
    Consumer<Thread> executable;
    boolean looper;
    boolean looping;
    private final long index;
    boolean alive;
    Supplier supplier;

    private Thread(Supplier pool, long index) {
        super(pool.name + " - executor " + index);
        this.index = index;
        this.supplier = pool;
        this.setDaemon(pool.daemon);
    }

    public void setIndexedName() {
        this.setIndexedName(null);
    }

    public void setIndexedName(String prefix) {
        this.setName(Optional.ofNullable(prefix).orElseGet(() -> this.supplier.name + " - executor") + " " + this.index);
    }

    public Thread setExecutable(Consumer<Thread> executable) {
        this.originalExecutable = executable;
        return this.setExecutable(executable, false);
    }

    public Thread setExecutable(Consumer<Thread> executable, boolean isLooper) {
        this.originalExecutable = executable;
        this.looper = isLooper;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void start() {
        this.executable = !this.looper ? this.originalExecutable : thread -> {
            this.looping = true;
            while (this.looping) {
                this.originalExecutable.accept(this);
            }
        };
        if (this.alive) {
            Thread thread2 = this;
            synchronized (thread2) {
                this.notifyAll();
            }
        } else {
            this.alive = true;
            super.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopLooping() {
        this.looping = false;
        Thread thread = this;
        synchronized (thread) {
            this.notifyAll();
        }
    }

    public boolean isLooping() {
        return this.looping;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitFor(long millis) {
        Thread thread = this;
        synchronized (thread) {
            try {
                this.wait(millis);
            }
            catch (InterruptedException exc) {
                StaticComponentContainer.ManagedLoggersRepository.logError(() -> this.getClass().getName(), exc);
            }
        }
    }

    void shutDown() {
        this.shutDown(false);
    }

    void shutDown(boolean waitForFinish) {
        this.alive = false;
        this.stopLooping();
        if (waitForFinish) {
            try {
                this.join();
            }
            catch (InterruptedException exc) {
                StaticComponentContainer.ManagedLoggersRepository.logError(this.getClass()::getName, exc);
            }
        }
    }

    public static class Supplier {
        private String name;
        private volatile long threadsCount;
        private volatile long poolableThreadsCount;
        private int maxPoolableThreadsCount;
        private int inititialMaxThreadsCount;
        private int maxThreadsCount;
        private int maxDetachedThreadsCountIncreasingStep;
        private long poolableThreadRequestTimeout;
        private long elapsedTimeThresholdFromLastIncreaseForGradualDecreasingOfMaxDetachedThreadsCount;
        private Collection<Thread> runningThreads;
        private Collection<Thread> poolableSleepingThreads;
        private long timeOfLastIncreaseOfMaxDetachedThreadsCount;
        private boolean daemon;

        Supplier(String name, Properties config) {
            int maxDetachedThreadsCountAsInt;
            int maxPoolableThreadsCountAsInt;
            this.name = name;
            this.daemon = StaticComponentContainer.Objects.toBoolean(StaticComponentContainer.IterableObjectHelper.resolveValue(config, "thread-supplier.default-daemon-flag-value"));
            this.runningThreads = ConcurrentHashMap.newKeySet();
            this.poolableSleepingThreads = ConcurrentHashMap.newKeySet();
            double multiplier = 3.0;
            try {
                maxPoolableThreadsCountAsInt = StaticComponentContainer.Objects.toInt(StaticComponentContainer.IterableObjectHelper.resolveValue(config, "thread-supplier.max-poolable-threads-count"));
            }
            catch (Throwable exc) {
                maxPoolableThreadsCountAsInt = (int)((double)Runtime.getRuntime().availableProcessors() * multiplier);
            }
            if (maxPoolableThreadsCountAsInt <= 0) {
                throw new IllegalArgumentException("maxPoolableThreadsCount must be greater than zero");
            }
            try {
                maxDetachedThreadsCountAsInt = StaticComponentContainer.Objects.toInt(StaticComponentContainer.IterableObjectHelper.resolveValue(config, "thread-supplier.max-detached-threads-count"));
            }
            catch (Throwable exc) {
                maxDetachedThreadsCountAsInt = (int)((double)(Runtime.getRuntime().availableProcessors() * 3) * multiplier) - (int)((double)Runtime.getRuntime().availableProcessors() * multiplier);
            }
            if (maxDetachedThreadsCountAsInt < 0) {
                maxDetachedThreadsCountAsInt = Integer.MAX_VALUE - maxPoolableThreadsCountAsInt;
            }
            this.maxPoolableThreadsCount = maxPoolableThreadsCountAsInt;
            this.inititialMaxThreadsCount = this.maxThreadsCount = maxPoolableThreadsCountAsInt + maxDetachedThreadsCountAsInt;
            this.poolableThreadRequestTimeout = StaticComponentContainer.Objects.toLong(StaticComponentContainer.IterableObjectHelper.resolveValue(config, "thread-supplier.poolable-thread-request-timeout"));
            this.elapsedTimeThresholdFromLastIncreaseForGradualDecreasingOfMaxDetachedThreadsCount = StaticComponentContainer.Objects.toLong(StaticComponentContainer.IterableObjectHelper.resolveValue(config, "thread-supplier.max-detached-threads-count.elapsed-time-threshold-from-last-increase-for-gradual-decreasing-to-initial-value"));
            this.maxDetachedThreadsCountIncreasingStep = StaticComponentContainer.Objects.toInt(StaticComponentContainer.IterableObjectHelper.resolveValue(config, "thread-supplier.max-detached-threads-count.increasing-step"));
            if (this.maxDetachedThreadsCountIncreasingStep < 1) {
                this.poolableThreadRequestTimeout = 0L;
                config.put("thread-supplier.poolable-thread-request-timeout", (Object)this.poolableThreadRequestTimeout);
            }
            this.timeOfLastIncreaseOfMaxDetachedThreadsCount = Long.MAX_VALUE;
        }

        public Thread getOrCreate(String name) {
            Thread thread = this.getOrCreate();
            thread.setName(name);
            return thread;
        }

        public final Thread getOrCreate() {
            return this.getOrCreate(1);
        }

        public final Thread getOrCreate(int requestCount) {
            return this.getOrCreate(requestCount, requestCount);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final Thread getOrCreate(int initialValue, int requestCount) {
            Collection<Thread> collection;
            Thread thread = this.get();
            if (thread != null) {
                return thread;
            }
            if (requestCount > 0 && this.poolableThreadsCount >= (long)this.maxPoolableThreadsCount && this.threadsCount >= (long)this.maxThreadsCount) {
                collection = this.poolableSleepingThreads;
                synchronized (collection) {
                    try {
                        thread = this.get();
                        if (thread != null) {
                            return thread;
                        }
                        if (this.poolableThreadsCount >= (long)this.maxPoolableThreadsCount && this.threadsCount >= (long)this.maxThreadsCount) {
                            long startWaitTime = System.currentTimeMillis();
                            this.poolableSleepingThreads.wait(this.poolableThreadRequestTimeout);
                            if (this.maxDetachedThreadsCountIncreasingStep < 1) {
                                return this.getOrCreate(initialValue, requestCount);
                            }
                            long endWaitTime = System.currentTimeMillis();
                            long waitElapsedTime = endWaitTime - startWaitTime;
                            if (waitElapsedTime < this.poolableThreadRequestTimeout) {
                                if (this.inititialMaxThreadsCount < this.maxThreadsCount && System.currentTimeMillis() - this.timeOfLastIncreaseOfMaxDetachedThreadsCount > this.elapsedTimeThresholdFromLastIncreaseForGradualDecreasingOfMaxDetachedThreadsCount) {
                                    this.maxThreadsCount -= this.maxDetachedThreadsCountIncreasingStep / 2;
                                    StaticComponentContainer.ManagedLoggersRepository.logInfo(() -> this.getClass().getName(), "{}: decreasing maxTemporarilyThreadsCount to {}", java.lang.Thread.currentThread(), this.maxThreadsCount - this.maxPoolableThreadsCount);
                                    this.timeOfLastIncreaseOfMaxDetachedThreadsCount = Long.MAX_VALUE;
                                }
                                return this.getOrCreate(initialValue, requestCount);
                            }
                            this.timeOfLastIncreaseOfMaxDetachedThreadsCount = System.currentTimeMillis();
                            this.maxThreadsCount += this.maxDetachedThreadsCountIncreasingStep;
                            StaticComponentContainer.ManagedLoggersRepository.logInfo(() -> this.getClass().getName(), "{} waited for {}ms: maxTemporarilyThreadsCount will be temporarily increased to {} for preventing dead lock", java.lang.Thread.currentThread(), waitElapsedTime, this.maxThreadsCount - this.maxPoolableThreadsCount);
                            return this.getOrCreate(initialValue, --requestCount);
                        }
                    }
                    catch (InterruptedException exc) {
                        StaticComponentContainer.ManagedLoggersRepository.logError(() -> Thread.class.getName(), exc);
                    }
                }
            }
            if (this.poolableThreadsCount >= (long)this.maxPoolableThreadsCount) {
                if (this.threadsCount < (long)this.maxThreadsCount) {
                    return this.createDetachedThread();
                }
                return this.getOrCreate(initialValue, initialValue);
            }
            collection = this.poolableSleepingThreads;
            synchronized (collection) {
                if (this.poolableThreadsCount >= (long)this.maxPoolableThreadsCount) {
                    return this.getOrCreate(initialValue, requestCount);
                }
                return this.createPoolableThread();
            }
        }

        Thread createPoolableThread() {
            ++this.poolableThreadsCount;
            return new Thread(this, ++this.threadsCount){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object;
                    while (this.alive) {
                        object = this;
                        synchronized (object) {
                            runningThreads.add(this);
                        }
                        try {
                            this.executable.accept(this);
                        }
                        catch (Throwable exc) {
                            StaticComponentContainer.ManagedLoggersRepository.logError(() -> this.getClass().getName(), exc);
                        }
                        try {
                            1 exc = this;
                            synchronized (exc) {
                                runningThreads.remove(this);
                                this.executable = null;
                                if (!this.alive) {
                                    continue;
                                }
                                this.setIndexedName();
                                poolableSleepingThreads.add(this);
                                Collection collection = poolableSleepingThreads;
                                synchronized (collection) {
                                    poolableSleepingThreads.notifyAll();
                                }
                                this.wait();
                            }
                        }
                        catch (InterruptedException exc) {
                            StaticComponentContainer.ManagedLoggersRepository.logError(this.getClass()::getName, exc);
                        }
                    }
                    object = this;
                    synchronized (object) {
                        if (runningThreads.remove(this)) {
                            --this.supplier.threadsCount;
                            --this.supplier.poolableThreadsCount;
                        }
                    }
                    object = poolableSleepingThreads;
                    synchronized (object) {
                        poolableSleepingThreads.notifyAll();
                    }
                    object = this;
                    synchronized (object) {
                        this.notifyAll();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void interrupt() {
                    this.shutDown();
                    Object object = this;
                    synchronized (object) {
                        if (runningThreads.remove(this)) {
                            --this.supplier.threadsCount;
                            --this.supplier.poolableThreadsCount;
                        } else if (poolableSleepingThreads.remove(this)) {
                            --this.supplier.threadsCount;
                            --this.supplier.poolableThreadsCount;
                        }
                    }
                    try {
                        super.interrupt();
                    }
                    catch (Throwable exc) {
                        StaticComponentContainer.ManagedLoggersRepository.logError(this.getClass()::getName, "Exception occurred", exc);
                    }
                    object = poolableSleepingThreads;
                    synchronized (object) {
                        poolableSleepingThreads.notifyAll();
                    }
                    object = this;
                    synchronized (object) {
                        this.notifyAll();
                    }
                }
            };
        }

        Thread createDetachedThread() {
            return new Thread(this, ++this.threadsCount){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        runningThreads.add(this);
                        this.executable.accept(this);
                    }
                    catch (Throwable exc) {
                        StaticComponentContainer.ManagedLoggersRepository.logError(() -> this.getClass().getName(), exc);
                    }
                    Object object = this;
                    synchronized (object) {
                        if (runningThreads.remove(this)) {
                            --this.supplier.threadsCount;
                        }
                    }
                    object = poolableSleepingThreads;
                    synchronized (object) {
                        poolableSleepingThreads.notifyAll();
                    }
                    object = this;
                    synchronized (object) {
                        this.notifyAll();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void interrupt() {
                    this.shutDown();
                    Object object = this;
                    synchronized (object) {
                        if (runningThreads.remove(this)) {
                            --this.supplier.threadsCount;
                        }
                    }
                    try {
                        super.interrupt();
                    }
                    catch (Throwable exc) {
                        StaticComponentContainer.ManagedLoggersRepository.logError(this.getClass()::getName, "Exception occurred", exc);
                    }
                    object = poolableSleepingThreads;
                    synchronized (object) {
                        poolableSleepingThreads.notifyAll();
                    }
                    object = this;
                    synchronized (object) {
                        this.notifyAll();
                    }
                }
            };
        }

        private Thread get() {
            for (Thread thread : this.poolableSleepingThreads) {
                if (!this.poolableSleepingThreads.remove(thread)) continue;
                return thread;
            }
            return null;
        }

        public void shutDownAllPoolableSleeping() {
            Iterator<Thread> itr = this.poolableSleepingThreads.iterator();
            while (itr.hasNext()) {
                itr.next().shutDown();
            }
        }

        public void shutDownAll() {
            Iterator<Thread> itr = this.poolableSleepingThreads.iterator();
            while (itr.hasNext()) {
                itr.next().shutDown();
            }
            itr = this.runningThreads.iterator();
            while (itr.hasNext()) {
                itr.next().shutDown();
            }
        }

        public static Supplier create(String name, Properties config, boolean undestroyable) {
            if (undestroyable) {
                return new Supplier(name, config){
                    StackTraceElement[] stackTraceOnCreation = Thread.currentThread().getStackTrace();

                    @Override
                    public void shutDownAll() {
                        if (StaticComponentContainer.Methods.retrieveExternalCallerInfo().getClassName().equals(StaticComponentContainer.Methods.retrieveExternalCallerInfo(this.stackTraceOnCreation).getClassName())) {
                            super.shutDownAll();
                        }
                    }
                };
            }
            return new Supplier(name, config);
        }

        public static class Configuration {
            public static final Map<String, Object> DEFAULT_VALUES;

            static {
                HashMap<String, Object> defaultValues = new HashMap<String, Object>();
                defaultValues.put("thread-supplier.max-poolable-threads-count", "autodetect");
                defaultValues.put("thread-supplier.max-detached-threads-count", "autodetect");
                defaultValues.put("thread-supplier.poolable-thread-request-timeout", 6000);
                defaultValues.put("thread-supplier.default-daemon-flag-value", true);
                defaultValues.put("thread-supplier.max-detached-threads-count.elapsed-time-threshold-from-last-increase-for-gradual-decreasing-to-initial-value", 30000);
                defaultValues.put("thread-supplier.max-detached-threads-count.increasing-step", 8);
                DEFAULT_VALUES = Collections.unmodifiableMap(defaultValues);
            }

            public static class Key {
                public static final String MAX_POOLABLE_THREADS_COUNT = "thread-supplier.max-poolable-threads-count";
                public static final String MAX_DETACHED_THREADS_COUNT = "thread-supplier.max-detached-threads-count";
                public static final String DEFAULT_DAEMON_FLAG_VALUE = "thread-supplier.default-daemon-flag-value";
                public static final String POOLABLE_THREAD_REQUEST_TIMEOUT = "thread-supplier.poolable-thread-request-timeout";
                public static final String MAX_DETACHED_THREADS_COUNT_ELAPSED_TIME_THRESHOLD_FROM_LAST_INCREASE_FOR_GRADUAL_DECREASING_TO_INITIAL_VALUE = "thread-supplier.max-detached-threads-count.elapsed-time-threshold-from-last-increase-for-gradual-decreasing-to-initial-value";
                public static final String MAX_DETACHED_THREADS_COUNT_INCREASING_STEP = "thread-supplier.max-detached-threads-count.increasing-step";
            }
        }
    }

    public static class Holder
    implements Closeable,
    ManagedLogger {
        private Supplier threadSupplier;
        private Map<String, Thread> threads;

        public Holder() {
            this(StaticComponentContainer.ThreadSupplier);
        }

        public Holder(Supplier threadSupplier) {
            this.threadSupplier = threadSupplier;
            this.threads = new ConcurrentHashMap<String, Thread>();
        }

        public String startLooping(boolean isDaemon, int priority, Consumer<Thread> executable) {
            return this.start(null, true, isDaemon, priority, executable).getName();
        }

        public String start(boolean isDaemon, int priority, Consumer<Thread> executable) {
            return this.start(null, false, isDaemon, priority, executable).getName();
        }

        public void startLooping(String threadName, boolean isDaemon, int priority, Consumer<Thread> executable) {
            this.start(threadName, true, isDaemon, priority, executable);
        }

        public void start(String threadName, boolean isDaemon, int priority, Consumer<Thread> executable) {
            this.start(threadName, false, isDaemon, priority, executable);
        }

        private Thread start(String threadName, boolean isLooper, boolean isDaemon, int priority, Consumer<Thread> executable) {
            return StaticComponentContainer.Synchronizer.execute(threadName, () -> {
                Thread thr = this.threads.get(threadName);
                if (thr != null) {
                    this.stop(threadName);
                }
                thr = this.threadSupplier.createDetachedThread().setExecutable(thread -> {
                    try {
                        executable.accept((Thread)thread);
                    }
                    catch (Throwable exc) {
                        StaticComponentContainer.ManagedLoggersRepository.logError(this.getClass()::getName, exc);
                    }
                }, isLooper);
                if (threadName != null) {
                    thr.setName(threadName);
                }
                thr.setPriority(priority);
                thr.setDaemon(isDaemon);
                this.threads.put(threadName, thr);
                thr.start();
                return thr;
            });
        }

        public void stop(String threadName) {
            this.stop(threadName, false);
        }

        public void stop(String threadName, boolean waitThreadToFinish) {
            StaticComponentContainer.Synchronizer.execute(threadName, () -> {
                Thread thr = this.threads.get(threadName);
                if (thr == null) {
                    return;
                }
                this.threads.remove(threadName);
                thr.shutDown(waitThreadToFinish);
                thr = null;
            });
        }

        public void join(String threadName) {
            Thread thr = this.threads.get(threadName);
            if (thr != null) {
                try {
                    thr.join();
                }
                catch (InterruptedException exc) {
                    StaticComponentContainer.ManagedLoggersRepository.logError(this.getClass()::getName, exc);
                }
            }
        }

        public boolean isAlive(String threadName) {
            Thread thr = this.threads.get(threadName);
            if (thr != null) {
                return thr.alive;
            }
            return false;
        }

        @Override
        public void close() {
            this.threads.forEach((threadName, thread) -> {
                thread.shutDown();
                this.threads.remove(threadName);
            });
            this.threads = null;
            this.threadSupplier = null;
        }
    }
}

