/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.core.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.nio.ByteBuffer;
import org.burningwave.core.Component;
import org.burningwave.core.assembler.StaticComponentContainer;
import org.burningwave.core.function.Executor;
import org.burningwave.core.io.FileSystemItemNotFoundException;

public class FileInputStream
extends java.io.FileInputStream
implements Component {
    private File file;
    private String absolutePath;

    private FileInputStream(File file) throws FileNotFoundException {
        super(file);
        this.file = file;
        this.absolutePath = StaticComponentContainer.Paths.clean(file.getAbsolutePath());
    }

    private FileInputStream(String absolutePath) throws FileNotFoundException {
        this(absolutePath != null ? new File(absolutePath) : null);
    }

    public static FileInputStream create(File file) {
        try {
            return new FileInputStream(file);
        }
        catch (FileNotFoundException exc) {
            return (FileInputStream)StaticComponentContainer.Throwables.throwException(new FileSystemItemNotFoundException(exc), new Object[0]);
        }
    }

    public static FileInputStream create(String absolutePath) {
        try {
            return new FileInputStream(absolutePath);
        }
        catch (FileNotFoundException exc) {
            return (FileInputStream)StaticComponentContainer.Throwables.throwException(new FileSystemItemNotFoundException(exc), new Object[0]);
        }
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public void close() {
        Executor.run(() -> super.close());
        this.file = null;
        this.absolutePath = null;
    }

    public String getAbsolutePath() {
        return this.absolutePath;
    }

    public byte[] toByteArray() {
        return StaticComponentContainer.Streams.toByteArray(this);
    }

    public ByteBuffer toByteBuffer() {
        return StaticComponentContainer.Cache.pathForContents.getOrUploadIfAbsent(this.file.getAbsolutePath(), () -> StaticComponentContainer.Streams.toByteBuffer(this));
    }
}

