/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.core.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.UUID;
import org.burningwave.core.Closeable;
import org.burningwave.core.Component;
import org.burningwave.core.ManagedLogger;
import org.burningwave.core.assembler.StaticComponentContainer;
import org.burningwave.core.function.Executor;

public class FileSystemHelper
implements Component {
    private String name;
    private File mainTemporaryFolder;
    private String id;
    private Scavenger scavenger;

    private FileSystemHelper(String name) {
        this.name = name;
        this.id = UUID.randomUUID().toString() + "_" + System.currentTimeMillis();
    }

    public static FileSystemHelper create(String name) {
        return new FileSystemHelper(name);
    }

    public void clearBurningwaveTemporaryFolder() {
        this.delete(Arrays.asList(this.getOrCreateBurningwaveTemporaryFolder().listFiles()));
    }

    public void clearMainTemporaryFolder() {
        this.delete(this.getOrCreateMainTemporaryFolder());
    }

    public File getOrCreateBurningwaveTemporaryFolder() {
        return this.getOrCreateMainTemporaryFolder().getParentFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getOrCreateMainTemporaryFolder() {
        if (this.mainTemporaryFolder != null && this.mainTemporaryFolder.exists()) {
            return this.mainTemporaryFolder;
        }
        FileSystemHelper fileSystemHelper = this;
        synchronized (fileSystemHelper) {
            if (this.mainTemporaryFolder != null && this.mainTemporaryFolder.exists()) {
                return this.mainTemporaryFolder;
            }
            this.mainTemporaryFolder = Executor.get(() -> {
                File toDelete = File.createTempFile("_BW_TEMP_", "_temp");
                File tempFolder = toDelete.getParentFile();
                File folder = new File(tempFolder.getAbsolutePath() + "/Burningwave/" + this.id);
                if (!folder.exists()) {
                    folder.mkdirs();
                    folder.deleteOnExit();
                }
                toDelete.delete();
                return folder;
            });
            return this.mainTemporaryFolder;
        }
    }

    public File getOrCreatePingFile() {
        File pingFile = new File(StaticComponentContainer.Paths.clean(this.getOrCreateBurningwaveTemporaryFolder().getAbsolutePath() + "/" + this.id + ".ping"));
        if (!pingFile.exists()) {
            Executor.run(() -> pingFile.createNewFile());
            pingFile.deleteOnExit();
        }
        return pingFile;
    }

    public File createTemporaryFolder(String folderName) {
        return Executor.get(() -> {
            File tempFolder = new File(this.getOrCreateMainTemporaryFolder().getAbsolutePath() + "/" + folderName);
            if (tempFolder.exists()) {
                tempFolder.delete();
            }
            tempFolder.mkdirs();
            return tempFolder;
        });
    }

    @Override
    public File getOrCreateTemporaryFolder(String folderName) {
        return Executor.get(() -> {
            File tempFolder = new File(this.getOrCreateMainTemporaryFolder().getAbsolutePath() + "/" + folderName);
            if (!tempFolder.exists()) {
                tempFolder.mkdirs();
            }
            return tempFolder;
        });
    }

    public void delete(Collection<File> files) {
        if (files != null) {
            for (File file : files) {
                if (!file.exists()) continue;
                this.delete(file);
            }
        }
    }

    public boolean delete(File file) {
        File[] files;
        if (file.isDirectory() && (files = file.listFiles()) != null) {
            for (File fsItem : files) {
                this.delete(fsItem);
            }
        }
        if (!file.delete()) {
            file.deleteOnExit();
            return false;
        }
        return true;
    }

    public void deleteOnExit(File file) {
        File[] files;
        if (file.isDirectory() && (files = file.listFiles()) != null) {
            for (File fsItem : files) {
                this.deleteOnExit(fsItem);
            }
        }
        file.deleteOnExit();
    }

    public boolean delete(String absolutePath) {
        return this.delete(new File(absolutePath));
    }

    public void deleteOnExit(String absolutePath) {
        this.deleteOnExit(new File(absolutePath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startSweeping() {
        if (this.scavenger == null) {
            FileSystemHelper fileSystemHelper = this;
            synchronized (fileSystemHelper) {
                if (this.scavenger == null) {
                    this.scavenger = new Scavenger(this, this.getTemporaryFileScavengerThreadName(), 3600000L, 30000L);
                }
            }
        }
        this.scavenger.start();
    }

    public void stopSweeping() {
        if (this.scavenger != null) {
            this.scavenger.stop();
        }
    }

    private String getTemporaryFileScavengerThreadName() {
        return Optional.ofNullable(this.name).map(nm -> nm + " - ").orElseGet(() -> "") + "Temporary file scavenger";
    }

    @Override
    public void close() {
        if (this != StaticComponentContainer.FileSystemHelper || StaticComponentContainer.Methods.retrieveExternalCallerInfo().getClassName().equals(StaticComponentContainer.class.getName())) {
            Scavenger scavenger = this.scavenger;
            if (scavenger != null) {
                scavenger.close();
            }
            this.closeResources(() -> this.id == null, () -> {
                this.clearMainTemporaryFolder();
                this.scavenger = null;
                this.id = null;
                this.mainTemporaryFolder = null;
            });
        } else {
            StaticComponentContainer.Throwables.throwException("Could not close singleton instance {}", this);
        }
    }

    public static class Scavenger
    implements ManagedLogger,
    Closeable {
        private String name;
        private FileSystemHelper fileSystemHelper;
        private long deletingInterval;
        private long waitInterval;
        private File burningwaveTemporaryFolder;
        long lastDeletionStartTime;

        private Scavenger(FileSystemHelper fileSystemHelper, String name, long deletingInterval, long waitInterval) {
            this.fileSystemHelper = fileSystemHelper;
            this.deletingInterval = deletingInterval;
            this.waitInterval = waitInterval;
            this.burningwaveTemporaryFolder = fileSystemHelper.getOrCreateBurningwaveTemporaryFolder();
            this.name = name;
        }

        public boolean isAlive() {
            return StaticComponentContainer.ThreadHolder.isAlive(this.name);
        }

        void pingAndDelete() {
            try {
                this.setPingTime(this.fileSystemHelper.getOrCreatePingFile().getAbsolutePath());
            }
            catch (Throwable exc) {
                StaticComponentContainer.ManagedLoggersRepository.logError(this.getClass()::getName, "Exception occurred while setting ping time on file " + this.fileSystemHelper.getOrCreatePingFile().getAbsolutePath());
                StaticComponentContainer.ManagedLoggersRepository.logError(this.getClass()::getName, exc.getMessage());
                StaticComponentContainer.ManagedLoggersRepository.logInfo(this.getClass()::getName, "Current execution id: {}", this.fileSystemHelper.id);
            }
            if (System.currentTimeMillis() - this.lastDeletionStartTime > this.deletingInterval) {
                this.lastDeletionStartTime = System.currentTimeMillis();
                for (File fileSystemItem : this.burningwaveTemporaryFolder.listFiles()) {
                    if (fileSystemItem.getName().equals(this.fileSystemHelper.getOrCreateMainTemporaryFolder().getName()) || fileSystemItem.getName().equals(this.fileSystemHelper.getOrCreatePingFile().getName())) continue;
                    try {
                        try {
                            if (fileSystemItem.isDirectory()) {
                                File pingFile = new File(this.burningwaveTemporaryFolder.getAbsolutePath() + "/" + fileSystemItem.getName() + ".ping");
                                long pingTime = this.getCreationTime(fileSystemItem.getName());
                                if (pingFile.exists()) {
                                    pingTime = this.getOrSetPingTime(pingFile);
                                }
                                if (System.currentTimeMillis() - pingTime >= this.deletingInterval) {
                                    this.delete(fileSystemItem);
                                }
                                continue;
                            }
                            if (!fileSystemItem.getName().endsWith("ping")) continue;
                            long pingTime = this.getOrSetPingTime(fileSystemItem);
                            if (System.currentTimeMillis() - pingTime < this.deletingInterval) continue;
                            this.delete(fileSystemItem);
                        }
                        catch (Throwable exc) {
                            StaticComponentContainer.ManagedLoggersRepository.logWarn(this.getClass()::getName, "Exception occurred while cleaning temporary file system item '{}'", fileSystemItem.getAbsolutePath());
                            if (fileSystemItem.getName().contains("null")) {
                                StaticComponentContainer.ManagedLoggersRepository.logInfo(this.getClass()::getName, "Trying to force deleting of '{}'", fileSystemItem.getAbsolutePath());
                                this.delete(fileSystemItem);
                                continue;
                            }
                            throw exc;
                        }
                    }
                    catch (Throwable exc) {
                        StaticComponentContainer.ManagedLoggersRepository.logError(this.getClass()::getName, "Could not delete '{}' automatically, To avoid this error remove it manually", fileSystemItem.getAbsolutePath());
                        StaticComponentContainer.ManagedLoggersRepository.logInfo(this.getClass()::getName, "Current execution id: {}", this.fileSystemHelper.id);
                    }
                }
            }
        }

        public void start() {
            this.lastDeletionStartTime = -1L;
            StaticComponentContainer.ThreadHolder.startLooping(this.name, true, 1, thread -> {
                this.pingAndDelete();
                thread.waitFor(this.waitInterval);
            });
        }

        long getOrSetPingTime(File pingFile) throws IOException {
            long pingTime = -1L;
            try {
                pingTime = this.getPingTime(pingFile);
            }
            catch (Throwable exc) {
                StaticComponentContainer.ManagedLoggersRepository.logError(this.getClass()::getName, "Exception occurred while getting ping time on file " + pingFile.getAbsolutePath());
                StaticComponentContainer.ManagedLoggersRepository.logError(this.getClass()::getName, exc.getMessage());
                StaticComponentContainer.ManagedLoggersRepository.logInfo(this.getClass()::getName, "Current execution id: {}", this.fileSystemHelper.id);
                pingTime = this.setPingTime(pingFile.getAbsolutePath());
                StaticComponentContainer.ManagedLoggersRepository.logInfo(this.getClass()::getName, "Ping time reset to {} for file {}", pingTime, pingFile.getAbsolutePath());
            }
            return pingTime;
        }

        long setPingTime(String absolutePath) throws IOException {
            long pingTime = System.currentTimeMillis();
            Files.write(Paths.get(absolutePath, new String[0]), (String.valueOf(pingTime) + ";").getBytes(), StandardOpenOption.TRUNCATE_EXISTING);
            return this.getPingTime(new File(absolutePath));
        }

        Long getCreationTime(String resourceName) {
            return Long.valueOf(resourceName.split("_")[1]);
        }

        void delete(File resource) {
            this.fileSystemHelper.delete(resource.getAbsolutePath());
        }

        long getPingTime(File pingFile) throws IOException {
            long pingTime;
            try (FileInputStream pingFileAsInputStream = new FileInputStream(pingFile);){
                StringBuffer content = StaticComponentContainer.Streams.getAsStringBuffer(pingFileAsInputStream);
                pingTime = Long.valueOf(content.toString().split(";")[0]);
            }
            return pingTime;
        }

        public void stop() {
            StaticComponentContainer.ThreadHolder.stop(this.name);
        }

        @Override
        public void close() {
            this.closeResources(() -> this.burningwaveTemporaryFolder == null, () -> {
                this.stop();
                this.burningwaveTemporaryFolder = null;
                this.fileSystemHelper = null;
            });
        }
    }
}

