/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.core.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.burningwave.core.Criteria;
import org.burningwave.core.assembler.StaticComponentContainer;
import org.burningwave.core.function.Executor;
import org.burningwave.core.io.ByteBufferInputStream;
import org.burningwave.core.io.FileInputStream;
import org.burningwave.core.io.FileSystemItemNotFoundException;
import org.burningwave.core.io.IterableZipContainer;

public class FileSystemItem {
    private static final String instanceIdPrefix = FileSystemItem.class.getName();
    private Map.Entry<String, String> absolutePath;
    private FileSystemItem parent;
    private FileSystemItem parentContainer;
    private Set<FileSystemItem> children;
    private Set<FileSystemItem> allChildren;
    private String instanceId;

    public static FileSystemItem of(File file) {
        return FileSystemItem.ofPath(file.getAbsolutePath());
    }

    public static FileSystemItem of(URL realAbsolutePath) {
        return FileSystemItem.ofPath(StaticComponentContainer.Paths.convertURLPathToAbsolutePath(realAbsolutePath.getPath()));
    }

    public static FileSystemItem ofPath(String realAbsolutePath) {
        return FileSystemItem.ofPath(realAbsolutePath, null);
    }

    static FileSystemItem ofPath(String realAbsolutePath, String conventionedAbsolutePath) {
        String realAbsolutePathCleaned = StaticComponentContainer.Paths.normalizeAndClean(realAbsolutePath);
        FileSystemItem fileSystemItem = StaticComponentContainer.Cache.pathForFileSystemItems.getOrUploadIfAbsent(realAbsolutePathCleaned, () -> {
            if (StaticComponentContainer.Strings.isNotEmpty(realAbsolutePathCleaned)) {
                return new FileSystemItem(realAbsolutePathCleaned, conventionedAbsolutePath);
            }
            return null;
        });
        if (fileSystemItem.absolutePath.getValue() == null && conventionedAbsolutePath != null) {
            fileSystemItem.absolutePath.setValue(conventionedAbsolutePath);
        }
        return fileSystemItem;
    }

    private FileSystemItem(String realAbsolutePath, String conventionedAbsolutePath) {
        realAbsolutePath = StaticComponentContainer.Paths.clean(realAbsolutePath);
        this.absolutePath = new AbstractMap.SimpleEntry<String, String>(realAbsolutePath, conventionedAbsolutePath);
        this.instanceId = instanceIdPrefix + "_" + System.currentTimeMillis() + "_" + realAbsolutePath;
    }

    private String computeConventionedAbsolutePath() {
        String conventionedAbsolutePath = this.absolutePath.getValue();
        FileSystemItem parentContainer = this.parentContainer;
        String absolutePath = this.absolutePath.getKey();
        if (conventionedAbsolutePath == null || parentContainer == null) {
            conventionedAbsolutePath = StaticComponentContainer.Synchronizer.execute(absolutePath, () -> {
                FileSystemItem parentContainerTemp = this.parentContainer;
                String conventionedAbsolutePathTemp = this.absolutePath.getValue();
                if (conventionedAbsolutePathTemp == null || parentContainerTemp == null) {
                    if (parentContainerTemp != null && parentContainerTemp.isArchive()) {
                        ByteBuffer parentContainerContent = parentContainerTemp.toByteBuffer();
                        String relativePath = absolutePath.replace(parentContainerTemp.getAbsolutePath() + "/", "");
                        conventionedAbsolutePathTemp = parentContainerTemp.computeConventionedAbsolutePath() + this.retrieveConventionedRelativePath(parentContainerContent, parentContainerTemp.getAbsolutePath(), relativePath);
                        this.absolutePath.setValue(conventionedAbsolutePathTemp);
                    } else {
                        conventionedAbsolutePathTemp = this.retrieveConventionedAbsolutePath(absolutePath, "");
                        this.absolutePath.setValue(conventionedAbsolutePathTemp);
                    }
                }
                return conventionedAbsolutePathTemp;
            });
        }
        if (conventionedAbsolutePath == null) {
            this.destroy();
        }
        return conventionedAbsolutePath;
    }

    public FileSystemItem copyAllChildrenTo(String folder) {
        return this.copyAllChildrenTo(folder, null);
    }

    public FileSystemItem copyAllChildrenTo(String folder, Criteria filter) {
        Criteria finalFilter = Criteria.forAllFileThat(fileSystemItem -> !fileSystemItem.isArchive());
        finalFilter = filter != null ? finalFilter.and(filter) : finalFilter;
        Collection<FileSystemItem> allChildren = this.findInAllChildren(finalFilter);
        for (FileSystemItem child : allChildren) {
            FileSystemItem destFile = FileSystemItem.ofPath(folder + child.getAbsolutePath().replaceFirst(this.getAbsolutePath(), ""));
            if (child.isFolder()) {
                File file = new File(destFile.getAbsolutePath());
                if (file.exists()) continue;
                file.mkdirs();
                continue;
            }
            StaticComponentContainer.Streams.store(destFile.getParent().getAbsolutePath() + "/" + child.getName(), child.toByteBuffer());
        }
        return FileSystemItem.ofPath(folder).refresh();
    }

    public FileSystemItem copyTo(String folder) {
        return this.copyTo(folder, null);
    }

    public FileSystemItem copyTo(String folder, Criteria filter) {
        FileSystemItem destination = null;
        if (this.isFile()) {
            if (filter == null || filter.testWithFalseResultForNullEntityOrTrueResultForNullPredicate(new FileSystemItem[]{this, this})) {
                destination = StaticComponentContainer.Streams.store(folder + "/" + this.getName(), this.toByteBuffer());
            }
        } else {
            File file = new File(folder + "/" + this.getName());
            file.mkdirs();
            for (FileSystemItem fileSystemItem : filter == null ? this.getChildren() : this.findInChildren(filter)) {
                fileSystemItem.copyTo(file.getAbsolutePath(), filter);
            }
            destination = FileSystemItem.ofPath(file.getAbsolutePath());
        }
        return destination;
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof FileSystemItem && ((FileSystemItem)obj).getAbsolutePath().equals(this.getAbsolutePath());
    }

    public boolean exists() {
        String conventionedAbsolutePath = this.absolutePath.getValue();
        if (conventionedAbsolutePath == null) {
            conventionedAbsolutePath = this.computeConventionedAbsolutePath();
        }
        return conventionedAbsolutePath != null;
    }

    private void extractAndAddAllFoldersName(Set<String> folderRelPaths, String path) {
        String folder;
        int lastIndexOfSlash = path.lastIndexOf("/");
        if (lastIndexOfSlash != 1 && lastIndexOfSlash > 0 && !folderRelPaths.contains(folder = path.substring(0, lastIndexOfSlash))) {
            folderRelPaths.add(folder);
            this.extractAndAddAllFoldersName(folderRelPaths, folder);
        }
    }

    public Collection<FileSystemItem> findInAllChildren(Criteria filter) {
        return this.findIn(this::getAllChildren0, filter, HashSet::new);
    }

    public Collection<FileSystemItem> findInAllChildren(Criteria filter, Supplier<Collection<FileSystemItem>> setSupplier) {
        return this.findIn(this::getAllChildren0, filter, setSupplier);
    }

    public Collection<FileSystemItem> findInChildren(Criteria filter) {
        return this.findIn(this::getChildren0, filter, HashSet::new);
    }

    public Collection<FileSystemItem> findInChildren(Criteria filter, Supplier<Collection<FileSystemItem>> setSupplier) {
        return this.findIn(this::getChildren0, filter, setSupplier);
    }

    private Collection<FileSystemItem> findIn(Supplier<Set<FileSystemItem>> childrenSupplier, Criteria filter, Supplier<Collection<FileSystemItem>> outputCollectionSupplier) {
        Set<FileSystemItem> children;
        try {
            children = childrenSupplier.get();
        }
        catch (Throwable exc) {
            StaticComponentContainer.ManagedLoggersRepository.logWarn(this.getClass()::getName, "Exception occurred while retrieving children of {}: ", this.getAbsolutePath(), StaticComponentContainer.Strings.formatMessage(exc));
            StaticComponentContainer.ManagedLoggersRepository.logInfo(this.getClass()::getName, "Trying to reset {} and reload children/all children", this.getAbsolutePath());
            this.reset();
            children = childrenSupplier.get();
        }
        if (children == null) {
            return null;
        }
        Predicate<FileSystemItem[]> nativePredicate = filter.getOriginalPredicateOrTruePredicateIfPredicateIsNull();
        ConcurrentHashMap.KeySetView iteratedFISWithErrors = ConcurrentHashMap.newKeySet();
        BiFunction customExceptionHandler = filter.exceptionHandler;
        Predicate<FileSystemItem> filterPredicate = child -> {
            try {
                return nativePredicate.test(new FileSystemItem[]{child, this});
            }
            catch (ArrayIndexOutOfBoundsException | NullPointerException exc) {
                iteratedFISWithErrors.add(child);
                return false;
            }
            catch (Throwable exc) {
                if (customExceptionHandler == null) {
                    throw exc;
                }
                iteratedFISWithErrors.add(child);
                return false;
            }
        };
        Collection<FileSystemItem> result = StaticComponentContainer.IterableObjectHelper.iterateParallelIf(children, (child, collector) -> {
            if (filterPredicate.test((FileSystemItem)child)) {
                collector.accept(child);
            }
        }, outputCollectionSupplier.get(), items -> items.size() > 1);
        if (!iteratedFISWithErrors.isEmpty()) {
            Predicate<FileSystemItem[]> nativePredicateWithExceptionManaging = filter.getPredicateOrTruePredicateIfPredicateIsNull();
            for (FileSystemItem child2 : iteratedFISWithErrors) {
                FileSystemItem[] childAndThis = new FileSystemItem[]{child2, this};
                if (!nativePredicateWithExceptionManaging.test(childAndThis)) continue;
                result.add(child2);
            }
            iteratedFISWithErrors.clear();
        }
        return result;
    }

    public FileSystemItem findFirstInAllChildren() {
        return this.findFirstInAllChildren(Criteria.create());
    }

    public FileSystemItem findFirstInAllChildren(Criteria filter) {
        return this.findFirstInChildren(this::getAllChildren0, filter);
    }

    public FileSystemItem findFirstInChildren() {
        return this.findFirstInAllChildren(Criteria.create());
    }

    public FileSystemItem findFirstInChildren(Criteria filter) {
        return this.findFirstInChildren(this::getChildren0, filter);
    }

    private FileSystemItem findFirstInChildren(Supplier<Set<FileSystemItem>> childrenSupplier, Criteria filter) {
        Predicate<FileSystemItem[]> filterPredicate = filter.getPredicateOrTruePredicateIfPredicateIsNull();
        FileSystemItem[] childAndThis = new FileSystemItem[]{null, this};
        Iterator<FileSystemItem> iterator = childrenSupplier.get().iterator();
        while (iterator.hasNext()) {
            FileSystemItem fileSystemItem;
            childAndThis[0] = fileSystemItem = iterator.next();
            if (!filterPredicate.test(childAndThis)) continue;
            return fileSystemItem;
        }
        return null;
    }

    public String getAbsolutePath() {
        return this.absolutePath.getKey();
    }

    public Set<FileSystemItem> getAllChildren() {
        return Optional.ofNullable(this.getAllChildren0()).map(children -> Collections.unmodifiableSet(children)).orElseGet(() -> null);
    }

    private Set<FileSystemItem> getAllChildren0() {
        Set allChildren = this.allChildren;
        if (allChildren == null) {
            allChildren = StaticComponentContainer.Synchronizer.execute(this.instanceId, () -> {
                Set<FileSystemItem> allChildrenTemp = this.allChildren;
                if (allChildrenTemp == null) {
                    allChildrenTemp = this.allChildren = this.loadAllChildren();
                }
                return allChildrenTemp;
            });
        }
        return allChildren;
    }

    public Set<FileSystemItem> getChildren() {
        return Optional.ofNullable(this.getChildren0()).map(children -> Collections.unmodifiableSet(children)).orElseGet(() -> null);
    }

    private Set<FileSystemItem> getChildren0() {
        Set children = this.children;
        if (children == null) {
            children = StaticComponentContainer.Synchronizer.execute(this.instanceId, () -> {
                Set<FileSystemItem> childrenTemp = this.children;
                if (childrenTemp == null) {
                    childrenTemp = this.children = this.loadChildren();
                }
                return childrenTemp;
            });
        }
        return children;
    }

    public String getExtension() {
        String extension = null;
        String name = this.getName();
        if (!this.isFolder() && name.contains(".")) {
            extension = name.substring(name.lastIndexOf(".") + 1);
        }
        return extension;
    }

    public String getName() {
        String absolutePath = this.getAbsolutePath();
        if (!this.isRoot()) {
            return absolutePath.substring(absolutePath.lastIndexOf("/") + 1);
        }
        return absolutePath.substring(0, absolutePath.lastIndexOf("/"));
    }

    public FileSystemItem getParent() {
        FileSystemItem parent = this.parent;
        if (parent != null) {
            return parent;
        }
        if (this.isRoot()) {
            return null;
        }
        String conventionedPath = this.absolutePath.getValue();
        if (conventionedPath != null) {
            if (conventionedPath.endsWith("/")) {
                int offset = -1;
                if (conventionedPath.endsWith("///")) {
                    offset = -"///".length();
                }
                conventionedPath = conventionedPath.substring(0, conventionedPath.length() + offset);
            }
            conventionedPath = conventionedPath.substring(0, conventionedPath.lastIndexOf("/")) + "/";
            return FileSystemItem.ofPath(this.absolutePath.getKey().substring(0, this.absolutePath.getKey().lastIndexOf("/")), conventionedPath);
        }
        String absolutePath = this.getAbsolutePath();
        String parentAbsolutePath = absolutePath.substring(0, absolutePath.lastIndexOf("/"));
        if (this.isRoot(parentAbsolutePath)) {
            parentAbsolutePath = parentAbsolutePath.length() > 0 ? parentAbsolutePath : "/";
        }
        this.parent = FileSystemItem.ofPath(parentAbsolutePath);
        return this.parent;
    }

    public FileSystemItem getParentContainer() {
        FileSystemItem parentContainer = this.parentContainer;
        if (parentContainer != null) {
            return parentContainer;
        }
        this.computeConventionedAbsolutePath();
        parentContainer = this.parentContainer;
        if (parentContainer == null) {
            parentContainer = this.getParent();
        }
        return parentContainer;
    }

    public URL getURL() {
        try {
            return new URL(this.toURL());
        }
        catch (MalformedURLException exc) {
            return (URL)StaticComponentContainer.Throwables.throwException(exc, new Object[0]);
        }
    }

    public boolean isArchive() {
        String conventionedAbsolutePath = this.computeConventionedAbsolutePath();
        return conventionedAbsolutePath.endsWith("///");
    }

    public boolean isChildOf(FileSystemItem fileSystemItem) {
        String conventionedAbsolutePath_01 = this.computeConventionedAbsolutePath();
        String conventionedAbsolutePath_02 = fileSystemItem.computeConventionedAbsolutePath();
        if (fileSystemItem.isContainer() && this.isContainer()) {
            return conventionedAbsolutePath_01.startsWith(conventionedAbsolutePath_02) && !conventionedAbsolutePath_02.equals(conventionedAbsolutePath_01);
        }
        if (fileSystemItem.isContainer() && !this.isContainer()) {
            return conventionedAbsolutePath_01.startsWith(conventionedAbsolutePath_02);
        }
        return false;
    }

    public boolean isCompressed() {
        String conventionedAbsolutePath = this.computeConventionedAbsolutePath();
        return conventionedAbsolutePath.contains("///") && !conventionedAbsolutePath.endsWith("///") || conventionedAbsolutePath.contains("///") && conventionedAbsolutePath.endsWith("///") && conventionedAbsolutePath.indexOf("///") != conventionedAbsolutePath.lastIndexOf("///");
    }

    public boolean isContainer() {
        String conventionedAbsolutePath = this.computeConventionedAbsolutePath();
        try {
            return conventionedAbsolutePath.endsWith("/");
        }
        catch (NullPointerException e) {
            throw new NotFoundException(StaticComponentContainer.Strings.compile("{} not found on the file system", this.absolutePath.getKey()));
        }
    }

    public boolean isFile() {
        return !this.isFolder();
    }

    public boolean isFolder() {
        String conventionedAbsolutePath = this.computeConventionedAbsolutePath();
        return conventionedAbsolutePath.endsWith("/") && !conventionedAbsolutePath.endsWith("///");
    }

    public boolean isParentOf(FileSystemItem fileSystemItem) {
        String conventionedAbsolutePath_01 = this.computeConventionedAbsolutePath();
        String conventionedAbsolutePath_02 = fileSystemItem.computeConventionedAbsolutePath();
        if (fileSystemItem.isContainer() && this.isContainer()) {
            return conventionedAbsolutePath_02.startsWith(conventionedAbsolutePath_01) && !conventionedAbsolutePath_02.equals(conventionedAbsolutePath_01);
        }
        if (!fileSystemItem.isContainer() && this.isContainer()) {
            return conventionedAbsolutePath_02.startsWith(conventionedAbsolutePath_01);
        }
        return false;
    }

    public boolean isRoot() {
        return this.isRoot(this.getAbsolutePath());
    }

    private boolean isRoot(String absolutePathStr) {
        return absolutePathStr.chars().filter(ch -> ch == 47).count() == 0L || absolutePathStr.equals("/");
    }

    Set<FileSystemItem> loadAllChildren() {
        if (this.isContainer()) {
            Set<FileSystemItem> children;
            if (this.isCompressed() || this.isArchive()) {
                Predicate<IterableZipContainer.Entry> zipEntryPredicate = null;
                FileSystemItem parentContainerTemp = this;
                if (this.isArchive()) {
                    zipEntryPredicate = zEntry -> !zEntry.getName().equals("/");
                } else if (this.isFolder()) {
                    parentContainerTemp = this.parentContainer;
                    zipEntryPredicate = zEntry -> zEntry.getAbsolutePath().startsWith(this.getAbsolutePath() + "/");
                }
                FileSystemItem parentContainer = parentContainerTemp;
                boolean isJModArchive = StaticComponentContainer.Streams.isJModArchive(parentContainer.toByteBuffer());
                try (IterableZipContainer zipInputStream = IterableZipContainer.create(parentContainer.getAbsolutePath(), parentContainer.toByteBuffer());){
                    HashSet folderRelPaths = new HashSet();
                    ConcurrentHashMap.KeySetView allChildren = ConcurrentHashMap.newKeySet();
                    zipInputStream.findAllAndConvert(() -> allChildren, zipEntryPredicate, zEntry -> {
                        FileSystemItem fileSystemItem = FileSystemItem.ofPath(parentContainer.getAbsolutePath() + "/" + zEntry.getName());
                        fileSystemItem.absolutePath.setValue(parentContainer.computeConventionedAbsolutePath() + this.retrieveConventionedRelativePath(fileSystemItem, zipInputStream, (IterableZipContainer.Entry)zEntry, zEntry.getCleanedName()));
                        if (fileSystemItem.isArchive()) {
                            Optional.ofNullable(fileSystemItem.getAllChildren()).ifPresent(fileSystemItemChildrens -> allChildren.addAll(fileSystemItemChildrens));
                        }
                        if (isJModArchive) {
                            this.extractAndAddAllFoldersName(folderRelPaths, zEntry.getName());
                        }
                        return fileSystemItem;
                    }, zEntry -> true);
                    for (String folderRelPath : folderRelPaths) {
                        FileSystemItem fileSystemItem = FileSystemItem.ofPath(zipInputStream.getAbsolutePath() + "/" + folderRelPath);
                        if (fileSystemItem.parentContainer == null) {
                            fileSystemItem.parentContainer = FileSystemItem.ofPath(zipInputStream.getAbsolutePath());
                        }
                        if (!this.isParentOf(fileSystemItem)) continue;
                        allChildren.add(fileSystemItem);
                    }
                    ConcurrentHashMap.KeySetView keySetView = allChildren;
                    return keySetView;
                }
            }
            if (this.isFolder() && (children = this.getChildren()) != null) {
                ConcurrentHashMap.KeySetView allChildren = ConcurrentHashMap.newKeySet();
                allChildren.addAll(children);
                children.forEach(child -> Optional.ofNullable(child.getAllChildren()).map(allChildrenOfChild -> allChildren.addAll(allChildrenOfChild)));
                return allChildren;
            }
        }
        return null;
    }

    Set<FileSystemItem> loadChildren() {
        String conventionedAbsolutePath = this.computeConventionedAbsolutePath();
        if (this.isContainer()) {
            if (this.isCompressed()) {
                if (this.isArchive()) {
                    Supplier<IterableZipContainer> zipInputStreamSupplier = () -> IterableZipContainer.create(this.getAbsolutePath(), this.toByteBuffer());
                    return this.retrieveChildren(zipInputStreamSupplier, "");
                }
                if (this.isFolder()) {
                    Supplier<IterableZipContainer> zipInputStreamSupplier = () -> IterableZipContainer.create(this.parentContainer.getAbsolutePath(), this.parentContainer.toByteBuffer());
                    return this.retrieveChildren(zipInputStreamSupplier, conventionedAbsolutePath.substring(conventionedAbsolutePath.lastIndexOf("///") + "///".length()));
                }
            } else if (this.isArchive()) {
                String zipFilePath = conventionedAbsolutePath.substring(0, conventionedAbsolutePath.indexOf("///"));
                File file = new File(zipFilePath);
                if (file.exists()) {
                    try (FileInputStream fIS = FileInputStream.create(file);){
                        Set<FileSystemItem> set = this.retrieveChildren(() -> IterableZipContainer.create(fIS), conventionedAbsolutePath.replaceFirst(zipFilePath + "///", ""));
                        return set;
                    }
                }
            } else {
                File file = new File(conventionedAbsolutePath);
                if (file.exists()) {
                    return Optional.ofNullable(file.listFiles()).map(childrenFiles -> Arrays.stream(childrenFiles).map(fl -> FileSystemItem.ofPath(fl.getAbsolutePath())).collect(Collectors.toCollection(ConcurrentHashMap::newKeySet))).orElseGet(ConcurrentHashMap::newKeySet);
                }
            }
        }
        return null;
    }

    public FileSystemItem refresh() {
        return this.refresh(true);
    }

    public FileSystemItem refresh(boolean removeLinkedResourcesFromCache) {
        this.reset(removeLinkedResourcesFromCache);
        this.computeConventionedAbsolutePath();
        return this;
    }

    private void removeFromCache(FileSystemItem fileSystemItem, boolean removeFromCache) {
        StaticComponentContainer.Cache.pathForContents.remove(fileSystemItem.getAbsolutePath(), true);
        IterableZipContainer zipContainer = StaticComponentContainer.Cache.pathForIterableZipContainers.get(fileSystemItem.getAbsolutePath());
        if (zipContainer != null) {
            zipContainer.destroy();
        }
        if (removeFromCache) {
            StaticComponentContainer.Cache.pathForFileSystemItems.remove(fileSystemItem.getAbsolutePath(), true);
        }
    }

    public FileSystemItem reset() {
        return this.reset(true);
    }

    public FileSystemItem reset(boolean removeLinkedResourcesFromCache) {
        return this.clear(removeLinkedResourcesFromCache, false);
    }

    public void destroy() {
        this.clear(true, true);
    }

    FileSystemItem clear(boolean removeLinkedResourcesFromCache, boolean removeFromCache) {
        return StaticComponentContainer.Synchronizer.execute(this.instanceId, () -> {
            Set<FileSystemItem> allChildren = this.allChildren;
            Set<FileSystemItem> children = this.children;
            this.allChildren = null;
            this.children = null;
            if (allChildren != null) {
                for (FileSystemItem child : allChildren) {
                    StaticComponentContainer.Synchronizer.execute(child.instanceId, () -> {
                        child.absolutePath.setValue(null);
                        child.parentContainer = null;
                        child.parent = null;
                        child.allChildren = null;
                        child.children = null;
                        if (removeLinkedResourcesFromCache) {
                            this.removeFromCache(child, removeFromCache);
                        }
                    });
                }
            } else if (children != null) {
                for (FileSystemItem child : children) {
                    child.clear(removeLinkedResourcesFromCache, removeFromCache);
                }
            }
            this.absolutePath.setValue(null);
            this.parentContainer = null;
            this.parent = null;
            if (removeLinkedResourcesFromCache) {
                this.removeFromCache(this, removeFromCache);
            }
            return removeFromCache ? null : this;
        });
    }

    private Set<FileSystemItem> retrieveChildren(Supplier<IterableZipContainer> zipInputStreamSupplier, String itemToSearch) {
        try (IterableZipContainer zipInputStream = zipInputStreamSupplier.get();){
            String itemToSearchRegEx = itemToSearch.replace("/", "\\/") + "(.*?)\\/";
            Pattern itemToSearchRegExPattern = Pattern.compile(itemToSearchRegEx);
            boolean isJModArchive = StaticComponentContainer.Streams.isJModArchive(zipInputStream.toByteBuffer());
            HashSet folderRelPaths = new HashSet();
            ConcurrentHashMap.KeySetView children = ConcurrentHashMap.newKeySet();
            zipInputStream.findAllAndConvert(() -> children, zEntry -> {
                String childRelPath;
                String nameToTest = zEntry.getName();
                nameToTest = nameToTest + (nameToTest.endsWith("/") ? "" : "/");
                if (isJModArchive && nameToTest.matches(itemToSearchRegEx) && !folderRelPaths.contains(childRelPath = itemToSearch + StaticComponentContainer.Strings.extractAllGroups(itemToSearchRegExPattern, nameToTest).get(1).get(0) + "/")) {
                    folderRelPaths.add(childRelPath);
                    FileSystemItem fileSystemItem = FileSystemItem.ofPath(zEntry.getParentContainer().getAbsolutePath() + "/" + childRelPath);
                    if (fileSystemItem.parentContainer == null) {
                        fileSystemItem.parentContainer = FileSystemItem.ofPath(zEntry.getParentContainer().getAbsolutePath());
                    }
                    if (this.isParentOf(fileSystemItem)) {
                        children.add(fileSystemItem);
                    }
                }
                return nameToTest.matches(itemToSearchRegEx) && nameToTest.replaceFirst(itemToSearchRegEx, "").length() == 0;
            }, zEntry -> {
                FileSystemItem fileSystemItem = FileSystemItem.ofPath(zEntry.getAbsolutePath());
                if (fileSystemItem.parentContainer == null) {
                    fileSystemItem.parentContainer = FileSystemItem.ofPath(zEntry.getParentContainer().getAbsolutePath());
                }
                return fileSystemItem;
            }, zEntry -> false);
            ConcurrentHashMap.KeySetView keySetView = children;
            return keySetView;
        }
    }

    private String retrieveConventionedAbsolutePath(String realAbsolutePath, String relativePath) {
        File file = new File(realAbsolutePath);
        if (file.exists()) {
            if (relativePath.isEmpty()) {
                if (file.isDirectory()) {
                    return realAbsolutePath + (realAbsolutePath.endsWith("/") ? "" : "/");
                }
                try {
                    if (StaticComponentContainer.Streams.isArchive(file)) {
                        return realAbsolutePath + "///";
                    }
                    return realAbsolutePath;
                }
                catch (IOException exc) {
                    StaticComponentContainer.ManagedLoggersRepository.logWarn(this.getClass()::getName, "Exception occurred while calling isArchive on file {}: {}", file.getAbsolutePath(), exc.getMessage());
                    return realAbsolutePath;
                }
            }
            FileInputStream fileInputStream = FileInputStream.create(file);
            try {
                String string = fileInputStream.getAbsolutePath() + "///" + this.retrieveConventionedRelativePath(fileInputStream.toByteBuffer(), fileInputStream.getAbsolutePath(), relativePath);
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
                return string;
            }
            catch (Throwable throwable) {
                try {
                    if (fileInputStream != null) {
                        try {
                            fileInputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable exc) {
                    return null;
                }
            }
        }
        if (realAbsolutePath.chars().filter(ch -> ch == 47).count() > 1L) {
            String pathToTest = realAbsolutePath.substring(0, realAbsolutePath.lastIndexOf("/"));
            relativePath = realAbsolutePath.replace(pathToTest + "/", "") + (relativePath.isEmpty() ? "" : "/") + relativePath;
            return this.retrieveConventionedAbsolutePath(pathToTest, relativePath);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized String retrieveConventionedRelativePath(ByteBuffer zipInputStreamAsBytes, String zipInputStreamName, String relativePath1) {
        try (IterableZipContainer zIS = IterableZipContainer.create(zipInputStreamName, zipInputStreamAsBytes);){
            if (zIS == null) {
                String string = (String)StaticComponentContainer.Throwables.throwException(new FileSystemItemNotFoundException("Absolute path \"" + this.absolutePath.getKey() + "\" not exists"), new Object[0]);
                return string;
            }
            Predicate<IterableZipContainer.Entry> zipEntryPredicate = zEntry -> zEntry.getName().equals(relativePath1) || zEntry.getName().equals(relativePath1 + "/");
            String temp = relativePath1;
            while (temp != null) {
                int lastIndexOfSlash = temp.lastIndexOf("/");
                String temp2 = lastIndexOfSlash != -1 ? temp.substring(0, lastIndexOfSlash) : temp;
                zipEntryPredicate = zipEntryPredicate.or(zEntry -> zEntry.getName().equals(temp2) || zEntry.getName().equals(temp2 + "/"));
                if (lastIndexOfSlash == -1) {
                    temp = null;
                    continue;
                }
                temp = temp2;
            }
            Set<IterableZipContainer.Entry> zipEntries = zIS.findAll(zipEntryPredicate, zEntry -> false);
            if (!zipEntries.isEmpty()) {
                IterableZipContainer.Entry zipEntry2 = Collections.max(zipEntries, Comparator.comparing(zipEntryW -> zipEntryW.getName().split("/").length));
                String string = this.retrieveConventionedRelativePath(this, zIS, zipEntry2, relativePath1);
                return string;
            }
            if (StaticComponentContainer.Streams.isJModArchive(zipInputStreamAsBytes)) {
                IterableZipContainer zIS2 = IterableZipContainer.create(zipInputStreamName, zipInputStreamAsBytes);
                if (zIS2.findFirst(zipEntry -> zipEntry.getName().startsWith(relativePath1 + "/"), zipEntry -> false) != null) {
                    String string = this.retrieveConventionedRelativePath(this, zIS2, null, relativePath1);
                    return string;
                }
                String string = (String)StaticComponentContainer.Throwables.throwException(new FileSystemItemNotFoundException("Absolute path \"" + this.absolutePath.getKey() + "\" not exists"), new Object[0]);
                return string;
                finally {
                    if (zIS2 != null) {
                        zIS2.close();
                    }
                }
            }
            String string = (String)StaticComponentContainer.Throwables.throwException(new FileSystemItemNotFoundException("Absolute path \"" + this.absolutePath.getKey() + "\" not exists"), new Object[0]);
            return string;
        }
    }

    synchronized String retrieveConventionedRelativePath(FileSystemItem fileSystemItem, IterableZipContainer iZC, IterableZipContainer.Entry zipEntry, String relativePath1) {
        if (zipEntry != null) {
            String zipEntryCleanedName = zipEntry.getCleanedName();
            String relativePath2 = zipEntryCleanedName;
            if (relativePath2.endsWith("/")) {
                relativePath2 = relativePath2.substring(0, relativePath2.length() - 1);
            }
            if ((relativePath2 = relativePath1.substring(relativePath2.length())).startsWith("/")) {
                relativePath2 = relativePath2.replaceFirst("\\/", "");
            }
            if (relativePath2.isEmpty()) {
                if (fileSystemItem.parentContainer == null) {
                    fileSystemItem.parentContainer = FileSystemItem.ofPath(zipEntry.getParentContainer().getAbsolutePath());
                }
                return zipEntryCleanedName + (zipEntry.isArchive() ? "///" : "");
            }
            return zipEntryCleanedName + "///" + this.retrieveConventionedRelativePath(zipEntry.toByteBuffer(), zipEntry.getAbsolutePath(), relativePath2);
        }
        if (fileSystemItem.parentContainer == null) {
            fileSystemItem.parentContainer = FileSystemItem.ofPath(iZC.getAbsolutePath());
        }
        return iZC.getAbsolutePath() + "///" + relativePath1 + "/";
    }

    public ByteBuffer toByteBuffer() {
        return Executor.get(this::toByteBuffer0, 2);
    }

    public byte[] toByteArray() {
        return StaticComponentContainer.BufferHandler.toByteArray(this.toByteBuffer());
    }

    private ByteBuffer toByteBuffer0() {
        String absolutePath = this.getAbsolutePath();
        ByteBuffer resource = StaticComponentContainer.Cache.pathForContents.get(absolutePath);
        if (resource != null) {
            return resource;
        }
        if (this.exists() && !this.isFolder()) {
            if (this.isCompressed()) {
                FileSystemItem parentContainer;
                FileSystemItem superParentContainer = parentContainer = this.getParentContainer();
                while (superParentContainer.getParentContainer() != null && superParentContainer.getParentContainer().isArchive()) {
                    superParentContainer = superParentContainer.getParentContainer();
                }
                Set<FileSystemItem> superParentAllChildren = superParentContainer.getAllChildren();
                FileSystemItem randomFIS = StaticComponentContainer.IterableObjectHelper.getRandom(superParentAllChildren);
                while (randomFIS.getAbsolutePath() == this.getAbsolutePath() && superParentAllChildren.size() > 1) {
                    randomFIS = StaticComponentContainer.IterableObjectHelper.getRandom(superParentAllChildren);
                }
                if (StaticComponentContainer.Cache.pathForContents.get(randomFIS.getAbsolutePath()) == null) {
                    FileSystemItem finalRandomFIS = randomFIS;
                    FileSystemItem superParentContainerFinal = superParentContainer;
                    StaticComponentContainer.Synchronizer.execute(superParentContainer.instanceId, () -> {
                        if (StaticComponentContainer.Cache.pathForContents.get(finalRandomFIS.getAbsolutePath()) == null) {
                            superParentContainerFinal.refresh().getAllChildren();
                        }
                    });
                }
                if (StaticComponentContainer.Cache.pathForContents.get(absolutePath) == null) {
                    this.reloadContent(false);
                }
                return StaticComponentContainer.Cache.pathForContents.get(absolutePath);
            }
            return StaticComponentContainer.Cache.pathForContents.getOrUploadIfAbsent(absolutePath, () -> {
                try (FileInputStream fIS = FileInputStream.create(this.getAbsolutePath());){
                    ByteBuffer byteBuffer = fIS.toByteBuffer();
                    return byteBuffer;
                }
            });
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <S extends Serializable> S toObject() {
        try (InputStream inputStream = this.toInputStream();){
            Object s = StaticComponentContainer.Objects.deserialize(inputStream);
            return s;
        }
        catch (Throwable exc) {
            return (S)((Serializable)StaticComponentContainer.Throwables.throwException(exc, new Object[0]));
        }
    }

    public FileSystemItem reloadContent() {
        return this.reloadContent(false);
    }

    public FileSystemItem reloadContent(boolean recomputeConventionedAbsolutePath) {
        String absolutePath = this.getAbsolutePath();
        StaticComponentContainer.Synchronizer.execute(this.instanceId, () -> {
            StaticComponentContainer.Cache.pathForContents.remove(absolutePath, true);
            if (recomputeConventionedAbsolutePath) {
                this.absolutePath.setValue(null);
            }
        });
        if (this.exists() && !this.isFolder()) {
            if (this.isCompressed()) {
                try (IterableZipContainer iterableZipContainer = IterableZipContainer.create(this.getParentContainer().reloadContent(recomputeConventionedAbsolutePath).getAbsolutePath());){
                    iterableZipContainer.findFirst(iteratedZipEntry -> iteratedZipEntry.getAbsolutePath().equals(absolutePath), iteratedZipEntry -> iteratedZipEntry.getAbsolutePath().equals(absolutePath));
                }
            } else {
                StaticComponentContainer.Cache.pathForContents.getOrUploadIfAbsent(absolutePath, () -> {
                    try (FileInputStream fIS = FileInputStream.create(this.getAbsolutePath());){
                        ByteBuffer byteBuffer = fIS.toByteBuffer();
                        return byteBuffer;
                    }
                });
            }
        }
        return this;
    }

    public InputStream toInputStream() {
        return new ByteBufferInputStream(this.toByteBuffer());
    }

    public String toString() {
        return this.absolutePath.getKey();
    }

    private String toURL() {
        String url = this.computeConventionedAbsolutePath();
        String prefix = "file:";
        if (!url.startsWith("/")) {
            prefix = prefix + "/";
        }
        if (this.isCompressed()) {
            prefix = "jar:" + prefix;
        }
        url = url.endsWith("///") ? url.substring(0, url.lastIndexOf("///")) : url;
        String uRLToRet = url.replace("///", this.isCompressed() ? "!/" : "/");
        url = Executor.get(() -> URLEncoder.encode(uRLToRet, StandardCharsets.UTF_8.name())).replace("%3A", ":").replace("%21", "!").replace("%2F", "/");
        url = prefix + url;
        return this.isFolder() ? (url.endsWith("/") ? url : url + "/") : (url.endsWith("/") ? url.substring(0, url.length() - 1) : url);
    }

    public static class Criteria
    extends Criteria.Simple<FileSystemItem[], Criteria> {
        private BiFunction<Throwable, FileSystemItem[], Boolean> exceptionHandler;

        public static Criteria create() {
            return new Criteria();
        }

        public static final Criteria forAllFileThat(BiPredicate<FileSystemItem, FileSystemItem> predicate) {
            return (Criteria)new Criteria().allThoseThatMatch(childAndSuperParent -> predicate.test(childAndSuperParent[0], childAndSuperParent[1]));
        }

        public static final Criteria forAllFileThat(Predicate<FileSystemItem> predicate) {
            return (Criteria)new Criteria().allThoseThatMatch(childAndSuperParent -> predicate.test(childAndSuperParent[0]));
        }

        public static final Criteria forArchiveTypeFiles(CheckingOption checkingOption) {
            return new CheckingOption.ForFileOf.ArchiveType().toCriteria(checkingOption);
        }

        public static final Criteria forArchiveTypeFiles(String checkingOption) {
            return new CheckingOption.ForFileOf.ArchiveType().toCriteria(checkingOption);
        }

        public static final Criteria forClassTypeFiles(CheckingOption checkingOption) {
            return new CheckingOption.ForFileOf.ClassType().toCriteria(checkingOption);
        }

        public static final Criteria forClassTypeFiles(String checkingOption) {
            return new CheckingOption.ForFileOf.ClassType().toCriteria(checkingOption);
        }

        public final Criteria allFileThat(Predicate<FileSystemItem> predicate) {
            return (Criteria)this.allThoseThatMatch(childAndSuperParent -> predicate.test(childAndSuperParent[0]));
        }

        public final Criteria allFileThat(BiPredicate<FileSystemItem, FileSystemItem> predicate) {
            return (Criteria)this.allThoseThatMatch(childAndSuperParent -> predicate.test(childAndSuperParent[0], childAndSuperParent[1]));
        }

        public Criteria excludePathsThatMatch(String regex) {
            return this.allFileThat((FileSystemItem file) -> !file.getAbsolutePath().matches(regex));
        }

        public Criteria notRecursiveOnPath(String path, boolean isAbsolute) {
            path = StaticComponentContainer.Paths.clean(path);
            if (!isAbsolute) {
                path = "/" + path;
            }
            if (!path.endsWith("/")) {
                path = path + "/";
            }
            String slashedPath = path;
            String regex = isAbsolute ? "" : ".*?" + path.replace("/", "\\/") + "[^\\/]*";
            return this.allFileThat((FileSystemItem file) -> {
                String absolutePath = file.getAbsolutePath();
                String slashedAbsolutePath = absolutePath + "/";
                boolean isContained = isAbsolute ? slashedAbsolutePath.startsWith(slashedPath) : slashedAbsolutePath.contains(slashedPath);
                return !isContained || absolutePath.matches(regex);
            });
        }

        public final Criteria setExceptionHandler(BiFunction<Throwable, FileSystemItem[], Boolean> exceptionHandler) {
            this.exceptionHandler = exceptionHandler;
            return this;
        }

        public final Criteria setDefaultExceptionHandler() {
            return this.setExceptionHandler((exception, childAndParent) -> {
                StaticComponentContainer.ManagedLoggersRepository.logError(this.getClass()::getName, "Could not scan " + childAndParent[0].getAbsolutePath(), (Throwable)exception);
                return false;
            });
        }

        public boolean hasNoExceptionHandler() {
            return this.exceptionHandler == null;
        }

        public BiFunction<Throwable, FileSystemItem[], Boolean> getExceptionHandler() {
            return this.exceptionHandler;
        }

        @Override
        public Predicate<FileSystemItem[]> getPredicateOrFalsePredicateIfPredicateIsNull() {
            return this.nativePredicateToSomeExceptionManagedPredicate(super.getPredicateOrFalsePredicateIfPredicateIsNull());
        }

        @Override
        public Predicate<FileSystemItem[]> getPredicateOrTruePredicateIfPredicateIsNull() {
            return this.nativePredicateToSomeExceptionManagedPredicate(super.getPredicateOrTruePredicateIfPredicateIsNull());
        }

        public Predicate<FileSystemItem[]> getOriginalPredicateOrFalsePredicateIfPredicateIsNull() {
            return super.getPredicateOrFalsePredicateIfPredicateIsNull();
        }

        public Predicate<FileSystemItem[]> getOriginalPredicateOrTruePredicateIfPredicateIsNull() {
            return super.getPredicateOrTruePredicateIfPredicateIsNull();
        }

        private Predicate<FileSystemItem[]> nativePredicateToSomeExceptionManagedPredicate(Predicate<FileSystemItem[]> filterPredicate) {
            Predicate<FileSystemItem[]> finalFilterPredicate = childAndThis -> {
                try {
                    try {
                        return filterPredicate.test((FileSystemItem[])childAndThis);
                    }
                    catch (ArrayIndexOutOfBoundsException | NullPointerException exc) {
                        String childAbsolutePath = childAndThis[0].getAbsolutePath();
                        StaticComponentContainer.ManagedLoggersRepository.logWarn(this.getClass()::getName, "Exception occurred while analyzing {}", childAbsolutePath);
                        if (exc instanceof ArrayIndexOutOfBoundsException) {
                            StaticComponentContainer.ManagedLoggersRepository.logInfo(this.getClass()::getName, "Trying to reload content of {} and test it again", childAbsolutePath);
                            childAndThis[0].reloadContent();
                        } else if (exc instanceof NullPointerException) {
                            StaticComponentContainer.ManagedLoggersRepository.logInfo(this.getClass()::getName, "Trying to reload content and conventioned absolute path of {} and test it again", childAbsolutePath);
                            childAndThis[0].reloadContent(true);
                        }
                        return filterPredicate.test((FileSystemItem[])childAndThis);
                    }
                }
                catch (Throwable exc) {
                    if (this.exceptionHandler != null) {
                        return this.exceptionHandler.apply(exc, (FileSystemItem[])childAndThis);
                    }
                    throw exc;
                }
            };
            return finalFilterPredicate;
        }

        @Override
        public Criteria createCopy() {
            Criteria copy = (Criteria)super.createCopy();
            copy.exceptionHandler = this.exceptionHandler;
            return copy;
        }
    }

    public static class NotFoundException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public NotFoundException(String message) {
            super(message);
        }
    }

    public static enum CheckingOption {
        FOR_NAME("checkFileName"),
        FOR_SIGNATURE("checkFileSignature"),
        FOR_NAME_AND_SIGNATURE(CheckingOption.FOR_NAME.label + "&" + CheckingOption.FOR_SIGNATURE.label),
        FOR_NAME_OR_SIGNATURE(CheckingOption.FOR_NAME.label + "|" + CheckingOption.FOR_SIGNATURE.label),
        FOR_SIGNATURE_OR_NAME(CheckingOption.FOR_SIGNATURE.label + "|" + CheckingOption.FOR_NAME.label),
        FOR_SIGNATURE_AND_NAME(CheckingOption.FOR_SIGNATURE.label + "&" + CheckingOption.FOR_NAME.label);

        private String label;

        public static CheckingOption forLabel(String label) {
            for (CheckingOption item : CheckingOption.values()) {
                if (!item.label.equals(label)) continue;
                return item;
            }
            return null;
        }

        private CheckingOption(String label) {
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }

        public static abstract class ForFileOf {
            Predicate<FileSystemItem> fileNameChecker;
            Predicate<FileSystemItem> fileSignatureChecker;

            ForFileOf(Predicate<FileSystemItem> fileNameChecker, Predicate<FileSystemItem> fileSignatureChecker) {
                this.fileNameChecker = fileNameChecker;
                this.fileSignatureChecker = fileSignatureChecker;
            }

            Criteria toCriteria(CheckingOption checkFileOption) {
                if (checkFileOption.equals((Object)FOR_NAME)) {
                    return Criteria.forAllFileThat(this.fileNameChecker);
                }
                if (checkFileOption.equals((Object)FOR_SIGNATURE)) {
                    return Criteria.forAllFileThat(this.fileSignatureChecker);
                }
                if (checkFileOption.equals((Object)FOR_NAME_OR_SIGNATURE)) {
                    return Criteria.forAllFileThat(this.fileNameChecker.or(this.fileSignatureChecker));
                }
                if (checkFileOption.equals((Object)FOR_SIGNATURE_OR_NAME)) {
                    return Criteria.forAllFileThat(this.fileSignatureChecker.or(this.fileNameChecker));
                }
                if (checkFileOption.equals((Object)FOR_NAME_AND_SIGNATURE)) {
                    return Criteria.forAllFileThat(this.fileNameChecker.and(this.fileSignatureChecker));
                }
                if (checkFileOption.equals((Object)FOR_SIGNATURE_AND_NAME)) {
                    return Criteria.forAllFileThat(this.fileSignatureChecker.and(this.fileNameChecker));
                }
                return null;
            }

            Criteria toCriteria(String checkFileOptionLabel) {
                return this.toCriteria(CheckingOption.forLabel(checkFileOptionLabel));
            }

            static class ClassType
            extends ForFileOf {
                ClassType() {
                    super(file -> {
                        String name = file.getName();
                        return name.endsWith(".class") && !name.endsWith("module-info.class") && !name.endsWith("package-info.class");
                    }, file -> Executor.get(() -> !file.isFolder() && StaticComponentContainer.Streams.isClass(file.toByteBuffer())));
                }
            }

            static class ArchiveType
            extends ForFileOf {
                ArchiveType() {
                    super(file -> {
                        String name = file.getName();
                        return name.endsWith(".zip") || name.endsWith(".jar") || name.endsWith(".war") || name.endsWith(".ear") || name.endsWith(".jmod");
                    }, file -> Executor.get(() -> !file.isFolder() && StaticComponentContainer.Streams.isArchive(file.toByteBuffer())));
                }
            }
        }
    }
}

