/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.core.io;

import java.io.File;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.burningwave.core.Closeable;
import org.burningwave.core.Component;
import org.burningwave.core.ManagedLogger;
import org.burningwave.core.assembler.StaticComponentContainer;
import org.burningwave.core.io.ByteBufferInputStream;
import org.burningwave.core.io.FileInputStream;
import org.burningwave.core.io.FileSystemItem;
import org.burningwave.core.io.ZipFile;
import org.burningwave.core.io.ZipInputStream;

public interface IterableZipContainer
extends Closeable,
ManagedLogger {
    public static final String PATH_SUFFIX = "///";

    public static IterableZipContainer create(FileInputStream file) {
        return IterableZipContainer.create(file.getAbsolutePath(), file);
    }

    public static IterableZipContainer create(File file) {
        return IterableZipContainer.create(file.getAbsolutePath(), FileInputStream.create(file));
    }

    public static IterableZipContainer create(Entry zipEntry) {
        return IterableZipContainer.create(zipEntry.getAbsolutePath(), zipEntry.toByteBuffer());
    }

    public static IterableZipContainer create(String absolutePath) {
        return IterableZipContainer.create(absolutePath, FileSystemItem.ofPath(absolutePath).toByteBuffer());
    }

    public static IterableZipContainer create(String absolutePath, ByteBuffer bytes) {
        if (StaticComponentContainer.Streams.isJModArchive(bytes)) {
            return IterableZipContainer.createZipFile(absolutePath, bytes);
        }
        if (StaticComponentContainer.Streams.isArchive(bytes)) {
            return new ZipInputStream(absolutePath, new ByteBufferInputStream(bytes));
        }
        return null;
    }

    public static IterableZipContainer createZipFile(String absolutePath, ByteBuffer bytes) {
        ZipFile zipFile = (ZipFile)StaticComponentContainer.Cache.pathForIterableZipContainers.getOrUploadIfAbsent(absolutePath, () -> new ZipFile(absolutePath, bytes));
        try {
            return zipFile.duplicate();
        }
        catch (Throwable exc) {
            StaticComponentContainer.Synchronizer.execute(ZipFile.class.getName() + "_" + absolutePath, () -> {
                ZipFile oldZipFile = (ZipFile)StaticComponentContainer.Cache.pathForIterableZipContainers.get(absolutePath);
                if (oldZipFile == null || oldZipFile == zipFile || oldZipFile.isDestroyed.booleanValue()) {
                    StaticComponentContainer.Cache.pathForIterableZipContainers.upload(absolutePath, () -> new ZipFile(absolutePath, bytes), true);
                }
            });
            return StaticComponentContainer.Cache.pathForIterableZipContainers.get(absolutePath).duplicate();
        }
    }

    public static IterableZipContainer create(String absolutePath, InputStream inputStream) {
        ByteBufferInputStream iS;
        if (inputStream instanceof ByteBufferInputStream) {
            iS = new ByteBufferInputStream(((ByteBufferInputStream)inputStream).toByteBuffer());
        } else if (inputStream instanceof FileInputStream) {
            FileInputStream fileInputStream = (FileInputStream)inputStream;
            iS = new ByteBufferInputStream(fileInputStream.toByteBuffer());
        } else {
            iS = new ByteBufferInputStream(StaticComponentContainer.Streams.toByteBuffer(inputStream));
        }
        if (StaticComponentContainer.Streams.isJModArchive(iS.toByteBuffer())) {
            return IterableZipContainer.createZipFile(absolutePath, iS.toByteBuffer());
        }
        if (StaticComponentContainer.Streams.isArchive(iS.toByteBuffer())) {
            return new ZipInputStream(absolutePath, new ByteBufferInputStream(iS.toByteBuffer()));
        }
        return null;
    }

    default public <T> Set<T> findAllAndConvert(Predicate<Entry> zipEntryPredicate, Function<Entry, T> tSupplier, Predicate<Entry> loadZipEntryData) {
        return this.findAllAndConvert(HashSet::new, zipEntryPredicate, tSupplier, loadZipEntryData);
    }

    default public <T> Set<T> findAllAndConvert(Supplier<Set<T>> supplier, Predicate<Entry> zipEntryPredicate, Function<Entry, T> tSupplier, Predicate<Entry> loadZipEntryData) {
        Set<T> collection = supplier.get();
        Entry zipEntry = this.getCurrentZipEntry();
        if (zipEntry != null && zipEntryPredicate.test(zipEntry)) {
            if (loadZipEntryData.test(zipEntry)) {
                zipEntry.toByteBuffer();
            }
            collection.add(tSupplier.apply(zipEntry));
            this.closeEntry();
        }
        while ((zipEntry = this.getNextEntry(zEntry -> false)) != null) {
            if (zipEntryPredicate.test(zipEntry)) {
                if (loadZipEntryData.test(zipEntry)) {
                    zipEntry.toByteBuffer();
                }
                collection.add(tSupplier.apply(zipEntry));
            }
            this.closeEntry();
        }
        return collection;
    }

    public String getConventionedAbsolutePath();

    public String getAbsolutePath();

    public IterableZipContainer getParent();

    public ByteBuffer toByteBuffer();

    public <Z extends Entry> Z getNextEntry();

    public Entry getNextEntry(Predicate<Entry> var1);

    default public IterableZipContainer duplicate() {
        return IterableZipContainer.create(this.getAbsolutePath(), this.toByteBuffer());
    }

    public Entry getCurrentZipEntry();

    public Function<Entry, Entry> getEntrySupplier();

    public void closeEntry();

    default public <T> T findFirstAndConvert(Predicate<Entry> zipEntryPredicate, Function<Entry, T> tSupplier, Predicate<Entry> loadZipEntryData) {
        Entry zipEntry = this.getCurrentZipEntry();
        if (zipEntry != null && zipEntryPredicate.test(zipEntry)) {
            if (loadZipEntryData.test(zipEntry)) {
                zipEntry.toByteBuffer();
            }
            this.closeEntry();
            return tSupplier.apply(zipEntry);
        }
        while ((zipEntry = this.getNextEntry(zEntry -> false)) != null) {
            if (!zipEntryPredicate.test(zipEntry)) continue;
            if (loadZipEntryData.test(zipEntry)) {
                zipEntry.toByteBuffer();
            }
            T toRet = tSupplier.apply(zipEntry);
            this.closeEntry();
            return toRet;
        }
        return null;
    }

    default public <T> T findOneAndConvert(Predicate<Entry> zipEntryPredicate, Function<Entry, T> tSupplier, Predicate<Entry> loadZipEntryData) {
        Set<T> entriesFound = this.findAllAndConvert(zipEntryPredicate, tSupplier, loadZipEntryData);
        if (entriesFound.size() > 1) {
            StaticComponentContainer.Throwables.throwException("Found more than one zip entry for predicate {}", zipEntryPredicate);
        }
        return (T)entriesFound.stream().findFirst().orElseGet(() -> null);
    }

    default public Entry findOne(Predicate<Entry> zipEntryPredicate, Predicate<Entry> loadZipEntryData) {
        return this.findOneAndConvert(zipEntryPredicate, this.getEntrySupplier(), loadZipEntryData);
    }

    default public Entry findFirst(Predicate<Entry> zipEntryPredicate, Predicate<Entry> loadZipEntryData) {
        return this.findFirstAndConvert(zipEntryPredicate, this.getEntrySupplier(), loadZipEntryData);
    }

    default public Set<Entry> findAll(Predicate<Entry> zipEntryPredicate, Predicate<Entry> loadZipEntryData) {
        return this.findAll(HashSet::new, zipEntryPredicate, loadZipEntryData);
    }

    default public Set<Entry> findAll(Supplier<Set<Entry>> setSupplier, Predicate<Entry> zipEntryPredicate, Predicate<Entry> loadZipEntryData) {
        return this.findAllAndConvert(setSupplier, zipEntryPredicate, this.getEntrySupplier(), loadZipEntryData);
    }

    default public void destroy(boolean removeFromCache) {
        if (removeFromCache) {
            StaticComponentContainer.Cache.pathForIterableZipContainers.remove(this.getAbsolutePath(), true);
        }
    }

    default public void destroy() {
        this.destroy(true);
    }

    public static interface Entry
    extends Component {
        public <C extends IterableZipContainer> C getParentContainer();

        default public String getConventionedAbsolutePath() {
            return this.getParentContainer().getConventionedAbsolutePath() + this.getCleanedName();
        }

        public String getCleanedName();

        public String getName();

        public String getAbsolutePath();

        public boolean isDirectory();

        public ByteBuffer toByteBuffer();

        default public byte[] toByteArray() {
            return StaticComponentContainer.BufferHandler.toByteArray(this.toByteBuffer());
        }

        public boolean isArchive();

        default public InputStream toInputStream() {
            return new ByteBufferInputStream(this.toByteBuffer());
        }
    }
}

