/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.core.io;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.burningwave.core.Component;
import org.burningwave.core.assembler.StaticComponentContainer;
import org.burningwave.core.concurrent.QueuedTasksExecutor;
import org.burningwave.core.function.Executor;
import org.burningwave.core.io.FileSystemItem;
import org.burningwave.core.io.PathHelper;
import org.burningwave.core.iterable.Properties;

class PathHelperImpl
implements Component,
PathHelper {
    private static Pattern PATH_REGEX = Pattern.compile("\\/\\/(.*)\\/\\/(children|allChildren):(.*)");
    private Map<String, Collection<String>> pathGroups;
    private Collection<String> allPaths;
    private Properties config;
    private QueuedTasksExecutor.Task initializerTask;
    private String pathsSeparator;

    PathHelperImpl(Properties config) {
        this.config = config;
        this.pathsSeparator = PathHelper.Configuration.getPathsSeparator();
        this.listenTo(config);
        this.launchAllPathsLoadingTask();
    }

    private void launchAllPathsLoadingTask() {
        this.initializerTask = StaticComponentContainer.BackgroundExecutor.createTask(() -> {
            try {
                this.pathGroups = new ConcurrentHashMap<String, Collection<String>>();
                this.allPaths = ConcurrentHashMap.newKeySet();
                this.loadMainClassPaths();
                this.loadAllPaths();
            }
            finally {
                this.initializerTask = null;
            }
        }, 10);
        this.initializerTask.submit();
    }

    @Override
    public <K, V> void processChangeNotification(Properties properties, Properties.Event event, K key, V newValue, V oldValue) {
        String propertyKey;
        if (key instanceof String && (propertyKey = (String)key).startsWith(PathHelper.Configuration.Key.PATHS_PREFIX)) {
            if (event.name().equals(Properties.Event.PUT.name())) {
                this.loadAndMapPaths(propertyKey, null);
            } else if (event.name().equals(Properties.Event.REMOVE.name())) {
                this.launchAllPathsLoadingTask();
            }
        }
    }

    private void loadMainClassPaths() {
        Collection<String> placeHolders = this.config.getAllPlaceHolders(PathHelper.Configuration.Key.MAIN_CLASS_PATHS);
        if (placeHolders.contains("${system.properties:java.class.path}")) {
            this.loadAndMapPaths(PathHelper.Configuration.Key.MAIN_CLASS_PATHS, null);
            this.addPaths(PathHelper.Configuration.Key.MAIN_CLASS_PATHS, StaticComponentContainer.ClassLoaders.getAllLoadedPaths(StaticComponentContainer.Classes.getClassLoader(this.getClass())));
        }
    }

    private void loadAllPaths() {
        for (Object pathGroupNameObject : this.config.keySet()) {
            String pathGroupName = (String)pathGroupNameObject;
            if (!pathGroupName.startsWith(PathHelper.Configuration.Key.PATHS_PREFIX)) continue;
            this.loadAndMapPaths(pathGroupName, null);
        }
    }

    @Override
    public String getBurningwaveRuntimeClassPath() {
        return StaticComponentContainer.Resources.getClassPath(this.getClass()).getAbsolutePath();
    }

    @Override
    public Collection<String> getMainClassPaths() {
        return this.getPaths(PathHelper.Configuration.Key.MAIN_CLASS_PATHS);
    }

    @Override
    public Collection<String> getAllMainClassPaths() {
        return this.getPaths(PathHelper.Configuration.Key.MAIN_CLASS_PATHS, PathHelper.Configuration.Key.MAIN_CLASS_PATHS_EXTENSION);
    }

    private void waitForInitialization() {
        QueuedTasksExecutor.Task initializerTask = this.initializerTask;
        if (initializerTask != null) {
            initializerTask.waitForFinish();
        }
    }

    @Override
    public Collection<String> getAllPaths() {
        this.waitForInitialization();
        ConcurrentHashMap.KeySetView allPaths = ConcurrentHashMap.newKeySet();
        allPaths.addAll(this.allPaths);
        return allPaths;
    }

    @Override
    public Collection<String> getPaths(String ... names) {
        this.waitForInitialization();
        HashSet<String> pathGroup = new HashSet<String>();
        if (names != null && names.length > 0) {
            for (String name : names) {
                Collection<String> pathsFound;
                if (name.startsWith(PathHelper.Configuration.Key.PATHS_PREFIX)) {
                    name = name.replaceFirst(PathHelper.Configuration.Key.PATHS_PREFIX.replace(".", "\\."), "");
                }
                if ((pathsFound = this.pathGroups.get(name)) != null) {
                    pathGroup.addAll(pathsFound);
                    continue;
                }
                this.loadAndMapPaths(name, null);
                pathsFound = this.pathGroups.get(name);
                if (pathsFound == null) continue;
                pathGroup.addAll(pathsFound);
            }
        }
        return pathGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<String> getOrCreatePathGroup(String groupName) {
        groupName = groupName.startsWith(PathHelper.Configuration.Key.PATHS_PREFIX) ? groupName.substring(PathHelper.Configuration.Key.PATHS_PREFIX.length()) : groupName;
        Collection<String> classPathsGroup = null;
        classPathsGroup = this.pathGroups.get(groupName);
        if (classPathsGroup == null) {
            Map<String, Collection<String>> map = this.pathGroups;
            synchronized (map) {
                classPathsGroup = this.pathGroups.get(groupName);
                if (classPathsGroup == null) {
                    classPathsGroup = ConcurrentHashMap.newKeySet();
                    this.pathGroups.put(groupName, classPathsGroup);
                }
            }
        }
        return classPathsGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<String> loadAndMapPaths(String pathGroupName, String paths) {
        this.waitForInitialization();
        String pathGroupPropertyName = pathGroupName.startsWith(PathHelper.Configuration.Key.PATHS_PREFIX) ? pathGroupName : PathHelper.Configuration.Key.PATHS_PREFIX + pathGroupName;
        ConcurrentHashMap.KeySetView groupPaths = ConcurrentHashMap.newKeySet();
        PathHelperImpl pathHelperImpl = this;
        synchronized (pathHelperImpl) {
            String currentPropertyPaths = this.config.getProperty(pathGroupPropertyName);
            if (StaticComponentContainer.Strings.isNotEmpty(currentPropertyPaths) && StaticComponentContainer.Strings.isNotEmpty(paths)) {
                if (!currentPropertyPaths.endsWith(this.pathsSeparator)) {
                    currentPropertyPaths = currentPropertyPaths + this.pathsSeparator;
                }
                currentPropertyPaths = currentPropertyPaths + paths;
                this.config.put(pathGroupPropertyName, currentPropertyPaths);
            } else if (StaticComponentContainer.Strings.isNotEmpty(paths)) {
                currentPropertyPaths = paths;
                this.config.put(pathGroupPropertyName, currentPropertyPaths);
            }
            Collection<String> placeHolders = this.config.getAllPlaceHolders(pathGroupPropertyName);
            LinkedHashMap<String, String> defaultValues = new LinkedHashMap<String, String>();
            if (!placeHolders.isEmpty()) {
                for (String placeHolder : placeHolders) {
                    String placeHolderName = placeHolder.replaceAll("[\\$\\{\\}]", "");
                    Collection<String> placeHolderPaths = placeHolderName.contains("system.properties") ? Arrays.asList(System.getProperty(placeHolderName.split(":")[1]).split(System.getProperty("path.separator"))) : this.getPaths(placeHolderName);
                    for (String placeHolderPath : placeHolderPaths) {
                        defaultValues.put(placeHolderName, Optional.ofNullable((String)defaultValues.get(placeHolderName)).map(pHP -> pHP + (pHP.endsWith(this.pathsSeparator) ? "" : this.pathsSeparator) + placeHolderPath + (placeHolderPath.endsWith(this.pathsSeparator) ? "" : this.pathsSeparator)).orElseGet(() -> placeHolderPath));
                    }
                }
            }
            Properties configWithResolvedPaths = new Properties();
            configWithResolvedPaths.putAll((Map<?, ?>)this.config);
            configWithResolvedPaths.putAll((Map<?, ?>)defaultValues);
            Collection<String> computedPaths = configWithResolvedPaths.resolveStringValues(pathGroupPropertyName, this.pathsSeparator, true);
            if (computedPaths != null) {
                groupPaths.addAll(this.addPaths(pathGroupName, computedPaths));
            }
        }
        return groupPaths;
    }

    private Collection<String> addPaths(String groupName, Collection<String> paths) {
        if (paths != null) {
            Collection<String> pathGroup = this.getOrCreatePathGroup(groupName);
            for (String path : paths) {
                if (path.matches(PATH_REGEX.pattern())) {
                    Map<Integer, List<String>> groupMap = StaticComponentContainer.Strings.extractAllGroups(PATH_REGEX, path);
                    String fileSystemItemParentPath = groupMap.get(1).get(0);
                    FileSystemItem fileSystemItemParent = null;
                    try {
                        fileSystemItemParent = FileSystemItem.ofPath(fileSystemItemParentPath);
                    }
                    catch (Throwable exc) {
                        StaticComponentContainer.ManagedLoggersRepository.logWarn(this.getClass()::getName, "could not add path '" + path + "': parent path '" + fileSystemItemParentPath + "' could not be loaded");
                        continue;
                    }
                    if (!fileSystemItemParent.exists()) continue;
                    String childrenSet = groupMap.get(2).get(0);
                    String childrenSetRegEx = groupMap.get(3).get(0);
                    Function<FileSystemItem.Criteria, Collection> childrenSupplier = childrenSet.equalsIgnoreCase("children") ? fileSystemItemParent::findInChildren : (childrenSet.equalsIgnoreCase("allChildren") ? fileSystemItemParent::findInAllChildren : null);
                    if (childrenSupplier == null) continue;
                    Collection childrenFound = childrenSupplier.apply(FileSystemItem.Criteria.forAllFileThat(fileSystemItem -> fileSystemItem.getAbsolutePath().matches(childrenSetRegEx)));
                    for (FileSystemItem fileSystemItem2 : childrenFound) {
                        pathGroup.add(fileSystemItem2.getAbsolutePath());
                        this.allPaths.add(fileSystemItem2.getAbsolutePath());
                    }
                    continue;
                }
                FileSystemItem fileSystemItem3 = FileSystemItem.ofPath(path);
                if (!fileSystemItem3.exists()) continue;
                pathGroup.add(fileSystemItem3.getAbsolutePath());
                this.allPaths.add(fileSystemItem3.getAbsolutePath());
            }
            return pathGroup;
        }
        return (Collection)StaticComponentContainer.Throwables.throwException("classPaths parameter is null", new Object[0]);
    }

    @Override
    public Collection<FileSystemItem> findResources(Predicate<String> absolutePathPredicate) {
        HashSet<FileSystemItem> resources = new HashSet<FileSystemItem>();
        FileSystemItem.Criteria criteria = FileSystemItem.Criteria.forAllFileThat(fSI -> absolutePathPredicate.test(fSI.getAbsolutePath()));
        for (String path : this.getAllPaths()) {
            resources.addAll(FileSystemItem.ofPath(path).findInAllChildren(criteria));
        }
        return resources;
    }

    @Override
    public Collection<String> getAbsolutePathsOfResources(Predicate<String> absolutePathPredicate) {
        return this.findResources(absolutePathPredicate).stream().map(fSI -> fSI.getAbsolutePath()).collect(Collectors.toSet());
    }

    @Override
    public String getAbsolutePathOfResource(String resourceRelativePath) {
        return Optional.ofNullable(this.getResource(resourceRelativePath)).map(resource -> resource.getAbsolutePath()).orElseGet(() -> {
            StaticComponentContainer.ManagedLoggersRepository.logInfo(this.getClass()::getName, "Could not find file {}", resourceRelativePath);
            return null;
        });
    }

    @Override
    public Collection<String> getAbsolutePathsOfResource(String ... resourceRelativePath) {
        return this.getResources(resourceRelativePath).stream().map(fSI -> fSI.getAbsolutePath()).collect(Collectors.toSet());
    }

    @Override
    public Collection<FileSystemItem> getResources(String ... resourcesRelativePaths) {
        return this.getResources((Collection<T> coll, FileSystemItem file) -> coll.add(file), resourcesRelativePaths);
    }

    @Override
    public FileSystemItem getResource(String resourceRelativePath) {
        return (FileSystemItem)this.getResource((coll, file) -> coll.add(file), resourceRelativePath);
    }

    @Override
    public <T> Collection<T> getResources(BiConsumer<Collection<T>, FileSystemItem> fileConsumer, String ... resourcesRelativePaths) {
        HashSet files = new HashSet();
        if (resourcesRelativePaths != null && resourcesRelativePaths.length > 0) {
            for (String resourceRelativePath : resourcesRelativePaths) {
                this.getAllPaths().stream().forEach(path -> {
                    FileSystemItem fileSystemItem = FileSystemItem.ofPath(path + "/" + resourceRelativePath);
                    if (fileSystemItem.exists()) {
                        fileConsumer.accept(files, fileSystemItem);
                    }
                });
            }
        }
        return files;
    }

    @Override
    public <T> T getResource(BiConsumer<Collection<T>, FileSystemItem> fileConsumer, String resourceRelativePath) {
        Collection<T> files = this.getResources(fileConsumer, resourceRelativePath);
        if (files.size() > 1) {
            HashMap<String, FileSystemItem> filesFound = new HashMap<String, FileSystemItem>();
            StringBuffer filesInfo = new StringBuffer();
            for (T file : files) {
                if (file instanceof FileSystemItem) {
                    FileSystemItem fileSystemItem = (FileSystemItem)file;
                    filesFound.put(fileSystemItem.getAbsolutePath(), fileSystemItem);
                    filesInfo.append("\t" + System.identityHashCode(file) + ": " + fileSystemItem.getAbsolutePath() + "\n");
                    continue;
                }
                StaticComponentContainer.Throwables.throwException("Found more than one resource under relative path {}", resourceRelativePath);
            }
            if (filesFound.size() > 1) {
                StaticComponentContainer.Throwables.throwException("Found more than one resource under relative path " + resourceRelativePath + ":\n" + filesInfo.toString(), new Object[0]);
            } else {
                FileSystemItem fileSystemItem = FileSystemItem.ofPath((String)filesFound.keySet().stream().findFirst().get());
                StaticComponentContainer.ManagedLoggersRepository.logWarn(this.getClass()::getName, "Found more than one resource under relative path " + resourceRelativePath + ":\n" + filesInfo.toString() + "\t" + System.identityHashCode(fileSystemItem) + ": " + fileSystemItem.getAbsolutePath() + "\twill be assumed\n");
                return (T)fileSystemItem;
            }
        }
        return files.stream().findFirst().orElse(null);
    }

    @Override
    public Collection<InputStream> getResourcesAsStreams(String ... resourcesRelativePaths) {
        return this.getResources((Collection<T> coll, FileSystemItem fileSystemItem) -> coll.add(fileSystemItem.toInputStream()), resourcesRelativePaths);
    }

    @Override
    public InputStream getResourceAsStream(String resourceRelativePath) {
        return (InputStream)this.getResource((coll, fileSystemItem) -> coll.add(fileSystemItem.toInputStream()), resourceRelativePath);
    }

    @Override
    public StringBuffer getResourceAsStringBuffer(String resourceRelativePath) {
        return Executor.get(() -> {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.getResourceAsStream(resourceRelativePath)));){
                String sCurrentLine;
                StringBuffer result = new StringBuffer();
                while ((sCurrentLine = reader.readLine()) != null) {
                    result.append(sCurrentLine + "\n");
                }
                StringBuffer stringBuffer = result;
                return stringBuffer;
            }
        });
    }

    @Override
    public Collection<String> optimize(String ... paths) {
        return this.optimize(Arrays.asList(paths));
    }

    @Override
    public Collection<String> optimize(Collection<String> paths) {
        HashSet<String> copyOfPaths = new HashSet<String>();
        for (String path : paths) {
            copyOfPaths.add(StaticComponentContainer.Paths.normalizeAndClean(path));
        }
        paths = new HashSet<String>(copyOfPaths);
        HashSet<String> toBeRemoved = new HashSet<String>();
        for (String path1 : copyOfPaths) {
            FileSystemItem path1AsFile = FileSystemItem.ofPath(path1);
            for (String path2 : copyOfPaths) {
                FileSystemItem path2AsFile = FileSystemItem.ofPath(path2);
                if (!path1AsFile.isChildOf(path2AsFile)) continue;
                toBeRemoved.add(path1);
            }
        }
        if (!toBeRemoved.isEmpty()) {
            copyOfPaths.removeAll(toBeRemoved);
            paths.clear();
            paths.addAll(copyOfPaths);
        }
        return paths;
    }

    @Override
    public Collection<String> getPaths(Predicate<String> pathPredicate) {
        return this.getAllPaths().stream().filter(pathPredicate).collect(Collectors.toSet());
    }

    @Override
    public String getPath(Predicate<String> pathPredicate) {
        Collection<String> classPathsFound = this.getPaths(pathPredicate);
        if (classPathsFound.size() > 1) {
            StaticComponentContainer.Throwables.throwException("Found more than one class path for predicate {}", pathPredicate);
        }
        return classPathsFound.stream().findFirst().orElseGet(() -> null);
    }

    @Override
    public void close() {
        this.closeResources(() -> this.pathGroups == null, () -> {
            QueuedTasksExecutor.Task initializerTask = this.initializerTask;
            if (initializerTask != null) {
                initializerTask.abortOrWaitForFinish();
            }
            this.unregister(this.config);
            this.pathGroups.forEach((key, value) -> {
                value.clear();
                this.pathGroups.remove(key);
            });
            this.pathGroups.clear();
            this.pathGroups = null;
            this.allPaths.clear();
            this.allPaths = null;
            this.pathsSeparator = null;
            this.config = null;
        });
    }
}

