/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.core.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Optional;
import org.burningwave.core.assembler.StaticComponentContainer;
import org.burningwave.core.function.Executor;
import org.burningwave.core.io.FileSystemItem;
import org.burningwave.core.iterable.Properties;

public class Resources {
    public Map.Entry<Properties, URL> loadFirstOneFound(String ... fileNames) {
        return this.loadFirstOneFound(new Properties(), fileNames);
    }

    public Map.Entry<Properties, URL> loadFirstOneFound(Properties properties, String ... fileNames) {
        AbstractMap.SimpleEntry<Properties, Object> propertiesBag = new AbstractMap.SimpleEntry<Properties, Object>(properties, null);
        for (String fileName : fileNames) {
            ClassLoader classLoader = StaticComponentContainer.class.getClassLoader();
            InputStream propertiesFileIS = this.getAsInputStream(classLoader, fileName);
            if (propertiesFileIS == null) continue;
            try {
                properties.load(propertiesFileIS);
                URL configFileURL = this.getURL(classLoader, fileName);
                propertiesBag.setValue(configFileURL);
                break;
            }
            catch (Throwable exc) {
                StaticComponentContainer.Throwables.throwException(exc, new Object[0]);
            }
        }
        return propertiesBag;
    }

    public FileSystemItem get(Class<?> cls) {
        return FileSystemItem.of(StaticComponentContainer.Classes.getClassLoader(cls).getResource(StaticComponentContainer.Classes.toPath(cls)));
    }

    public FileSystemItem getClassPath(Class<?> cls) {
        String classRelativePath = StaticComponentContainer.Classes.toPath(cls);
        String classAbsolutePath = FileSystemItem.of(StaticComponentContainer.Classes.getClassLoader(cls).getResource(classRelativePath)).getAbsolutePath();
        return FileSystemItem.ofPath(classAbsolutePath.substring(0, classAbsolutePath.lastIndexOf(classRelativePath) - 1));
    }

    public InputStream getAsInputStream(ClassLoader resourceClassLoader, String resourceRelativePath) {
        if (resourceClassLoader == null) {
            resourceClassLoader = ClassLoader.getSystemClassLoader();
        }
        return resourceClassLoader.getResourceAsStream(resourceRelativePath);
    }

    public StringBuffer getAsStringBuffer(ClassLoader resourceClassLoader, String resourceRelativePath) {
        return Executor.get(() -> {
            ClassLoader classLoader = Optional.ofNullable(resourceClassLoader).orElseGet(() -> ClassLoader.getSystemClassLoader());
            return this.getAsStringBuffer(classLoader.getResourceAsStream(resourceRelativePath));
        });
    }

    private StringBuffer getAsStringBuffer(InputStream inputStream) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
            String sCurrentLine;
            StringBuffer result = new StringBuffer();
            while ((sCurrentLine = reader.readLine()) != null) {
                result.append(sCurrentLine + "\n");
            }
            StringBuffer stringBuffer = result;
            return stringBuffer;
        }
    }

    public URL getURL(ClassLoader resourceClassLoader, String fileName) {
        return Optional.ofNullable(resourceClassLoader).orElseGet(() -> ClassLoader.getSystemClassLoader()).getResource(fileName);
    }
}

