/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.core.io;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.function.Predicate;
import org.burningwave.core.Identifiable;
import org.burningwave.core.ManagedLogger;
import org.burningwave.core.assembler.StaticComponentContainer;
import org.burningwave.core.function.Executor;
import org.burningwave.core.io.ByteBufferInputStream;
import org.burningwave.core.io.FileOutputStream;
import org.burningwave.core.io.FileSystemItem;
import org.burningwave.core.io.Streams;
import org.burningwave.core.iterable.Properties;

class StreamsImpl
implements Streams,
Identifiable,
Properties.Listener,
ManagedLogger {
    String instanceId = this.getId();

    StreamsImpl() {
    }

    @Override
    public boolean isArchive(File file) throws IOException {
        return this.is(file, this::isArchive);
    }

    @Override
    public boolean isJModArchive(File file) throws IOException {
        return this.is(file, this::isJModArchive);
    }

    @Override
    public boolean isClass(File file) throws IOException {
        return this.is(file, this::isClass);
    }

    @Override
    public boolean isArchive(ByteBuffer bytes) {
        return this.is(bytes, this::isArchive);
    }

    @Override
    public boolean isJModArchive(ByteBuffer bytes) {
        return this.is(bytes, this::isJModArchive);
    }

    @Override
    public boolean isClass(ByteBuffer bytes) {
        return this.is(bytes, this::isClass);
    }

    @Override
    public boolean is(File file, Predicate<Integer> predicate) throws IOException {
        try (RandomAccessFile raf = new RandomAccessFile(file, "r");){
            boolean bl = raf.length() > 4L && predicate.test(raf.readInt());
            return bl;
        }
    }

    private boolean is(ByteBuffer bytes, Predicate<Integer> predicate) {
        return bytes.capacity() > 4 && bytes.limit() > 4 && predicate.test(StaticComponentContainer.BufferHandler.duplicate(bytes).getInt());
    }

    private boolean isArchive(int fileSignature) {
        return fileSignature == 1347093252 || fileSignature == 1347093766 || fileSignature == 1347094280 || this.isJModArchive(fileSignature);
    }

    private boolean isJModArchive(int fileSignature) {
        return fileSignature == 1246560512 || fileSignature == 1246560256;
    }

    private boolean isClass(int fileSignature) {
        return fileSignature == -889275714;
    }

    @Override
    public byte[] toByteArray(InputStream inputStream) {
        byte[] byArray;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            this.copy(inputStream, outputStream);
            byArray = outputStream.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    outputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Throwable exc) {
                return (byte[])StaticComponentContainer.Throwables.throwException(exc, new Object[0]);
            }
        }
        outputStream.close();
        return byArray;
    }

    @Override
    public ByteBuffer toByteBuffer(InputStream inputStream, int streamSize) {
        try {
            int bytesRead;
            byte[] heapBuffer = StaticComponentContainer.BufferHandler.newByteArrayWithDefaultSize();
            ByteBuffer byteBuffer = StaticComponentContainer.BufferHandler.newByteBuffer(streamSize);
            while (-1 != (bytesRead = inputStream.read(heapBuffer))) {
                byteBuffer = StaticComponentContainer.BufferHandler.put(byteBuffer, heapBuffer, bytesRead);
            }
            return StaticComponentContainer.BufferHandler.shareContent(byteBuffer);
        }
        catch (Throwable exc) {
            return (ByteBuffer)StaticComponentContainer.Throwables.throwException(exc, new Object[0]);
        }
    }

    @Override
    public ByteBuffer toByteBuffer(InputStream inputStream) {
        return this.toByteBuffer(inputStream, -1);
    }

    @Override
    public StringBuffer getAsStringBuffer(InputStream inputStream) {
        return Executor.get(() -> {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
                String sCurrentLine;
                StringBuffer result = new StringBuffer();
                while ((sCurrentLine = reader.readLine()) != null) {
                    result.append(sCurrentLine + "\n");
                }
                StringBuffer stringBuffer = result;
                return stringBuffer;
            }
        });
    }

    @Override
    public void copy(InputStream input, OutputStream output) {
        Executor.run(() -> {
            byte[] buffer = StaticComponentContainer.BufferHandler.newByteArrayWithDefaultSize();
            int bytesRead = 0;
            while (-1 != (bytesRead = input.read(buffer))) {
                output.write(buffer, 0, bytesRead);
            }
        });
    }

    @Override
    public FileSystemItem store(String fileAbsolutePath, byte[] bytes) {
        return this.store(fileAbsolutePath, StaticComponentContainer.BufferHandler.allocate(bytes.length).put(bytes, 0, bytes.length));
    }

    @Override
    public FileSystemItem store(String fileAbsolutePath, ByteBuffer bytes) {
        ByteBuffer content = StaticComponentContainer.BufferHandler.shareContent(bytes);
        File file = new File(fileAbsolutePath);
        StaticComponentContainer.Synchronizer.execute(fileAbsolutePath, () -> {
            if (!file.exists()) {
                new File(file.getParent()).mkdirs();
            } else {
                file.delete();
            }
            Executor.run(() -> {
                try (ByteBufferInputStream inputStream = new ByteBufferInputStream(content);
                     FileOutputStream fileOutputStream = FileOutputStream.create(file, true);){
                    this.copy(inputStream, fileOutputStream);
                }
            });
        });
        return FileSystemItem.ofPath(file.getAbsolutePath());
    }
}

