/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.core.iterable;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.burningwave.core.function.ThrowingBiConsumer;
import org.burningwave.core.function.ThrowingConsumer;
import org.burningwave.core.iterable.IterableObjectHelperImpl;
import org.burningwave.core.iterable.Properties;

public interface IterableObjectHelper {
    public static IterableObjectHelper create(Properties config) {
        IterableObjectHelperImpl iterableObjectHelper = new IterableObjectHelperImpl(config.getProperty("iterable-object-helper.default-values-separator"), IterableObjectHelperImpl.computeMatxRuntimeThreadsCountThreshold(config));
        iterableObjectHelper.listenTo(config);
        return iterableObjectHelper;
    }

    public String getDefaultValuesSeparator();

    public <K, V> void processChangeNotification(Properties var1, Properties.Event var2, K var3, V var4, V var5);

    public <K, V> void deepClear(Map<K, V> var1);

    public <K, V, E extends Throwable> void deepClear(Map<K, V> var1, ThrowingBiConsumer<K, V, E> var2) throws E;

    public <V> void deepClear(Collection<V> var1);

    public <V, E extends Throwable> void deepClear(Collection<V> var1, ThrowingConsumer<V, E> var2) throws E;

    public <T> Collection<T> merge(Supplier<Collection<T>> var1, Supplier<Collection<T>> var2, Supplier<Collection<T>> var3);

    public <T> T getRandom(Collection<T> var1);

    public <T> Stream<T> retrieveStream(Object var1);

    public long getSize(Object var1);

    public <T> T resolveValue(Map<?, ?> var1, String var2);

    public <T> Collection<T> resolveValues(Map<?, ?> var1, String var2);

    public Collection<String> resolveStringValues(Map<?, ?> var1, String var2);

    public String resolveStringValue(Map<?, ?> var1, String var2);

    public <T> T resolveValue(Map<?, ?> var1, String var2, Map<String, ?> var3);

    public <T> Collection<T> resolveValues(Map<?, ?> var1, String var2, Map<String, ?> var3);

    public String resolveStringValue(Map<?, ?> var1, String var2, Map<String, ?> var3);

    public Collection<String> resolveStringValues(Map<?, ?> var1, String var2, Map<String, ?> var3);

    public <T> T resolveValue(Map<?, ?> var1, String var2, String var3);

    public <T> Collection<T> resolveValues(Map<?, ?> var1, String var2, String var3);

    public String resolveStringValue(Map<?, ?> var1, String var2, String var3);

    public Collection<String> resolveStringValues(Map<?, ?> var1, String var2, String var3);

    public <T> T resolveValue(Map<?, ?> var1, String var2, String var3, boolean var4);

    public <T> Collection<T> resolveValues(Map<?, ?> var1, String var2, String var3, boolean var4);

    public String resolveStringValue(Map<?, ?> var1, String var2, String var3, boolean var4);

    public Collection<String> resolveStringValues(Map<?, ?> var1, String var2, String var3, boolean var4);

    public <T> T resolveValue(Map<?, ?> var1, String var2, String var3, String var4, boolean var5, Map<?, ?> var6);

    public <T> Collection<T> resolveValues(Map<?, ?> var1, String var2, String var3, String var4, boolean var5, Map<?, ?> var6);

    public String resolveStringValue(Map<?, ?> var1, String var2, String var3, String var4, boolean var5, Map<?, ?> var6);

    public Collection<String> resolveStringValues(Map<?, ?> var1, String var2, String var3, String var4, boolean var5, Map<?, ?> var6);

    public Collection<String> getAllPlaceHolders(Map<?, ?> var1);

    public Collection<String> getAllPlaceHolders(Map<?, ?> var1, Predicate<String> var2);

    public Collection<String> getAllPlaceHolders(Map<?, ?> var1, String var2);

    public boolean containsValue(Map<?, ?> var1, String var2, Object var3);

    public <K, V> void refresh(Map<K, V> var1, Map<K, V> var2);

    public boolean containsValue(Map<?, ?> var1, String var2, Object var3, Map<?, ?> var4);

    public <T, O> Collection<O> iterateParallelIf(Collection<T> var1, Consumer<T> var2, Predicate<Collection<T>> var3);

    public <T, O> Collection<O> iterateParallelIf(Collection<T> var1, BiConsumer<T, Consumer<O>> var2, Collection<O> var3, Predicate<Collection<T>> var4);

    public <T, O> void iterateParallel(Collection<T> var1, Consumer<T> var2);

    public <T, O> Collection<O> iterateParallel(Collection<T> var1, BiConsumer<T, Consumer<O>> var2, Collection<O> var3);

    public String toPrettyString(Map<?, ?> var1, String var2, int var3);

    public <K, V> String toString(Map<K, V> var1, int var2);

    public <K, V> String toString(Map<K, V> var1, Function<K, String> var2, Function<V, String> var3, int var4);

    public static class Configuration {
        public static final Map<String, Object> DEFAULT_VALUES;

        static {
            HashMap<String, String> defaultValues = new HashMap<String, String>();
            defaultValues.put("iterable-object-helper.default-values-separator", ";");
            defaultValues.put("iterable-object-helper.parallel-iteration.applicability.max-runtime-threads-count-threshold", "autodetect");
            DEFAULT_VALUES = Collections.unmodifiableMap(defaultValues);
        }

        public static class Key {
            public static final String DEFAULT_VALUES_SEPERATOR = "iterable-object-helper.default-values-separator";
            public static final String PARELLEL_ITERATION_APPLICABILITY_MAX_RUNTIME_THREADS_COUNT_THRESHOLD = "iterable-object-helper.parallel-iteration.applicability.max-runtime-threads-count-threshold";
        }
    }
}

