/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.core.iterable;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.burningwave.core.assembler.StaticComponentContainer;
import org.burningwave.core.concurrent.QueuedTasksExecutor;
import org.burningwave.core.function.ThrowingBiConsumer;
import org.burningwave.core.function.ThrowingConsumer;
import org.burningwave.core.iterable.IterableObjectHelper;
import org.burningwave.core.iterable.Properties;

public class IterableObjectHelperImpl
implements IterableObjectHelper,
Properties.Listener {
    private String defaultValuesSeparator;
    private int maxThreadCountsForParallelIteration;

    IterableObjectHelperImpl(String defaultValuesSeparator, int maxThreadCountsForParallelIteration) {
        if (defaultValuesSeparator == null || defaultValuesSeparator.isEmpty()) {
            defaultValuesSeparator = (String)IterableObjectHelper.Configuration.DEFAULT_VALUES.get("iterable-object-helper.default-values-separator");
        }
        this.defaultValuesSeparator = defaultValuesSeparator;
        this.maxThreadCountsForParallelIteration = maxThreadCountsForParallelIteration;
    }

    @Override
    public String getDefaultValuesSeparator() {
        return this.defaultValuesSeparator;
    }

    static int computeMatxRuntimeThreadsCountThreshold(Properties config) {
        try {
            return StaticComponentContainer.Objects.toInt(config.getProperty("iterable-object-helper.parallel-iteration.applicability.max-runtime-threads-count-threshold"));
        }
        catch (Throwable exc) {
            return Runtime.getRuntime().availableProcessors() * 12;
        }
    }

    @Override
    public <K, V> void processChangeNotification(Properties properties, Properties.Event event, K key, V newValue, V previousValue) {
        if (event.name().equals(Properties.Event.PUT.name()) && key.equals("iterable-object-helper.default-values-separator") && newValue != null) {
            this.defaultValuesSeparator = (String)newValue;
        }
    }

    @Override
    public <K, V> void deepClear(Map<K, V> map) {
        Iterator<Map.Entry<K, V>> itr = map.entrySet().iterator();
        while (itr.hasNext()) {
            itr.next();
            itr.remove();
        }
    }

    @Override
    public <K, V, E extends Throwable> void deepClear(Map<K, V> map, ThrowingBiConsumer<K, V, E> itemDestroyer) throws E {
        Iterator<Map.Entry<K, V>> itr = map.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry<K, V> entry = itr.next();
            itr.remove();
            itemDestroyer.accept(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public <V> void deepClear(Collection<V> map) {
        Iterator<V> itr = map.iterator();
        while (itr.hasNext()) {
            itr.next();
            itr.remove();
        }
    }

    @Override
    public <V, E extends Throwable> void deepClear(Collection<V> map, ThrowingConsumer<V, E> itemDestroyer) throws E {
        Iterator<V> itr = map.iterator();
        while (itr.hasNext()) {
            itr.remove();
            itemDestroyer.accept(itr.next());
        }
    }

    @Override
    public <T> Collection<T> merge(Supplier<Collection<T>> baseCollectionSupplier, Supplier<Collection<T>> additionalCollectionSupplier, Supplier<Collection<T>> defaultCollectionSupplier) {
        Collection mergedCollection = Optional.ofNullable(baseCollectionSupplier.get()).orElseGet(() -> (Collection)defaultCollectionSupplier.get());
        Collection<T> additionalClassPaths = additionalCollectionSupplier.get();
        if (additionalClassPaths != null) {
            mergedCollection.addAll(additionalClassPaths);
        }
        return mergedCollection;
    }

    @Override
    public <T> T getRandom(Collection<T> coll) {
        int num = (int)(Math.random() * (double)coll.size());
        for (T t : coll) {
            if (--num >= 0) continue;
            return t;
        }
        return null;
    }

    @Override
    public <T> Stream<T> retrieveStream(Object object) {
        Stream<T> stream = null;
        if (object != null) {
            if (object instanceof Collection) {
                return ((Collection)object).stream();
            }
            if (object.getClass().isArray()) {
                return Stream.of((Object[])object);
            }
            if (object instanceof Map) {
                return ((Map)object).entrySet().stream();
            }
        }
        return stream;
    }

    @Override
    public long getSize(Object object) {
        return this.retrieveStream(object).count();
    }

    @Override
    public <T> T resolveValue(Map<?, ?> map, String key) {
        return this.resolveValue(key, () -> this.resolve(map, key, null, null, false, null));
    }

    @Override
    public <T> Collection<T> resolveValues(Map<?, ?> map, String key) {
        return (Collection)this.resolve(map, key, null, null, false, null);
    }

    @Override
    public Collection<String> resolveStringValues(Map<?, ?> map, String key) {
        return this.resolveValues(map, key);
    }

    @Override
    public String resolveStringValue(Map<?, ?> map, String key) {
        return (String)this.resolveValue(map, key);
    }

    @Override
    public <T> T resolveValue(Map<?, ?> map, String key, Map<String, ?> defaultValues) {
        return this.resolveValue(key, () -> this.resolve(map, key, null, null, false, defaultValues));
    }

    @Override
    public <T> Collection<T> resolveValues(Map<?, ?> map, String key, Map<String, ?> defaultValues) {
        return (Collection)this.resolve(map, key, null, null, false, defaultValues);
    }

    @Override
    public String resolveStringValue(Map<?, ?> map, String key, Map<String, ?> defaultValues) {
        return (String)this.resolveValue(map, key, defaultValues);
    }

    @Override
    public Collection<String> resolveStringValues(Map<?, ?> map, String key, Map<String, ?> defaultValues) {
        return this.resolveValues(map, key, defaultValues);
    }

    @Override
    public <T> T resolveValue(Map<?, ?> map, String key, String valuesSeparator) {
        return this.resolveValue(key, () -> this.resolve(map, key, valuesSeparator, null, false, null));
    }

    @Override
    public <T> Collection<T> resolveValues(Map<?, ?> map, String key, String valuesSeparator) {
        return (Collection)this.resolve(map, key, valuesSeparator, null, false, null);
    }

    @Override
    public String resolveStringValue(Map<?, ?> map, String key, String valuesSeparator) {
        return (String)this.resolveValue(map, key, valuesSeparator);
    }

    @Override
    public Collection<String> resolveStringValues(Map<?, ?> map, String key, String valuesSeparator) {
        return this.resolveValues(map, key, valuesSeparator);
    }

    @Override
    public <T> T resolveValue(Map<?, ?> map, String key, String valuesSeparator, boolean deleteUnresolvedPlaceHolder) {
        return this.resolveValue(key, () -> this.resolve(map, key, valuesSeparator, null, deleteUnresolvedPlaceHolder, null));
    }

    @Override
    public <T> Collection<T> resolveValues(Map<?, ?> map, String key, String valuesSeparator, boolean deleteUnresolvedPlaceHolder) {
        return (Collection)this.resolve(map, key, valuesSeparator, null, deleteUnresolvedPlaceHolder, null);
    }

    @Override
    public String resolveStringValue(Map<?, ?> map, String key, String valuesSeparator, boolean deleteUnresolvedPlaceHolder) {
        return (String)this.resolveValue(map, key, valuesSeparator, deleteUnresolvedPlaceHolder);
    }

    @Override
    public Collection<String> resolveStringValues(Map<?, ?> map, String key, String valuesSeparator, boolean deleteUnresolvedPlaceHolder) {
        return this.resolveValues(map, key, valuesSeparator, deleteUnresolvedPlaceHolder);
    }

    @Override
    public <T> T resolveValue(Map<?, ?> map, String key, String valuesSeparator, String defaultValuesSeparator, boolean deleteUnresolvedPlaceHolder, Map<?, ?> defaultValues) {
        return this.resolveValue(key, () -> this.resolve(map, key, valuesSeparator, defaultValuesSeparator, deleteUnresolvedPlaceHolder, defaultValues));
    }

    @Override
    public <T> Collection<T> resolveValues(Map<?, ?> map, String key, String valuesSeparator, String defaultValuesSeparator, boolean deleteUnresolvedPlaceHolder, Map<?, ?> defaultValues) {
        return (Collection)this.resolve(map, key, valuesSeparator, defaultValuesSeparator, deleteUnresolvedPlaceHolder, defaultValues);
    }

    @Override
    public String resolveStringValue(Map<?, ?> map, String key, String valuesSeparator, String defaultValuesSeparator, boolean deleteUnresolvedPlaceHolder, Map<?, ?> defaultValues) {
        return (String)this.resolveValue(map, key, valuesSeparator, defaultValuesSeparator, deleteUnresolvedPlaceHolder, defaultValues);
    }

    @Override
    public Collection<String> resolveStringValues(Map<?, ?> map, String key, String valuesSeparator, String defaultValuesSeparator, boolean deleteUnresolvedPlaceHolder, Map<?, ?> defaultValues) {
        return this.resolveValues(map, key, valuesSeparator, defaultValuesSeparator, deleteUnresolvedPlaceHolder, defaultValues);
    }

    private <T> T resolveValue(String key, Supplier<Object> valuesSupplier) {
        Object value = valuesSupplier.get();
        if (value instanceof Collection) {
            Collection values = (Collection)value;
            if (values.size() > 1) {
                StaticComponentContainer.Throwables.throwException("Found more than one item under key {}", key);
            }
            return (T)values.stream().findFirst().orElseGet(() -> null);
        }
        return (T)value;
    }

    private <T> T resolve(Map<?, ?> map, Object key, String valuesSeparator, String defaultValueSeparator, boolean deleteUnresolvedPlaceHolder, Map<?, ?> defaultValues) {
        String valuesSeparatorForSplitting = valuesSeparator != null ? valuesSeparator : (defaultValueSeparator != null ? defaultValueSeparator : this.defaultValuesSeparator);
        Object value = map.get(key);
        if (value == null && defaultValues != null) {
            value = this.resolve(defaultValues, key, valuesSeparator, defaultValueSeparator, deleteUnresolvedPlaceHolder, null);
        }
        if (value != null && value instanceof String) {
            String stringValue = (String)value;
            ArrayList values = new ArrayList();
            if (!StaticComponentContainer.Strings.isEmpty(stringValue)) {
                Map<Integer, List<String>> subProperties = StaticComponentContainer.Strings.extractAllGroups(StaticComponentContainer.Strings.PLACE_HOLDER_NAME_EXTRACTOR_PATTERN, stringValue);
                if (!subProperties.isEmpty()) {
                    for (Map.Entry<Integer, List<String>> entry : subProperties.entrySet()) {
                        for (String placeHolder : entry.getValue()) {
                            String valueObjects = null;
                            if (!placeHolder.startsWith("system.properties:")) {
                                valueObjects = this.resolve(map, placeHolder, valuesSeparator, defaultValueSeparator, deleteUnresolvedPlaceHolder, defaultValues);
                            } else {
                                valueObjects = System.getProperty(placeHolder.split(":")[1]);
                                if (valuesSeparatorForSplitting != null) {
                                    valueObjects = valueObjects.replace(System.getProperty("path.separator"), valuesSeparatorForSplitting);
                                }
                            }
                            if (valueObjects == null) {
                                if (!deleteUnresolvedPlaceHolder) continue;
                                stringValue = stringValue.replaceAll("[^{" + valuesSeparatorForSplitting + "}]*?" + StaticComponentContainer.Strings.placeHolderToRegEx("${" + placeHolder + "}") + ".*?" + valuesSeparatorForSplitting, "");
                                continue;
                            }
                            ArrayList<String> replacements = new ArrayList<String>();
                            if (valueObjects instanceof ArrayList) {
                                replacements.addAll((Collection)((Object)valueObjects));
                            } else {
                                replacements.add(valueObjects);
                            }
                            String regExpPattern = null;
                            regExpPattern = stringValue.contains(valuesSeparatorForSplitting) ? "([^{" + valuesSeparatorForSplitting + "}]*?" + StaticComponentContainer.Strings.placeHolderToRegEx("${" + placeHolder + "}") + ".*?" + valuesSeparatorForSplitting + ")" : "(.*?" + StaticComponentContainer.Strings.placeHolderToRegEx("${" + placeHolder + "}") + ".*?)";
                            Map<Integer, List<String>> placeHolderedValues = StaticComponentContainer.Strings.extractAllGroups(Pattern.compile(regExpPattern), stringValue);
                            for (Map.Entry<Integer, List<String>> placeHolderedValuesEntry : placeHolderedValues.entrySet()) {
                                for (String placeHolderedValue : placeHolderedValuesEntry.getValue()) {
                                    String newReplacement = "";
                                    for (Object e : replacements) {
                                        if (e instanceof String) {
                                            String replacement = (String)e;
                                            if (valuesSeparator != null) {
                                                for (String replacementUnit : replacement.split(valuesSeparatorForSplitting)) {
                                                    newReplacement = newReplacement + placeHolderedValue.replace("${" + placeHolder + "}", replacementUnit);
                                                    newReplacement = newReplacement + (newReplacement.endsWith(valuesSeparatorForSplitting) ? "" : valuesSeparatorForSplitting);
                                                }
                                                continue;
                                            }
                                            newReplacement = newReplacement + placeHolderedValue.replace("${" + placeHolder + "}", replacement);
                                            continue;
                                        }
                                        values.add(e);
                                    }
                                    stringValue = stringValue.replace(placeHolderedValue, newReplacement);
                                }
                            }
                        }
                    }
                    if (stringValue != null && !stringValue.isEmpty()) {
                        if (valuesSeparator == null) {
                            values.add(stringValue);
                        } else {
                            for (String valueToAdd : stringValue.split(valuesSeparatorForSplitting)) {
                                values.add(valueToAdd);
                            }
                        }
                    }
                } else if (valuesSeparator != null) {
                    for (String valueToAdd : stringValue.split(valuesSeparatorForSplitting)) {
                        values.add(valueToAdd);
                    }
                } else {
                    values.add(stringValue);
                }
            }
            return (T)values;
        }
        return (T)value;
    }

    @Override
    public Collection<String> getAllPlaceHolders(Map<?, ?> map) {
        return this.getAllPlaceHolders(map, (String object) -> true);
    }

    @Override
    public Collection<String> getAllPlaceHolders(Map<?, ?> map, Predicate<String> propertyFilter) {
        HashSet<String> placeHolders = new HashSet<String>();
        for (Map.Entry entry2 : map.entrySet().stream().filter(entry -> (entry.getValue() == null || entry.getValue() instanceof String) && entry.getKey() instanceof String && propertyFilter.test((String)entry.getKey())).collect(Collectors.toSet())) {
            String value = (String)entry2.getValue();
            for (List<String> placeHoldersFound : StaticComponentContainer.Strings.extractAllGroups(StaticComponentContainer.Strings.PLACE_HOLDER_EXTRACTOR_PATTERN, value).values()) {
                placeHolders.addAll(placeHoldersFound);
            }
        }
        return placeHolders;
    }

    @Override
    public Collection<String> getAllPlaceHolders(Map<?, ?> map, String propertyName) {
        Collection<String> placeHolders = this.getAllPlaceHolders(map);
        Iterator<String> placeHoldersItr = placeHolders.iterator();
        while (placeHoldersItr.hasNext()) {
            if (this.containsValue(map, propertyName, placeHoldersItr.next())) continue;
            placeHoldersItr.remove();
        }
        return placeHolders;
    }

    @Override
    public boolean containsValue(Map<?, ?> map, String key, Object object) {
        return this.containsValue(map, key, object, null);
    }

    @Override
    public <K, V> void refresh(Map<K, V> source, Map<K, V> newValues) {
        K key;
        HashSet<K> keyToBeRemoved = new HashSet<K>();
        HashMap<K, V> keyAndValuesToBePut = new HashMap<K, V>();
        for (Map.Entry<K, V> keyAndValue : source.entrySet()) {
            key = keyAndValue.getKey();
            if (newValues.containsKey(key)) {
                V newValue;
                V oldValue = newValues.get(key);
                if (Objects.equals(oldValue, newValue = newValues.get(key))) continue;
                keyAndValuesToBePut.put(key, newValue);
                continue;
            }
            keyToBeRemoved.add(key);
        }
        for (Map.Entry<K, V> keyAndValue : newValues.entrySet()) {
            key = keyAndValue.getKey();
            if (source.containsKey(key)) continue;
            keyAndValuesToBePut.put(key, keyAndValue.getValue());
        }
        source.keySet().removeAll(keyToBeRemoved);
        source.putAll(keyAndValuesToBePut);
    }

    @Override
    public boolean containsValue(Map<?, ?> map, String key, Object object, Map<?, ?> defaultValues) {
        Object value = map.get(key);
        if (value == null && defaultValues != null) {
            value = defaultValues.get(key);
        }
        if (value != null && value instanceof String) {
            String stringValue;
            if (StaticComponentContainer.Strings.isEmpty((String)value) && defaultValues != null) {
                value = defaultValues.get(key);
            }
            if (value != null && value instanceof String && !StaticComponentContainer.Strings.isEmpty(stringValue = (String)value)) {
                String objectString;
                if (object instanceof String && stringValue.contains(objectString = (String)object)) {
                    return true;
                }
                Map<Integer, List<String>> subProperties = StaticComponentContainer.Strings.extractAllGroups(StaticComponentContainer.Strings.PLACE_HOLDER_NAME_EXTRACTOR_PATTERN, stringValue);
                if (!subProperties.isEmpty()) {
                    for (Map.Entry<Integer, List<String>> entry : subProperties.entrySet()) {
                        Iterator<String> iterator = entry.getValue().iterator();
                        if (!iterator.hasNext()) continue;
                        String propName = iterator.next();
                        return this.containsValue(map, propName, object, defaultValues);
                    }
                }
            }
        }
        return object != null && value != null && object.equals(value);
    }

    @Override
    public <T, O> Collection<O> iterateParallelIf(Collection<T> items, Consumer<T> action, Predicate<Collection<T>> predicate) {
        return this.iterateParallelIf(items, (item, outputItemCollector) -> action.accept(item), null, predicate);
    }

    @Override
    public <T, O> Collection<O> iterateParallelIf(Collection<T> items, BiConsumer<T, Consumer<O>> action, Collection<O> outputCollection, Predicate<Collection<T>> predicate) {
        if (predicate.test(items) && this.maxThreadCountsForParallelIteration >= StaticComponentContainer.Synchronizer.getAllThreads().length) {
            return this.iterateParallel(items, action, outputCollection);
        }
        Consumer<Object> outputItemCollector = outputCollection != null ? outputItem -> outputCollection.add(outputItem) : null;
        for (T item : items) {
            action.accept(item, outputItemCollector);
        }
        return outputCollection;
    }

    @Override
    public <T, O> void iterateParallel(Collection<T> items, Consumer<T> action) {
        this.iterateParallel(items, (item, outputItemCollector) -> action.accept(item), null);
    }

    @Override
    public <T, O> Collection<O> iterateParallel(Collection<T> items, BiConsumer<T, Consumer<O>> action, Collection<O> outputCollection) {
        Iterator itemIterator = items.iterator();
        Consumer<Object> outputItemCollector = outputCollection != null ? (outputCollection instanceof ConcurrentHashMap.KeySetView || outputCollection instanceof CopyOnWriteArrayList || outputCollection instanceof CopyOnWriteArraySet ? outputItem -> outputCollection.add(outputItem) : outputItem -> {
            Collection collection = outputCollection;
            synchronized (collection) {
                outputCollection.add(outputItem);
            }
        }) : null;
        HashSet<QueuedTasksExecutor.Task> tasks = new HashSet<QueuedTasksExecutor.Task>();
        int taskCount = Math.min(Runtime.getRuntime().availableProcessors(), items.size());
        for (int i = 0; i < taskCount; ++i) {
            tasks.add((QueuedTasksExecutor.Task)StaticComponentContainer.BackgroundExecutor.createTask(() -> {
                while (true) {
                    Object item = null;
                    try {
                        Iterator iterator = itemIterator;
                        synchronized (iterator) {
                            item = itemIterator.next();
                        }
                    }
                    catch (NoSuchElementException exc) {
                        break;
                    }
                    action.accept(item, outputItemCollector);
                }
            }).submit());
        }
        tasks.stream().forEach(task -> task.waitForFinish());
        return outputCollection;
    }

    private String toPrettyKeyValueLabel(Map.Entry<?, ?> entry, String valuesSeparator, int marginTabCount) {
        String margin = new String(new char[marginTabCount]).replace('\u0000', '\t');
        String keyValueLabel = margin + entry.getKey() + "=\\\n" + margin + "\t" + entry.getValue().toString().replace(valuesSeparator, valuesSeparator + "\\\n" + margin + "\t");
        keyValueLabel = keyValueLabel.endsWith(valuesSeparator + "\\\n" + margin + "\t") ? keyValueLabel.substring(0, keyValueLabel.lastIndexOf("\\\n" + margin + "\t")) : keyValueLabel;
        return keyValueLabel;
    }

    @Override
    public String toPrettyString(Map<?, ?> map, String valuesSeparator, int marginTabCount) {
        TreeMap<Object, Object> allValues = map instanceof TreeMap ? (TreeMap<Object, Object>)map : new TreeMap(map);
        return allValues.entrySet().stream().map(entry -> this.toPrettyKeyValueLabel((Map.Entry<?, ?>)entry, valuesSeparator, marginTabCount)).collect(Collectors.joining("\n"));
    }

    @Override
    public <K, V> String toString(Map<K, V> map, int marginTabCount) {
        return this.toString(map, key -> key.toString(), value -> value.toString(), marginTabCount);
    }

    @Override
    public <K, V> String toString(Map<K, V> map, Function<K, String> keyTransformer, Function<V, String> valueTransformer, int marginTabCount) {
        TreeMap allValues = map instanceof TreeMap ? (TreeMap)map : new TreeMap<K, V>(map);
        String margin = new String(new char[marginTabCount]).replace('\u0000', '\t');
        return allValues.entrySet().stream().map(entry -> margin + (String)keyTransformer.apply(entry.getKey()) + "=" + Optional.ofNullable(entry.getValue()).map(value -> (String)valueTransformer.apply(value)).orElseGet(() -> "null")).collect(Collectors.joining("\n"));
    }

    private class ArrayList<E>
    extends java.util.ArrayList<E> {
        private static final long serialVersionUID = -8096435103182655041L;

        private ArrayList() {
        }
    }
}

