/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.core.iterable;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.burningwave.core.ManagedLogger;
import org.burningwave.core.assembler.StaticComponentContainer;

public class Properties
extends java.util.Properties
implements ManagedLogger {
    private static final long serialVersionUID = -350748766178421942L;
    private Set<Listener> listeners = ConcurrentHashMap.newKeySet();
    private String defaultValuesSeparator;

    public Properties(Properties defaults) {
        this(defaults, null);
    }

    public Properties() {
        this(null, null);
    }

    public Properties(Properties defaults, String defaultValuesSeparator) {
        super(defaults);
        this.defaultValuesSeparator = defaultValuesSeparator;
    }

    public String getDefaultValuesSeparator() {
        return this.defaultValuesSeparator != null ? this.defaultValuesSeparator : StaticComponentContainer.IterableObjectHelper.getDefaultValuesSeparator();
    }

    public <T> T resolveValue(String key) {
        return StaticComponentContainer.IterableObjectHelper.resolveValue(this, key, null, this.defaultValuesSeparator, false, this.defaults);
    }

    public <T> Collection<T> resolveValues(String key) {
        return StaticComponentContainer.IterableObjectHelper.resolveValues(this, key, null, this.defaultValuesSeparator, false, this.defaults);
    }

    public String resolveStringValue(String key) {
        return StaticComponentContainer.IterableObjectHelper.resolveStringValue(this, key, null, this.defaultValuesSeparator, false, this.defaults);
    }

    public Collection<String> resolveStringValues(String key) {
        return StaticComponentContainer.IterableObjectHelper.resolveStringValues(this, key, null, this.defaultValuesSeparator, false, this.defaults);
    }

    public <T> T resolveValue(String key, Map<?, ?> defaultValues) {
        return StaticComponentContainer.IterableObjectHelper.resolveValue(this, key, null, this.defaultValuesSeparator, false, defaultValues);
    }

    public <T> Collection<T> resolveValues(String key, Map<?, ?> defaultValues) {
        return StaticComponentContainer.IterableObjectHelper.resolveValues(this, key, null, this.defaultValuesSeparator, false, defaultValues);
    }

    public String resolveStringValue(String key, Map<?, ?> defaultValues) {
        return StaticComponentContainer.IterableObjectHelper.resolveStringValue(this, key, null, this.defaultValuesSeparator, false, defaultValues);
    }

    public Collection<String> resolveStringValues(String key, Map<?, ?> defaultValues) {
        return StaticComponentContainer.IterableObjectHelper.resolveStringValues(this, key, null, this.defaultValuesSeparator, false, defaultValues);
    }

    public <T> T resolveValue(String key, String valuesSeparator) {
        return StaticComponentContainer.IterableObjectHelper.resolveValue(this, key, valuesSeparator, this.defaultValuesSeparator, false, this.defaults);
    }

    public <T> Collection<T> resolveValues(String key, String valuesSeparator) {
        return StaticComponentContainer.IterableObjectHelper.resolveValues(this, key, valuesSeparator, this.defaultValuesSeparator, false, this.defaults);
    }

    public String resolveStringValue(String key, String valuesSeparator) {
        return StaticComponentContainer.IterableObjectHelper.resolveStringValue(this, key, valuesSeparator, this.defaultValuesSeparator, false, this.defaults);
    }

    public Collection<String> resolveStringValues(String key, String valuesSeparator) {
        return StaticComponentContainer.IterableObjectHelper.resolveStringValues(this, key, valuesSeparator, this.defaultValuesSeparator, false, this.defaults);
    }

    public <T> T resolveValue(String key, String valuesSeparator, boolean deleteUnresolvedPlaceHolder) {
        return StaticComponentContainer.IterableObjectHelper.resolveValue(this, key, valuesSeparator, this.defaultValuesSeparator, deleteUnresolvedPlaceHolder, this.defaults);
    }

    public <T> Collection<T> resolveValues(String key, String valuesSeparator, boolean deleteUnresolvedPlaceHolder) {
        return StaticComponentContainer.IterableObjectHelper.resolveValues(this, key, valuesSeparator, this.defaultValuesSeparator, deleteUnresolvedPlaceHolder, this.defaults);
    }

    public String resolveStringValue(String key, String valuesSeparator, boolean deleteUnresolvedPlaceHolder) {
        return StaticComponentContainer.IterableObjectHelper.resolveStringValue(this, key, valuesSeparator, this.defaultValuesSeparator, deleteUnresolvedPlaceHolder, this.defaults);
    }

    public Collection<String> resolveStringValues(String key, String valuesSeparator, boolean deleteUnresolvedPlaceHolder) {
        return StaticComponentContainer.IterableObjectHelper.resolveStringValues(this, key, valuesSeparator, this.defaultValuesSeparator, deleteUnresolvedPlaceHolder, this.defaults);
    }

    public Collection<String> getAllPlaceHolders(String propertyName) {
        return StaticComponentContainer.IterableObjectHelper.getAllPlaceHolders(this, propertyName);
    }

    @Override
    public synchronized Object put(Object key, Object value) {
        Object oldValue = super.put(key, value);
        this.notifyChange(Event.PUT, key, value, oldValue);
        return oldValue;
    }

    @Override
    public synchronized Object remove(Object key) {
        Object removed = super.remove(key);
        this.notifyChange(Event.REMOVE, key, null, removed);
        return removed;
    }

    public Map<Object, Object> toMap(Supplier<Map<Object, Object>> mapSupplier) {
        Map<Object, Object> allValues = mapSupplier.get();
        if (this.defaults != null) {
            allValues.putAll(this.defaults);
        }
        allValues.putAll(this);
        return allValues;
    }

    public String toSimplePrettyString() {
        return this.toSimplePrettyString(0);
    }

    public String toSimplePrettyString(int marginTabCount) {
        return StaticComponentContainer.IterableObjectHelper.toString(this.toMap(TreeMap::new), marginTabCount);
    }

    public String toPrettyString() {
        return this.toPrettyString(0);
    }

    public String toPrettyString(int marginTabCount) {
        return StaticComponentContainer.IterableObjectHelper.toPrettyString(this.toMap(TreeMap::new), this.getDefaultValuesSeparator(), marginTabCount);
    }

    private void notifyChange(Event event, Object key, Object newValue, Object oldValue) {
        for (Listener listener : this.listeners) {
            try {
                listener.processChangeNotification(this, event, key, newValue, oldValue);
            }
            catch (Throwable exc) {
                StaticComponentContainer.ManagedLoggersRepository.logError(this.getClass()::getName, "Exception occurred while notifying: " + event.name() + " -> (" + key + " - " + newValue + ") to " + listener, exc);
                StaticComponentContainer.ManagedLoggersRepository.logWarn(this.getClass()::getName, "Resetting {} to previous value: {}", key, oldValue);
                this.put(key, oldValue);
            }
        }
    }

    public static enum Event {
        PUT,
        REMOVE;

    }

    public static interface Listener {
        default public <T extends Listener> T listenTo(Properties properties) {
            properties.listeners.add(this);
            return (T)this;
        }

        default public <T extends Listener> T unregister(Properties properties) {
            properties.listeners.remove(this);
            return (T)this;
        }

        default public <K, V> void processChangeNotification(Properties properties, Event event, K key, V newValue, V previousValue) {
        }
    }
}

