/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacpp.indexer;

import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.ShortPointer;
import org.bytedeco.javacpp.indexer.Raw;
import org.bytedeco.javacpp.indexer.UShortIndexer;

public class UShortRawIndexer
extends UShortIndexer {
    protected static final Raw RAW = Raw.getInstance();
    protected ShortPointer pointer;
    final long base;
    final long size;

    public UShortRawIndexer(ShortPointer pointer) {
        this(pointer, new long[]{pointer.limit() - pointer.position()}, ONE_STRIDE);
    }

    public UShortRawIndexer(ShortPointer pointer, long[] sizes, long[] strides) {
        super(sizes, strides);
        this.pointer = pointer;
        this.base = pointer.address() + pointer.position() * 2L;
        this.size = pointer.limit() - pointer.position();
    }

    @Override
    public Pointer pointer() {
        return this.pointer;
    }

    @Override
    public int get(long i) {
        return RAW.getShort(this.base + UShortRawIndexer.checkIndex(i, this.size) * 2L) & 0xFFFF;
    }

    @Override
    public UShortIndexer get(long i, int[] s, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            s[offset + n] = this.get(i * this.strides[0] + (long)n) & 0xFFFF;
        }
        return this;
    }

    @Override
    public int get(long i, long j) {
        return this.get(i * this.strides[0] + j) & 0xFFFF;
    }

    @Override
    public UShortIndexer get(long i, long j, int[] s, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            s[offset + n] = this.get(i * this.strides[0] + j * this.strides[1] + (long)n) & 0xFFFF;
        }
        return this;
    }

    @Override
    public int get(long i, long j, long k) {
        return this.get(i * this.strides[0] + j * this.strides[1] + k) & 0xFFFF;
    }

    @Override
    public int get(long ... indices) {
        return this.get(this.index(indices)) & 0xFFFF;
    }

    @Override
    public UShortIndexer get(long[] indices, int[] s, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            s[offset + n] = this.get(this.index(indices) + (long)n) & 0xFFFF;
        }
        return this;
    }

    @Override
    public UShortIndexer put(long i, int s) {
        RAW.putShort(this.base + UShortRawIndexer.checkIndex(i, this.size) * 2L, (short)s);
        return this;
    }

    @Override
    public UShortIndexer put(long i, int[] s, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.put(i * this.strides[0] + (long)n, (int)((short)s[offset + n]));
        }
        return this;
    }

    @Override
    public UShortIndexer put(long i, long j, int s) {
        this.put(i * this.strides[0] + j, (int)((short)s));
        return this;
    }

    @Override
    public UShortIndexer put(long i, long j, int[] s, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.put(i * this.strides[0] + j * this.strides[1] + (long)n, (int)((short)s[offset + n]));
        }
        return this;
    }

    @Override
    public UShortIndexer put(long i, long j, long k, int s) {
        this.put(i * this.strides[0] + j * this.strides[1] + k, (int)((short)s));
        return this;
    }

    @Override
    public UShortIndexer put(long[] indices, int s) {
        this.put(this.index(indices), (int)((short)s));
        return this;
    }

    @Override
    public UShortIndexer put(long[] indices, int[] s, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.put(this.index(indices) + (long)n, (int)((short)s[offset + n]));
        }
        return this;
    }

    @Override
    public void release() {
        this.pointer = null;
    }
}

