/*
 * Decompiled with CFR 0.152.
 */
package org.casbin.jcasbin.rbac;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import org.casbin.jcasbin.rbac.Role;

class DomainRoles {
    private Map<String, Role> roles = new HashMap<String, Role>();

    DomainRoles() {
    }

    public void forEach(BiConsumer<? super String, ? super Role> action) {
        this.roles.forEach(action);
    }

    public boolean hasRole(String name) {
        return this.hasRole(name, null);
    }

    public boolean hasRole(String name, BiPredicate<String, String> matchingFunc) {
        if (matchingFunc != null) {
            return this.roles.keySet().stream().anyMatch(r -> matchingFunc.test(name, (String)r));
        }
        return this.roles.containsKey(name);
    }

    public Role createRole(String name, BiPredicate<String, String> matchingFunc) {
        Role role = this.roles.computeIfAbsent(name, Role::new);
        if (matchingFunc != null) {
            this.roles.entrySet().stream().filter(roleEntry -> this.isRoleEntryMatchExists((Map.Entry<String, Role>)roleEntry, name, matchingFunc)).forEach((? super T roleEntry) -> role.addRole((Role)roleEntry.getValue()));
        }
        return role;
    }

    private boolean isRoleEntryMatchExists(Map.Entry<String, Role> roleEntry, String name, BiPredicate<String, String> matchingFunc) {
        return matchingFunc.test(name, roleEntry.getKey()) && !name.equals(roleEntry.getKey());
    }

    public Role getOrCreate(String name) {
        return this.roles.computeIfAbsent(name, Role::new);
    }
}

