/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.database.sqlserver;

import java.util.Map;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.extensibility.ConfigurationExtension;
import org.flywaydb.core.internal.license.FlywayTeamsUpgradeRequiredException;
import org.flywaydb.core.internal.util.StringUtils;

public class SQLServerConfigurationExtension
implements ConfigurationExtension {
    private static final Log LOG = LogFactory.getLog(SQLServerConfigurationExtension.class);
    private static final String SQLSERVER_KERBEROS_LOGIN_FILE = "sqlserver.kerberos.login.file";
    private static final String KERBEROS_LOGIN_FILE = "flyway.plugins.sqlserver.kerberos.login.file";
    private String kerberosLoginFile;

    public void extractParametersFromConfiguration(Map<String, String> configuration) {
        this.kerberosLoginFile = this.getProperty(configuration, KERBEROS_LOGIN_FILE, this.kerberosLoginFile);
    }

    public String getConfigurationParameterFromEnvironmentVariable(String environmentVariable) {
        switch (environmentVariable) {
            case "FLYWAY_PLUGINS_SQL_SERVER_KERBEROS_LOGIN_FILE": {
                return KERBEROS_LOGIN_FILE;
            }
        }
        return null;
    }

    private String getProperty(Map<String, String> configuration, String key, String fallback) {
        if (StringUtils.hasText((String)fallback)) {
            throw new FlywayTeamsUpgradeRequiredException(SQLSERVER_KERBEROS_LOGIN_FILE);
        }
        return null;
    }

    public String getKerberosLoginFile() {
        return this.kerberosLoginFile;
    }

    public void setKerberosLoginFile(String kerberosLoginFile) {
        this.kerberosLoginFile = kerberosLoginFile;
    }
}

