/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab4j.api;

import java.util.List;
import java.util.stream.Stream;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;
import org.gitlab4j.api.AbstractApi;
import org.gitlab4j.api.GitLabApi;
import org.gitlab4j.api.GitLabApiException;
import org.gitlab4j.api.Pager;
import org.gitlab4j.api.models.Package;
import org.gitlab4j.api.models.PackageFile;

public class PackagesApi
extends AbstractApi {
    public PackagesApi(GitLabApi gitLabApi) {
        super(gitLabApi);
    }

    public List<Package> getPackages(Object projectIdOrPath) throws GitLabApiException {
        return this.getPackages(projectIdOrPath, this.getDefaultPerPage()).all();
    }

    public List<Package> getPackages(Object projectIdOrPath, int page, int perPage) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getPageQueryParams(page, perPage), "projects", this.getProjectIdOrPath(projectIdOrPath), "packages");
        return (List)response.readEntity((GenericType)new GenericType<List<Package>>(){});
    }

    public Pager<Package> getPackages(Object projectIdOrPath, int itemsPerPage) throws GitLabApiException {
        return new Pager<Package>(this, Package.class, itemsPerPage, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "packages");
    }

    public Stream<Package> getPackagesStream(Object projectIdOrPath) throws GitLabApiException {
        return this.getPackages(projectIdOrPath, this.getDefaultPerPage()).stream();
    }

    public Package getPackage(Object projectIdOrPath, Integer packageId) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "packages", packageId);
        return (Package)response.readEntity(Package.class);
    }

    public List<PackageFile> getPackageFiles(Object projectIdOrPath, Integer packageId) throws GitLabApiException {
        return this.getPackageFiles(projectIdOrPath, packageId, this.getDefaultPerPage()).all();
    }

    public List<PackageFile> getPackageFiles(Object projectIdOrPath, Integer packageId, int page, int perPage) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getPageQueryParams(page, perPage), "projects", this.getProjectIdOrPath(projectIdOrPath), "packages", packageId, "package_files");
        return (List)response.readEntity((GenericType)new GenericType<List<PackageFile>>(){});
    }

    public Pager<PackageFile> getPackageFiles(Object projectIdOrPath, Integer packageId, int itemsPerPage) throws GitLabApiException {
        return new Pager<PackageFile>(this, PackageFile.class, itemsPerPage, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "packages", packageId, "package_files");
    }

    public Stream<PackageFile> getPackagesStream(Object projectIdOrPath, Integer packageId) throws GitLabApiException {
        return this.getPackageFiles(projectIdOrPath, packageId, this.getDefaultPerPage()).stream();
    }

    public void deletePackage(Object projectIdOrPath, Integer packageId) throws GitLabApiException {
        if (packageId == null) {
            throw new RuntimeException("packageId cannot be null");
        }
        this.delete(Response.Status.NO_CONTENT, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "packages", packageId);
    }
}

