/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab4j.api;

import java.util.List;
import java.util.stream.Stream;
import javax.ws.rs.core.MultivaluedMap;
import org.gitlab4j.api.AbstractApi;
import org.gitlab4j.api.Constants;
import org.gitlab4j.api.GitLabApi;
import org.gitlab4j.api.GitLabApiException;
import org.gitlab4j.api.GitLabApiForm;
import org.gitlab4j.api.Pager;
import org.gitlab4j.api.models.Commit;
import org.gitlab4j.api.models.Issue;
import org.gitlab4j.api.models.MergeRequest;
import org.gitlab4j.api.models.Milestone;
import org.gitlab4j.api.models.Note;
import org.gitlab4j.api.models.Project;
import org.gitlab4j.api.models.SearchBlob;
import org.gitlab4j.api.models.Snippet;
import org.gitlab4j.api.models.User;

public class SearchApi
extends AbstractApi {
    public SearchApi(GitLabApi gitLabApi) {
        super(gitLabApi);
    }

    public List<?> globalSearch(Constants.SearchScope scope, String search) throws GitLabApiException {
        return this.globalSearch(scope, search, this.getDefaultPerPage()).all();
    }

    public Stream<?> globalSearchStream(Constants.SearchScope scope, String search) throws GitLabApiException {
        return this.globalSearch(scope, search, this.getDefaultPerPage()).stream();
    }

    public Pager<?> globalSearch(Constants.SearchScope scope, String search, int itemsPerPage) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("scope", (Object)scope, true).withParam("search", search, true);
        switch (scope) {
            case BLOBS: {
                return new Pager<SearchBlob>(this, SearchBlob.class, itemsPerPage, (MultivaluedMap<String, String>)formData.asMap(), "search");
            }
            case COMMITS: {
                return new Pager<Commit>(this, Commit.class, itemsPerPage, (MultivaluedMap<String, String>)formData.asMap(), "search");
            }
            case PROJECTS: {
                return new Pager<Project>(this, Project.class, itemsPerPage, (MultivaluedMap<String, String>)formData.asMap(), "search");
            }
            case ISSUES: {
                return new Pager<Issue>(this, Issue.class, itemsPerPage, (MultivaluedMap<String, String>)formData.asMap(), "search");
            }
            case MERGE_REQUESTS: {
                return new Pager<MergeRequest>(this, MergeRequest.class, itemsPerPage, (MultivaluedMap<String, String>)formData.asMap(), "search");
            }
            case MILESTONES: {
                return new Pager<Milestone>(this, Milestone.class, itemsPerPage, (MultivaluedMap<String, String>)formData.asMap(), "search");
            }
            case SNIPPET_TITLES: {
                return new Pager<Snippet>(this, Snippet.class, itemsPerPage, (MultivaluedMap<String, String>)formData.asMap(), "search");
            }
            case SNIPPET_BLOBS: {
                return new Pager<Snippet>(this, Snippet.class, itemsPerPage, (MultivaluedMap<String, String>)formData.asMap(), "search");
            }
            case USERS: {
                return new Pager<User>(this, User.class, itemsPerPage, (MultivaluedMap<String, String>)formData.asMap(), "search");
            }
            case WIKI_BLOBS: {
                return new Pager<SearchBlob>(this, SearchBlob.class, itemsPerPage, (MultivaluedMap<String, String>)formData.asMap(), "search");
            }
        }
        throw new GitLabApiException("Invalid SearchScope [" + (Object)((Object)scope) + "]");
    }

    public List<?> groupSearch(Object groupIdOrPath, Constants.GroupSearchScope scope, String search) throws GitLabApiException {
        return this.groupSearch(groupIdOrPath, scope, search, this.getDefaultPerPage()).all();
    }

    public Stream<?> groupSearchStream(Object groupIdOrPath, Constants.GroupSearchScope scope, String search) throws GitLabApiException {
        return this.groupSearch(groupIdOrPath, scope, search, this.getDefaultPerPage()).stream();
    }

    public Pager<?> groupSearch(Object groupIdOrPath, Constants.GroupSearchScope scope, String search, int itemsPerPage) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("scope", (Object)scope, true).withParam("search", search, true);
        switch (scope) {
            case PROJECTS: {
                return new Pager<Project>(this, Project.class, itemsPerPage, (MultivaluedMap<String, String>)formData.asMap(), "groups", this.getGroupIdOrPath(groupIdOrPath), "search");
            }
            case ISSUES: {
                return new Pager<Issue>(this, Issue.class, itemsPerPage, (MultivaluedMap<String, String>)formData.asMap(), "groups", this.getGroupIdOrPath(groupIdOrPath), "search");
            }
            case MERGE_REQUESTS: {
                return new Pager<MergeRequest>(this, MergeRequest.class, itemsPerPage, (MultivaluedMap<String, String>)formData.asMap(), "groups", this.getGroupIdOrPath(groupIdOrPath), "search");
            }
            case MILESTONES: {
                return new Pager<Milestone>(this, Milestone.class, itemsPerPage, (MultivaluedMap<String, String>)formData.asMap(), "groups", this.getGroupIdOrPath(groupIdOrPath), "search");
            }
            case USERS: {
                return new Pager<User>(this, User.class, itemsPerPage, (MultivaluedMap<String, String>)formData.asMap(), "groups", this.getGroupIdOrPath(groupIdOrPath), "search");
            }
        }
        throw new GitLabApiException("Invalid GroupSearchScope [" + (Object)((Object)scope) + "]");
    }

    public List<?> projectSearch(Object projectIdOrPath, Constants.ProjectSearchScope scope, String search) throws GitLabApiException {
        return this.projectSearch(projectIdOrPath, scope, search, this.getDefaultPerPage()).all();
    }

    public Stream<?> projectSearchStream(Object projectIdOrPath, Constants.ProjectSearchScope scope, String search) throws GitLabApiException {
        return this.projectSearch(projectIdOrPath, scope, search, this.getDefaultPerPage()).stream();
    }

    public Pager<?> projectSearch(Object projectIdOrPath, Constants.ProjectSearchScope scope, String search, int itemsPerPage) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("scope", (Object)scope, true).withParam("search", search, true);
        switch (scope) {
            case BLOBS: {
                return new Pager<SearchBlob>(this, SearchBlob.class, itemsPerPage, (MultivaluedMap<String, String>)formData.asMap(), "projects", this.getProjectIdOrPath(projectIdOrPath), "search");
            }
            case COMMITS: {
                return new Pager<Commit>(this, Commit.class, itemsPerPage, (MultivaluedMap<String, String>)formData.asMap(), "projects", this.getProjectIdOrPath(projectIdOrPath), "search");
            }
            case ISSUES: {
                return new Pager<Issue>(this, Issue.class, itemsPerPage, (MultivaluedMap<String, String>)formData.asMap(), "projects", this.getProjectIdOrPath(projectIdOrPath), "search");
            }
            case MERGE_REQUESTS: {
                return new Pager<MergeRequest>(this, MergeRequest.class, itemsPerPage, (MultivaluedMap<String, String>)formData.asMap(), "projects", this.getProjectIdOrPath(projectIdOrPath), "search");
            }
            case MILESTONES: {
                return new Pager<Milestone>(this, Milestone.class, itemsPerPage, (MultivaluedMap<String, String>)formData.asMap(), "projects", this.getProjectIdOrPath(projectIdOrPath), "search");
            }
            case NOTES: {
                return new Pager<Note>(this, Note.class, itemsPerPage, (MultivaluedMap<String, String>)formData.asMap(), "projects", this.getProjectIdOrPath(projectIdOrPath), "search");
            }
            case WIKI_BLOBS: {
                return new Pager<SearchBlob>(this, SearchBlob.class, itemsPerPage, (MultivaluedMap<String, String>)formData.asMap(), "projects", this.getProjectIdOrPath(projectIdOrPath), "search");
            }
            case USERS: {
                return new Pager<User>(this, User.class, itemsPerPage, (MultivaluedMap<String, String>)formData.asMap(), "projects", this.getProjectIdOrPath(projectIdOrPath), "search");
            }
        }
        throw new GitLabApiException("Invalid ProjectSearchScope [" + (Object)((Object)scope) + "]");
    }
}

