/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.common.monitor;

import java.io.Serializable;
import java.text.DecimalFormat;
import net.jcip.annotations.Immutable;
import org.jboss.dna.common.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class ProgressStatus
implements Serializable,
Comparable<ProgressStatus> {
    private static final long serialVersionUID = -7771764546193063275L;
    protected static final String PERCENTAGE_PATTERN = "##0.0";
    protected static final double PERCENT_PRECISION = 0.001;
    private final String activityName;
    private final double percentWorked;
    private final boolean done;
    private final boolean cancelled;
    private final String message;

    protected static double computePercentage(double workedSoFar, double totalWork) {
        if (ProgressStatus.isSamePercentage(workedSoFar, 0.0)) {
            return 0.0;
        }
        assert (totalWork > 0.0);
        double percentage = workedSoFar / totalWork * 100.0;
        if (ProgressStatus.isSamePercentage(percentage, 100.0)) {
            percentage = 100.0;
        }
        return percentage;
    }

    protected static boolean isSamePercentage(double percentage1, double percentage2) {
        return Math.abs(percentage1 - percentage2) <= 0.001;
    }

    public ProgressStatus(String activityName, String message, double percentWorked, boolean cancelled) {
        assert (activityName != null);
        assert (message != null);
        this.activityName = activityName;
        boolean bl = this.done = percentWorked >= 100.0;
        this.percentWorked = this.done ? 100.0 : (percentWorked <= 0.0 ? 0.0 : percentWorked);
        this.message = message;
        this.cancelled = cancelled;
    }

    public ProgressStatus(String activityName, String message, double workedSoFar, double totalWork, boolean cancelled) {
        this(activityName, message, ProgressStatus.computePercentage(workedSoFar, totalWork), cancelled);
    }

    public String getActivityName() {
        return this.activityName;
    }

    public double getPercentWorked() {
        return this.percentWorked;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean isDone() {
        return this.done;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public String toString() {
        String percentage = new DecimalFormat(PERCENTAGE_PATTERN).format(this.getPercentWorked());
        percentage = StringUtil.justifyRight(percentage, PERCENTAGE_PATTERN.length(), ' ');
        String cancelled = this.isCancelled() ? " (cancelled)" : "";
        return this.activityName + " (" + this.message + ") " + percentage + " %" + cancelled;
    }

    public int hashCode() {
        return this.getActivityName().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ProgressStatus) {
            ProgressStatus that = (ProgressStatus)obj;
            if (!this.getActivityName().equals(that.getActivityName())) {
                return false;
            }
            if (this.isDone() != that.isDone()) {
                return false;
            }
            return ProgressStatus.isSamePercentage(this.getPercentWorked(), that.getPercentWorked());
        }
        return false;
    }

    @Override
    public int compareTo(ProgressStatus that) {
        if (this == that) {
            return 0;
        }
        int diff = this.getActivityName().compareTo(that.getActivityName());
        if (diff != 0) {
            return diff;
        }
        return Double.compare(this.getPercentWorked(), that.getPercentWorked());
    }
}

