/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.graph.commands.basic;

import java.util.Collection;
import java.util.LinkedList;
import net.jcip.annotations.NotThreadSafe;
import org.jboss.dna.common.util.StringUtil;
import org.jboss.dna.graph.commands.CreateNodeCommand;
import org.jboss.dna.graph.commands.NodeConflictBehavior;
import org.jboss.dna.graph.commands.basic.BasicGraphCommand;
import org.jboss.dna.graph.properties.Path;
import org.jboss.dna.graph.properties.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public class BasicCreateNodeCommand
extends BasicGraphCommand
implements CreateNodeCommand {
    private static final long serialVersionUID = -5452285887178397354L;
    private final Path path;
    private final Collection<Property> properties;
    private final NodeConflictBehavior conflictBehavior;

    public BasicCreateNodeCommand(Path path) {
        this(path, new LinkedList<Property>(), NodeConflictBehavior.UPDATE);
    }

    public BasicCreateNodeCommand(Path path, Collection<Property> properties, NodeConflictBehavior conflictBehavior) {
        assert (path != null);
        assert (properties != null);
        assert (conflictBehavior != null);
        this.properties = properties;
        this.path = path;
        this.conflictBehavior = conflictBehavior;
    }

    @Override
    public Path getPath() {
        return this.path;
    }

    @Override
    public Collection<Property> getProperties() {
        return this.properties;
    }

    @Override
    public NodeConflictBehavior getConflictBehavior() {
        return this.conflictBehavior;
    }

    public void setProperty(Property property) {
        if (!this.properties.isEmpty()) {
            for (Property existing : this.properties) {
                if (!existing.getName().equals(property.getName())) continue;
                this.properties.remove(existing);
                break;
            }
        }
        this.properties.add(property);
    }

    public void setProperties(Property ... properties) {
        for (Property property : properties) {
            this.setProperty(property);
        }
    }

    public void setProperties(Iterable<Property> properties) {
        for (Property property : properties) {
            this.setProperty(property);
        }
    }

    @Override
    public int compareTo(CreateNodeCommand that) {
        if (this == that) {
            return 0;
        }
        return this.getPath().compareTo(that.getPath());
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof CreateNodeCommand) {
            CreateNodeCommand that = (CreateNodeCommand)obj;
            return this.path.equals(that.getPath());
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(" at ");
        sb.append(this.getPath());
        boolean firstProperty = true;
        for (Property property : this.getProperties()) {
            if (property.isEmpty()) continue;
            if (firstProperty) {
                sb.append(" { ");
                firstProperty = false;
            } else {
                sb.append("; ");
            }
            sb.append(property.getName());
            sb.append("=");
            if (property.isSingle()) {
                sb.append(StringUtil.readableString(property.getValues().next()));
                continue;
            }
            sb.append(StringUtil.readableString((Object)property.getValuesAsArray()));
        }
        if (!firstProperty) {
            sb.append(" }");
        }
        return sb.toString();
    }
}

