/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.graph.commands.basic;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.jcip.annotations.NotThreadSafe;
import org.jboss.dna.common.util.StringUtil;
import org.jboss.dna.graph.cache.CachePolicy;
import org.jboss.dna.graph.commands.GetChildrenCommand;
import org.jboss.dna.graph.commands.basic.BasicGraphCommand;
import org.jboss.dna.graph.properties.DateTime;
import org.jboss.dna.graph.properties.Path;
import org.jboss.dna.graph.properties.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public class BasicGetChildrenCommand
extends BasicGraphCommand
implements GetChildrenCommand {
    private static final long serialVersionUID = -8515194602506918337L;
    private final Map<Path.Segment, Property[]> childProperties = new HashMap<Path.Segment, Property[]>();
    private final List<Path.Segment> children = new LinkedList<Path.Segment>();
    private final Path path;
    private CachePolicy cachePolicy;
    private DateTime timeLoaded;

    public BasicGetChildrenCommand(Path path) {
        assert (path != null);
        this.path = path;
    }

    @Override
    public void setNoChildren() {
        this.children.clear();
    }

    @Override
    public void addChild(Path.Segment nameOfChild, Property ... identityProperties) {
        if (nameOfChild == null) {
            return;
        }
        this.children.add(nameOfChild);
        if (identityProperties != null) {
            if (identityProperties.length == 0) {
                identityProperties = null;
            }
            this.childProperties.put(nameOfChild, identityProperties);
        }
    }

    public Property[] getChildIdentityProperties(Path.Segment child) {
        return this.childProperties.get(child);
    }

    public List<Path.Segment> getChildren() {
        return this.children;
    }

    @Override
    public Path getPath() {
        return this.path;
    }

    @Override
    public CachePolicy getCachePolicy() {
        return this.cachePolicy;
    }

    @Override
    public DateTime getTimeLoaded() {
        return this.timeLoaded;
    }

    public void setTimeLoaded(DateTime timeLoaded) {
        this.timeLoaded = timeLoaded;
    }

    @Override
    public void setCachePolicy(CachePolicy cachePolicy) {
        this.cachePolicy = cachePolicy;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(" at ");
        sb.append(this.getPath());
        List<Path.Segment> children = this.getChildren();
        if (children != null && children.size() > 0) {
            sb.append(" with ").append(children.size()).append(" children: ");
            sb.append(StringUtil.readableString(children));
        }
        return sb.toString();
    }
}

