/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.graph.commands.executor;

import org.jboss.dna.common.util.Logger;
import org.jboss.dna.graph.GraphI18n;
import org.jboss.dna.graph.commands.CompositeCommand;
import org.jboss.dna.graph.commands.CopyBranchCommand;
import org.jboss.dna.graph.commands.CopyNodeCommand;
import org.jboss.dna.graph.commands.CreateNodeCommand;
import org.jboss.dna.graph.commands.DeleteBranchCommand;
import org.jboss.dna.graph.commands.GetChildrenCommand;
import org.jboss.dna.graph.commands.GetNodeCommand;
import org.jboss.dna.graph.commands.GetPropertiesCommand;
import org.jboss.dna.graph.commands.GraphCommand;
import org.jboss.dna.graph.commands.MoveBranchCommand;
import org.jboss.dna.graph.commands.RecordBranchCommand;
import org.jboss.dna.graph.commands.SetPropertiesCommand;
import org.jboss.dna.graph.commands.executor.CommandExecutor;
import org.jboss.dna.graph.commands.executor.DelegatingCommandExecutor;
import org.jboss.dna.graph.connectors.RepositorySourceException;

public class LoggingCommandExecutor
extends DelegatingCommandExecutor {
    private final Logger logger;
    private final Logger.Level level;

    public LoggingCommandExecutor(CommandExecutor delegate, Logger logger) {
        this(delegate, logger, Logger.Level.TRACE);
    }

    public LoggingCommandExecutor(CommandExecutor delegate, Logger logger, Logger.Level level) {
        super(delegate);
        assert (logger != null);
        this.logger = logger;
        this.level = level != null ? level : Logger.Level.TRACE;
    }

    public void close() {
        this.logger.log(this.level, GraphI18n.closingCommandExecutor, new Object[0]);
        super.close();
        this.logger.log(this.level, GraphI18n.closedCommandExecutor, new Object[0]);
    }

    public void execute(CompositeCommand command) throws RepositorySourceException {
        this.logger.log(this.level, GraphI18n.executingGraphCommand, new Object[]{command});
        super.execute(command);
        this.logger.log(this.level, GraphI18n.executedGraphCommand, new Object[]{command});
    }

    public void execute(CopyBranchCommand command) throws RepositorySourceException {
        this.logger.log(this.level, GraphI18n.executingGraphCommand, new Object[]{command});
        super.execute(command);
        this.logger.log(this.level, GraphI18n.executedGraphCommand, new Object[]{command});
    }

    public void execute(CopyNodeCommand command) throws RepositorySourceException {
        this.logger.log(this.level, GraphI18n.executingGraphCommand, new Object[]{command});
        super.execute(command);
        this.logger.log(this.level, GraphI18n.executedGraphCommand, new Object[]{command});
    }

    public void execute(CreateNodeCommand command) throws RepositorySourceException {
        this.logger.log(this.level, GraphI18n.executingGraphCommand, new Object[]{command});
        super.execute(command);
        this.logger.log(this.level, GraphI18n.executedGraphCommand, new Object[]{command});
    }

    public void execute(DeleteBranchCommand command) throws RepositorySourceException {
        this.logger.log(this.level, GraphI18n.executingGraphCommand, new Object[]{command});
        super.execute(command);
        this.logger.log(this.level, GraphI18n.executedGraphCommand, new Object[]{command});
    }

    public void execute(GetChildrenCommand command) throws RepositorySourceException {
        this.logger.log(this.level, GraphI18n.executingGraphCommand, new Object[]{command});
        super.execute(command);
        this.logger.log(this.level, GraphI18n.executedGraphCommand, new Object[]{command});
    }

    public void execute(GetNodeCommand command) throws RepositorySourceException {
        this.logger.log(this.level, GraphI18n.executingGraphCommand, new Object[]{command});
        super.execute(command);
        this.logger.log(this.level, GraphI18n.executedGraphCommand, new Object[]{command});
    }

    public void execute(GetPropertiesCommand command) throws RepositorySourceException {
        this.logger.log(this.level, GraphI18n.executingGraphCommand, new Object[]{command});
        super.execute(command);
        this.logger.log(this.level, GraphI18n.executedGraphCommand, new Object[]{command});
    }

    public void execute(GraphCommand command) throws RepositorySourceException {
        this.logger.log(this.level, GraphI18n.executingGraphCommand, new Object[]{command});
        super.execute(command);
        this.logger.log(this.level, GraphI18n.executedGraphCommand, new Object[]{command});
    }

    public void execute(MoveBranchCommand command) throws RepositorySourceException {
        this.logger.log(this.level, GraphI18n.executingGraphCommand, new Object[]{command});
        super.execute(command);
        this.logger.log(this.level, GraphI18n.executedGraphCommand, new Object[]{command});
    }

    public void execute(RecordBranchCommand command) throws RepositorySourceException {
        this.logger.log(this.level, GraphI18n.executingGraphCommand, new Object[]{command});
        super.execute(command);
        this.logger.log(this.level, GraphI18n.executedGraphCommand, new Object[]{command});
    }

    public void execute(SetPropertiesCommand command) throws RepositorySourceException {
        this.logger.log(this.level, GraphI18n.executingGraphCommand, new Object[]{command});
        super.execute(command);
        this.logger.log(this.level, GraphI18n.executedGraphCommand, new Object[]{command});
    }
}

