/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.graph.properties.basic;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URI;
import java.util.Calendar;
import java.util.Date;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.jcip.annotations.Immutable;
import org.jboss.dna.common.text.TextDecoder;
import org.jboss.dna.common.util.CheckArg;
import org.jboss.dna.graph.GraphI18n;
import org.jboss.dna.graph.properties.Binary;
import org.jboss.dna.graph.properties.DateTime;
import org.jboss.dna.graph.properties.IoException;
import org.jboss.dna.graph.properties.Name;
import org.jboss.dna.graph.properties.NameFactory;
import org.jboss.dna.graph.properties.NamespaceException;
import org.jboss.dna.graph.properties.NamespaceRegistry;
import org.jboss.dna.graph.properties.Path;
import org.jboss.dna.graph.properties.PropertyType;
import org.jboss.dna.graph.properties.Reference;
import org.jboss.dna.graph.properties.ValueFactory;
import org.jboss.dna.graph.properties.ValueFormatException;
import org.jboss.dna.graph.properties.basic.AbstractValueFactory;
import org.jboss.dna.graph.properties.basic.BasicName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class NameValueFactory
extends AbstractValueFactory<Name>
implements NameFactory {
    protected static final String FULLY_QUALFIED_NAME_PATTERN_STRING = "\\{([^}]*)\\}(.*)";
    protected static final Pattern FULLY_QUALIFIED_NAME_PATTERN = Pattern.compile("\\{([^}]*)\\}(.*)");
    private static final String PREFIXED_NAME_PATTERN_STRING = "(([^:/]*):)?(.*)";
    private static final Pattern PREFIXED_NAME_PATTERN = Pattern.compile("(([^:/]*):)?(.*)");
    private final NamespaceRegistry namespaceRegistry;

    public NameValueFactory(NamespaceRegistry namespaceRegistry, TextDecoder decoder, ValueFactory<String> stringValueFactory) {
        super(PropertyType.NAME, decoder, stringValueFactory);
        CheckArg.isNotNull((Object)namespaceRegistry, (String)"namespaceRegistry");
        this.namespaceRegistry = namespaceRegistry;
    }

    @Override
    public Name create(String value) {
        return this.create(value, this.getDecoder());
    }

    @Override
    public Name create(String value, TextDecoder decoder) {
        if (value == null) {
            return null;
        }
        if (decoder == null) {
            decoder = this.getDecoder();
        }
        try {
            Matcher matcher = FULLY_QUALIFIED_NAME_PATTERN.matcher(value);
            if (matcher.matches()) {
                String namespaceUri = matcher.group(1);
                String localName = matcher.group(2);
                namespaceUri = decoder.decode(namespaceUri);
                localName = decoder.decode(localName);
                return new BasicName(namespaceUri, localName);
            }
            matcher = PREFIXED_NAME_PATTERN.matcher(value);
            if (matcher.matches()) {
                String prefix = matcher.group(2);
                String localName = matcher.group(3);
                prefix = prefix == null ? "" : decoder.decode(prefix);
                localName = decoder.decode(localName);
                String namespaceUri = this.namespaceRegistry.getNamespaceForPrefix(prefix);
                if (namespaceUri == null) {
                    throw new NamespaceException(GraphI18n.noNamespaceRegisteredForPrefix.text(new Object[]{prefix}));
                }
                return new BasicName(namespaceUri, localName);
            }
        }
        catch (NamespaceException err) {
            throw new ValueFormatException((Object)value, this.getPropertyType(), GraphI18n.errorConvertingType.text(new Object[]{String.class.getSimpleName(), Name.class.getSimpleName(), value}), err);
        }
        throw new ValueFormatException((Object)value, this.getPropertyType(), GraphI18n.errorConvertingType.text(new Object[]{String.class.getSimpleName(), Name.class.getSimpleName(), value}));
    }

    @Override
    public Name create(String namespaceUri, String localName) {
        return this.create(namespaceUri, localName, this.getDecoder());
    }

    @Override
    public Name create(String namespaceUri, String localName, TextDecoder decoder) {
        CheckArg.isNotEmpty((String)localName, (String)"localName");
        if (decoder == null) {
            decoder = this.getDecoder();
        }
        namespaceUri = namespaceUri != null ? decoder.decode(namespaceUri.trim()) : null;
        localName = decoder.decode(localName.trim());
        return new BasicName(namespaceUri, localName);
    }

    @Override
    public Name create(int value) {
        throw new ValueFormatException((Object)value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), Integer.class.getSimpleName(), value}));
    }

    @Override
    public Name create(long value) {
        throw new ValueFormatException((Object)value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), Long.class.getSimpleName(), value}));
    }

    @Override
    public Name create(boolean value) {
        throw new ValueFormatException((Object)value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), Boolean.class.getSimpleName(), value}));
    }

    @Override
    public Name create(float value) {
        throw new ValueFormatException((Object)Float.valueOf(value), this.getPropertyType(), GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), Float.class.getSimpleName(), Float.valueOf(value)}));
    }

    @Override
    public Name create(double value) {
        throw new ValueFormatException((Object)value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), Double.class.getSimpleName(), value}));
    }

    @Override
    public Name create(BigDecimal value) {
        throw new ValueFormatException((Object)value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), BigDecimal.class.getSimpleName(), value}));
    }

    @Override
    public Name create(Calendar value) {
        throw new ValueFormatException((Object)value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), Calendar.class.getSimpleName(), value}));
    }

    @Override
    public Name create(Date value) {
        throw new ValueFormatException((Object)value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), Date.class.getSimpleName(), value}));
    }

    @Override
    public Name create(DateTime value) throws ValueFormatException {
        throw new ValueFormatException((Object)value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), DateTime.class.getSimpleName(), value}));
    }

    @Override
    public Name create(Name value) {
        return value;
    }

    @Override
    public Name create(Path value) {
        if (value == null) {
            return null;
        }
        if (!value.isAbsolute() && value.size() == 1) {
            return value.getSegment(0).getName();
        }
        throw new ValueFormatException((Object)value, this.getPropertyType(), GraphI18n.errorConvertingType.text(new Object[]{Path.class.getSimpleName(), Name.class.getSimpleName(), value}));
    }

    @Override
    public Name create(Reference value) {
        throw new ValueFormatException((Object)value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), Reference.class.getSimpleName(), value}));
    }

    @Override
    public Name create(URI value) {
        if (value == null) {
            return null;
        }
        String asciiString = value.toASCIIString();
        if (asciiString.startsWith("./") && asciiString.length() > 2) {
            asciiString = asciiString.substring(2);
        }
        if (asciiString.indexOf(47) == -1) {
            return this.create(asciiString);
        }
        throw new ValueFormatException((Object)value, this.getPropertyType(), GraphI18n.errorConvertingType.text(new Object[]{URI.class.getSimpleName(), Path.class.getSimpleName(), value}));
    }

    @Override
    public Name create(UUID value) throws IoException {
        throw new ValueFormatException((Object)value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), UUID.class.getSimpleName(), value}));
    }

    @Override
    public Name create(byte[] value) {
        return this.create(this.getStringValueFactory().create(value));
    }

    @Override
    public Name create(Binary value) throws ValueFormatException, IoException {
        return this.create(this.getStringValueFactory().create(value));
    }

    @Override
    public Name create(InputStream stream, long approximateLength) throws IoException {
        return this.create(this.getStringValueFactory().create(stream, approximateLength));
    }

    @Override
    public Name create(Reader reader, long approximateLength) throws IoException {
        return this.create(this.getStringValueFactory().create(reader, approximateLength));
    }

    @Override
    public NamespaceRegistry getNamespaceRegistry() {
        return this.namespaceRegistry;
    }

    protected Name[] createEmptyArray(int length) {
        return new Name[length];
    }
}

