package org.jboss.hal.dmr.macro;

import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.web.bindery.event.shared.HandlerRegistration;

import com.google.gwt.event.shared.HasHandlers;

public class MacroFinishedEvent extends GwtEvent<MacroFinishedEvent.MacroFinishedHandler> { 

  org.jboss.hal.dmr.macro.Macro macro;
  org.jboss.hal.dmr.macro.MacroOptions options;

  protected MacroFinishedEvent() {
    // Possibly for serialization.
  }

  public MacroFinishedEvent(org.jboss.hal.dmr.macro.Macro macro, org.jboss.hal.dmr.macro.MacroOptions options) {
    this.macro = macro;
    this.options = options;
  }

  public static void fire(HasHandlers source, org.jboss.hal.dmr.macro.Macro macro, org.jboss.hal.dmr.macro.MacroOptions options) {
    MacroFinishedEvent eventInstance = new MacroFinishedEvent(macro, options);
    source.fireEvent(eventInstance);
  }

  public static void fire(HasHandlers source, MacroFinishedEvent eventInstance) {
    source.fireEvent(eventInstance);
  }

  public interface HasMacroFinishedHandlers extends HasHandlers {
    HandlerRegistration addMacroFinishedHandler(MacroFinishedHandler handler);
  }

  public interface MacroFinishedHandler extends EventHandler {
    public void onMacroFinished(MacroFinishedEvent event);
  }

  private static final Type<MacroFinishedHandler> TYPE = new Type<MacroFinishedHandler>();

  public static Type<MacroFinishedHandler> getType() {
    return TYPE;
  }

  @Override
  public Type<MacroFinishedHandler> getAssociatedType() {
    return TYPE;
  }

  @Override
  protected void dispatch(MacroFinishedHandler handler) {
    handler.onMacroFinished(this);
  }

  public org.jboss.hal.dmr.macro.Macro getMacro(){
    return macro;
  }

  public org.jboss.hal.dmr.macro.MacroOptions getOptions(){
    return options;
  }

  @Override
  public boolean equals(Object obj) {
    if (this == obj)
        return true;
    if (obj == null)
        return false;
    if (getClass() != obj.getClass())
        return false;
    MacroFinishedEvent other = (MacroFinishedEvent) obj;
    if (macro == null) {
      if (other.macro != null)
        return false;
    } else if (!macro.equals(other.macro))
      return false;
    if (options == null) {
      if (other.options != null)
        return false;
    } else if (!options.equals(other.options))
      return false;
    return true;
  }

  @Override
  public int hashCode() {
    int hashCode = 23;
    hashCode = (hashCode * 37) + (macro == null ? 1 : macro.hashCode());
    hashCode = (hashCode * 37) + (options == null ? 1 : options.hashCode());
    return hashCode;
  }

  @Override
  public String toString() {
    return "MacroFinishedEvent["
                 + macro
                 + ","
                 + options
    + "]";
  }
}
