/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pull.shared.connectors;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.egit.github.core.Comment;
import org.eclipse.egit.github.core.Issue;
import org.eclipse.egit.github.core.Milestone;
import org.eclipse.egit.github.core.PullRequest;
import org.eclipse.egit.github.core.User;
import org.jboss.pull.shared.BuildResult;
import org.jboss.pull.shared.PullHelper;
import org.jboss.pull.shared.connectors.bugzilla.BZHelper;
import org.jboss.pull.shared.connectors.bugzilla.Bug;
import org.jboss.pull.shared.connectors.github.GithubHelper;
import org.jboss.pull.shared.connectors.jira.JiraHelper;
import org.jboss.pull.shared.connectors.jira.JiraIssue;

public class RedhatPullRequest {
    private static final Pattern UPSTREAM_NOT_REQUIRED = Pattern.compile(".*no.*upstream.*required.*", 2);
    private static final Pattern BUGZILLA_ID_PATTERN = Pattern.compile("bugzilla\\.redhat\\.com/show_bug\\.cgi\\?id=(\\d+)", 2);
    private static final Pattern RELATED_JIRA_PATTERN = Pattern.compile(".*issues\\.jboss\\.org/browse/([a-zA-Z_0-9-]*)", 2);
    private static final Pattern RELATED_PR_PATTERN = Pattern.compile(".*github\\.com.*?/([a-zA-Z_0-9-]*)/([a-zA-Z_0-9-]*)/pull.?/(\\d+)", 2);
    private PullRequest pullRequest;
    private List<Bug> bugs = new ArrayList<Bug>();
    private List<RedhatPullRequest> relatedPullRequests = null;
    private BZHelper bzHelper;
    private GithubHelper ghHelper;
    private JiraHelper jiraHelper;

    public RedhatPullRequest(PullRequest pullRequest, BZHelper bzHelper, GithubHelper ghHelper) {
        this.pullRequest = pullRequest;
        this.bzHelper = bzHelper;
        this.ghHelper = ghHelper;
        this.bugs = this.getBugsFromDescription(pullRequest);
    }

    private List<JiraIssue> getJIRAFromDescription(PullRequest pull) {
        List<String> ids = this.extractJiraIds(pull.getBody());
        ArrayList<JiraIssue> issues = new ArrayList<JiraIssue>();
        for (String id : ids) {
            JiraIssue bug = this.jiraHelper.getJIRA();
            if (bug == null) continue;
            issues.add(bug);
        }
        return issues;
    }

    private List<String> extractJiraIds(String body) {
        ArrayList<String> ids = new ArrayList<String>();
        Matcher matcher = RELATED_JIRA_PATTERN.matcher(body);
        while (matcher.find()) {
            try {
                ids.add(matcher.group(1));
            }
            catch (NumberFormatException ignore) {
                System.err.printf("Invalid bug number: %s.\n", ignore);
            }
        }
        return ids;
    }

    private List<Bug> getBugsFromDescription(PullRequest pull) {
        List<Integer> ids = this.extractBugzillaIds(pull.getBody());
        ArrayList<Bug> bugs = new ArrayList<Bug>();
        for (Integer id : ids) {
            Bug bug = this.bzHelper.getBug(id);
            if (bug == null) continue;
            bugs.add(bug);
        }
        return bugs;
    }

    private List<Integer> extractBugzillaIds(String body) {
        ArrayList<Integer> ids = new ArrayList<Integer>();
        Matcher matcher = BUGZILLA_ID_PATTERN.matcher(body);
        while (matcher.find()) {
            try {
                ids.add(Integer.valueOf(matcher.group(1)));
            }
            catch (NumberFormatException ignore) {
                System.err.printf("Invalid bug number: %s.\n", ignore);
            }
        }
        return ids;
    }

    public int getNumber() {
        return this.pullRequest.getNumber();
    }

    public void postGithubComment(String comment) {
        this.ghHelper.postGithubComment(this.pullRequest, comment);
    }

    public Milestone getMilestone() {
        return this.pullRequest.getMilestone();
    }

    public void setMilestone(Milestone milestone) {
        Issue issue = this.ghHelper.getIssue(this.pullRequest);
        issue.setMilestone(milestone);
        this.ghHelper.editIssue(issue);
    }

    public String getTargetBranchTitle() {
        return this.pullRequest.getBase().getRef();
    }

    public String getSourceBranchSha() {
        return this.pullRequest.getHead().getSha();
    }

    public User getGithubUser() {
        return this.pullRequest.getUser();
    }

    public List<Comment> getGithubComments() {
        return this.ghHelper.getComments(this.pullRequest);
    }

    public void postGithubStatus(String targetUrl, String status) {
        this.ghHelper.postGithubStatus(this.pullRequest, targetUrl, status);
    }

    public String getGithubDescription() {
        return this.pullRequest.getBody();
    }

    public Date getGithubUpdatedAt() {
        return this.pullRequest.getUpdatedAt();
    }

    public Comment getLastMatchingGithubComment(Pattern pattern) {
        return this.ghHelper.getLastMatchingComment(this.pullRequest, pattern);
    }

    public List<RedhatPullRequest> getRelatedPullRequests() {
        if (this.relatedPullRequests != null) {
            return this.relatedPullRequests;
        }
        this.relatedPullRequests = this.getPRFromDescription();
        return this.relatedPullRequests;
    }

    private List<RedhatPullRequest> getPRFromDescription() {
        Matcher matcher = RELATED_PR_PATTERN.matcher(this.getGithubDescription());
        ArrayList<RedhatPullRequest> relatedPullRequests = new ArrayList<RedhatPullRequest>();
        while (matcher.find()) {
            PullRequest relatedPullRequest = this.ghHelper.getPullRequest(matcher.group(1), matcher.group(2), Integer.valueOf(matcher.group(3)));
            if (relatedPullRequest == null) continue;
            relatedPullRequests.add(new RedhatPullRequest(relatedPullRequest, this.bzHelper, this.ghHelper));
        }
        return relatedPullRequests;
    }

    public String getState() {
        return this.pullRequest.getState();
    }

    public String getHtmlUrl() {
        return this.pullRequest.getHtmlUrl();
    }

    public boolean isMerged() {
        return this.ghHelper.isMerged(this.pullRequest);
    }

    public List<Bug> getBugs() {
        return this.bugs;
    }

    public boolean isJiraInDescription() {
        return this.extractJiraIds(this.pullRequest.getBody()).isEmpty();
    }

    public boolean isUpstreamRequired() {
        return !UPSTREAM_NOT_REQUIRED.matcher(this.pullRequest.getBody()).find();
    }

    public BuildResult getBuildResult() {
        BuildResult buildResult = BuildResult.UNKNOWN;
        Comment comment = this.ghHelper.getLastMatchingComment(this.pullRequest, PullHelper.BUILD_OUTCOME);
        if (comment != null) {
            Matcher matcher = PullHelper.BUILD_OUTCOME.matcher(comment.getBody());
            while (matcher.find()) {
                buildResult = BuildResult.valueOf(matcher.group(2));
            }
        }
        return buildResult;
    }

    public String getOrganization() {
        Matcher matcher = RELATED_PR_PATTERN.matcher(this.pullRequest.getUrl());
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return null;
    }

    public String getRepository() {
        Matcher matcher = RELATED_PR_PATTERN.matcher(this.pullRequest.getUrl());
        if (matcher.matches()) {
            return matcher.group(2);
        }
        return null;
    }

    public boolean updateBugzillaStatus(Bug bug, Bug.Status status) {
        return this.bzHelper.updateBugzillaStatus(bug.getId(), status);
    }
}

