/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pull.shared.connectors.bugzilla;

import java.util.Properties;
import org.jboss.pull.shared.Util;
import org.jboss.pull.shared.connectors.bugzilla.Bug;
import org.jboss.pull.shared.connectors.bugzilla.Bugzilla;

public class BZHelper {
    private static final String BUGZILLA_BASE = "https://bugzilla.redhat.com/";
    private final String BUGZILLA_LOGIN;
    private final String BUGZILLA_PASSWORD;
    private final Bugzilla bugzillaClient;

    public BZHelper(String configurationFileProperty, String configurationFileDefault) throws Exception {
        try {
            Properties props = Util.loadProperties(configurationFileProperty, configurationFileDefault);
            this.BUGZILLA_LOGIN = Util.require(props, "bugzilla.login");
            this.BUGZILLA_PASSWORD = Util.require(props, "bugzilla.password");
            this.bugzillaClient = new Bugzilla(BUGZILLA_BASE, this.BUGZILLA_LOGIN, this.BUGZILLA_PASSWORD);
        }
        catch (Exception e) {
            System.err.printf("Cannot initialize: %s\n", e);
            e.printStackTrace(System.err);
            throw e;
        }
    }

    public Bug getBug(Integer bugzillaId) {
        return this.bugzillaClient.getBug(bugzillaId);
    }

    public boolean updateBugzillaStatus(Integer bugzillaId, Bug.Status status) {
        return this.bugzillaClient.updateBugzillaStatus(bugzillaId, status);
    }
}

