/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pull.shared.evaluators;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.eclipse.egit.github.core.Comment;
import org.eclipse.egit.github.core.PullRequest;
import org.jboss.pull.shared.PullHelper;
import org.jboss.pull.shared.Util;
import org.jboss.pull.shared.connectors.RedhatPullRequest;
import org.jboss.pull.shared.connectors.bugzilla.Bug;
import org.jboss.pull.shared.connectors.common.Issue;
import org.jboss.pull.shared.connectors.jira.JiraIssue;
import org.jboss.pull.shared.spi.PullEvaluator;

public abstract class BasePullEvaluator
implements PullEvaluator {
    public static final String EVALUATOR_PROPERTY = "evaluator";
    public static final String GITHUB_BRANCH_PROPERTY = "github.branch";
    public static final String GITHUB_ORGANIZAITON_UPSTREAM = "github.organization.upstream";
    public static final String GITHUB_REPOSITORY_UPSTREAM = "github.repo.upstream";
    public static final String GITHUB_BRANCH_UPSTREAM = "github.branch.upstream";
    public static final String ISSUE_FIX_VERSION = "issue.fix.version";
    private static final String NOT_REVIEWED_TAG = "Pull request has not been reviewed yet";
    protected PullHelper helper;
    protected String issueFixVersion;
    protected String githubBranch;
    protected String upstreamOrganization;
    protected String upstreamRepository;
    protected String upstreamBranch;

    @Override
    public void init(PullHelper helper, Properties configuration, String version) {
        this.helper = helper;
        this.issueFixVersion = Util.require(configuration, version + "." + ISSUE_FIX_VERSION);
        this.githubBranch = Util.require(configuration, version + "." + GITHUB_BRANCH_PROPERTY);
        this.upstreamOrganization = Util.require(configuration, version + "." + GITHUB_ORGANIZAITON_UPSTREAM);
        this.upstreamRepository = Util.require(configuration, version + "." + GITHUB_REPOSITORY_UPSTREAM);
        this.upstreamBranch = Util.require(configuration, version + "." + GITHUB_BRANCH_UPSTREAM);
    }

    @Override
    public String getTargetBranch() {
        return this.githubBranch;
    }

    @Override
    public PullEvaluator.Result isMergeable(RedhatPullRequest pull) {
        PullEvaluator.Result mergeable = this.isMarkedForMerge(pull);
        mergeable.and(this.isMergeableByUpstream(pull));
        return mergeable;
    }

    private PullEvaluator.Result isMarkedForMerge(RedhatPullRequest pullRequest) {
        PullEvaluator.Result result = new PullEvaluator.Result(false);
        Comment comment = pullRequest.getLastMatchingGithubComment(PullHelper.MERGE);
        if (comment != null) {
            System.out.printf("issue #%d updated at: %s\n", pullRequest.getNumber(), Util.getTime(pullRequest.getGithubUpdatedAt()));
            System.out.printf("issue #%d reviewed at: %s\n", pullRequest.getNumber(), Util.getTime(comment.getCreatedAt()));
            if (pullRequest.getGithubUpdatedAt().compareTo(comment.getCreatedAt()) <= 0 && this.helper.isAdminUser(comment.getUser().getLogin())) {
                result.setMergeable(true);
                result.addDescription("+ Pull request has been reviewed");
            }
        }
        if (!result.isMergeable()) {
            result.addDescription("- Pull request has not been reviewed yet");
        }
        return result;
    }

    @Override
    public boolean updateIssueAsMerged(RedhatPullRequest pull) {
        List<? extends Issue> issues = this.getIssue(pull);
        if (issues.isEmpty() || issues.size() > 1) {
            System.err.printf("WARNING: Couldn't update the relevant issue as merged since there are more than one or none such issue(-s) related to PR#%d.\n", pull.getNumber());
            System.err.println("WARNING: related issues:");
            for (Issue issue : issues) {
                System.err.printf("WARNING: Type: %s, Number: %s, Url: %s\n", issue.getClass().getSimpleName(), issue.getNumber(), issue.getUrl());
            }
            return false;
        }
        Issue issue = issues.get(0);
        if (issue instanceof Bug) {
            return pull.updateBugzillaStatus((Bug)issue, Bug.Status.MODIFIED);
        }
        if (issue instanceof JiraIssue) {
            return this.updateJiraAsMerged((JiraIssue)issue);
        }
        throw new IllegalStateException("unsupported type of an issue: " + issue.getClass().getName());
    }

    @Override
    public List<? extends Issue> getIssue(RedhatPullRequest pull) {
        return this.getBugsThatMatchFixVersion(pull);
    }

    @Override
    public List<RedhatPullRequest> getUpstreamPullRequest(RedhatPullRequest pullRequest) {
        ArrayList<RedhatPullRequest> upstreamPulls = new ArrayList<RedhatPullRequest>();
        List<RedhatPullRequest> relatedPullRequests = pullRequest.getRelatedPullRequests();
        for (RedhatPullRequest relatedPullRequest : relatedPullRequests) {
            if (!this.upstreamOrganization.equals(relatedPullRequest.getOrganization()) || !this.upstreamRepository.equals(relatedPullRequest.getRepository()) || !this.upstreamBranch.equals(relatedPullRequest.getTargetBranchTitle())) continue;
            upstreamPulls.add(relatedPullRequest);
        }
        return upstreamPulls;
    }

    protected PullEvaluator.Result isMergeableByUpstream(RedhatPullRequest pull) {
        PullEvaluator.Result mergeable = new PullEvaluator.Result(true);
        try {
            List<RedhatPullRequest> upstreamPulls = this.getUpstreamPullRequest(pull);
            if (upstreamPulls.isEmpty()) {
                mergeable.setMergeable(false);
                mergeable.addDescription("- Missing any upstream pull request");
                return mergeable;
            }
            for (RedhatPullRequest pullRequest : upstreamPulls) {
                if (pullRequest.isMerged()) continue;
                mergeable.setMergeable(false);
                mergeable.addDescription("- Upstream pull request #" + pullRequest.getNumber() + " has not been merged yet");
            }
            if (mergeable.isMergeable()) {
                mergeable.addDescription("+ Upstream pull request is OK");
            }
        }
        catch (Exception ignore) {
            System.err.printf("Cannot get an upstream pull request of the pull request %d: %s.\n", pull.getNumber(), ignore);
            ignore.printStackTrace(System.err);
            mergeable.setMergeable(false);
            mergeable.addDescription("Cannot get an upstream pull request of the pull request " + pull.getNumber() + ": " + ignore.getMessage());
        }
        return mergeable;
    }

    protected List<Bug> getBugsThatMatchFixVersion(RedhatPullRequest pullRequest) {
        List<Bug> bugs = pullRequest.getBugs();
        ArrayList<Bug> returnBugs = new ArrayList<Bug>();
        block0: for (Bug bug : bugs) {
            for (String target : bug.getTargetRelease()) {
                if (!target.equals(this.issueFixVersion)) continue;
                returnBugs.add(bug);
                continue block0;
            }
        }
        return returnBugs;
    }

    private boolean updateJiraAsMerged(JiraIssue issue) {
        throw new IllegalStateException("jira has not been implemented yet");
    }

    protected List<JiraIssue> getJiraIssue(PullRequest pull) {
        throw new IllegalStateException("jira has not been implemented yet");
    }
}

