/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.job.executor;

import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmConfiguration;
import org.jbpm.JbpmContext;
import org.jbpm.db.JobSession;
import org.jbpm.job.Job;

public class LockMonitorThread
extends Thread {
    JbpmConfiguration jbpmConfiguration;
    int lockMonitorInterval;
    int maxLockTime;
    int lockBufferTime;
    boolean isActive = true;
    private static Log log = LogFactory.getLog((Class)LockMonitorThread.class);

    public LockMonitorThread(JbpmConfiguration jbpmConfiguration, int lockMonitorInterval, int maxLockTime, int lockBufferTime) {
        this.jbpmConfiguration = jbpmConfiguration;
        this.lockMonitorInterval = lockMonitorInterval;
        this.maxLockTime = maxLockTime;
        this.lockBufferTime = lockBufferTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            while (this.isActive) {
                try {
                    this.unlockOverdueJobs();
                    if (!this.isActive || this.lockMonitorInterval <= 0) continue;
                    LockMonitorThread.sleep(this.lockMonitorInterval);
                }
                catch (InterruptedException e) {
                    log.info((Object)("lock monitor thread '" + this.getName() + "' got interrupted"));
                }
                catch (Exception e) {
                    log.error((Object)("exception in lock monitor thread. waiting " + this.lockMonitorInterval + " milliseconds"), (Throwable)e);
                    try {
                        LockMonitorThread.sleep(this.lockMonitorInterval);
                    }
                    catch (InterruptedException e2) {
                        log.debug((Object)"delay after exception got interrupted", (Throwable)e2);
                    }
                }
            }
            return;
        }
        catch (Exception e) {
            log.error((Object)"exception in lock monitor thread", (Throwable)e);
            return;
        }
        finally {
            log.info((Object)(this.getName() + " leaves cyberspace"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unlockOverdueJobs() {
        JbpmContext jbpmContext = this.jbpmConfiguration.createJbpmContext();
        try {
            JobSession jobSession = jbpmContext.getJobSession();
            Date treshold = new Date(System.currentTimeMillis() - (long)this.maxLockTime - (long)this.lockBufferTime);
            List jobsWithOverdueLockTime = jobSession.findJobsWithOverdueLockTime(treshold);
            Iterator iter = jobsWithOverdueLockTime.iterator();
            while (iter.hasNext()) {
                Job job = (Job)iter.next();
                log.debug((Object)("unlocking " + job + " owned by thread " + job.getLockOwner()));
                job.setLockOwner(null);
                job.setLockTime(null);
                jobSession.saveJob(job);
            }
        }
        finally {
            try {
                jbpmContext.close();
            }
            catch (RuntimeException e) {
                log.error((Object)"problem committing job execution transaction", (Throwable)e);
                throw e;
            }
        }
    }

    public void setActive(boolean isActive) {
        this.isActive = isActive;
    }
}

