/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.internal.log;

import org.jbpm.internal.log.Jdk14LogFactory;
import org.jbpm.internal.log.Log4jLogFactory;
import org.jbpm.internal.log.LogFactory;

public abstract class Log {
    static LogFactory logFactory;

    public static synchronized Log getLog(String name) {
        if (logFactory == null) {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            logFactory = classLoader.getResource("logging.properties") != null ? new Jdk14LogFactory() : (Log.isLog4jAvailable(classLoader) ? new Log4jLogFactory() : new Jdk14LogFactory());
        }
        return logFactory.getLog(name);
    }

    static boolean isLog4jAvailable(ClassLoader classLoader) {
        try {
            Class.forName("org.apache.log4j.LogManager", false, classLoader);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public abstract void error(String var1);

    public abstract void error(String var1, Throwable var2);

    public abstract boolean isInfoEnabled();

    public abstract void info(String var1);

    public abstract void info(String var1, Throwable var2);

    public abstract boolean isDebugEnabled();

    public abstract void debug(String var1);

    public abstract void debug(String var1, Throwable var2);

    public abstract boolean isTraceEnabled();

    public abstract void trace(String var1);

    public abstract void trace(String var1, Throwable var2);
}

