/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.dnssec.validator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.jitsi.dnssec.SecurityStatus;
import org.xbill.DNS.DNSKEYRecord;
import org.xbill.DNS.DNSSEC;
import org.xbill.DNS.RRSIGRecord;
import org.xbill.DNS.RRset;

public class DnsSecVerifier {
    private static final Logger logger = Logger.getLogger(DnsSecVerifier.class);

    private List<DNSKEYRecord> findKey(RRset dnskeyRrset, RRSIGRecord signature) {
        if (!signature.getSigner().equals((Object)dnskeyRrset.getName())) {
            logger.trace((Object)("findKey: could not find appropriate key because incorrect keyset was supplied. Wanted: " + signature.getSigner() + ", got: " + dnskeyRrset.getName()));
            return null;
        }
        int keyid = signature.getFootprint();
        int alg = signature.getAlgorithm();
        ArrayList<DNSKEYRecord> res = new ArrayList<DNSKEYRecord>(dnskeyRrset.size());
        Iterator i = dnskeyRrset.rrs();
        while (i.hasNext()) {
            DNSKEYRecord r = (DNSKEYRecord)i.next();
            if (r.getAlgorithm() != alg || r.getFootprint() != keyid) continue;
            res.add(r);
        }
        if (res.size() == 0) {
            logger.trace((Object)"findKey: could not find a key matching the algorithm and footprint in supplied keyset. ");
            return null;
        }
        return res;
    }

    private SecurityStatus verifySignature(RRset rrset, RRSIGRecord sigrec, RRset keyRrset) {
        List<DNSKEYRecord> keys = this.findKey(keyRrset, sigrec);
        if (keys == null) {
            logger.trace((Object)"could not find appropriate key");
            return SecurityStatus.BOGUS;
        }
        SecurityStatus status = SecurityStatus.UNCHECKED;
        for (DNSKEYRecord key : keys) {
            try {
                if (!rrset.getName().subdomain(keyRrset.getName())) {
                    logger.debug((Object)"signer name is off-tree");
                    status = SecurityStatus.BOGUS;
                    continue;
                }
                DNSSEC.verify((RRset)rrset, (RRSIGRecord)sigrec, (DNSKEYRecord)key);
                return SecurityStatus.SECURE;
            }
            catch (DNSSEC.DNSSECException e) {
                logger.error((Object)"Failed to validate RRset", (Throwable)e);
                status = SecurityStatus.BOGUS;
            }
        }
        return status;
    }

    public SecurityStatus verify(RRset rrset, RRset keyRrset) {
        Iterator i = rrset.sigs();
        if (!i.hasNext()) {
            logger.info((Object)"RRset failed to verify due to lack of signatures");
            return SecurityStatus.BOGUS;
        }
        while (i.hasNext()) {
            RRSIGRecord sigrec = (RRSIGRecord)i.next();
            SecurityStatus res = this.verifySignature(rrset, sigrec, keyRrset);
            if (res != SecurityStatus.SECURE) continue;
            return res;
        }
        logger.info((Object)"RRset failed to verify: all signatures were BOGUS");
        return SecurityStatus.BOGUS;
    }

    public SecurityStatus verify(RRset rrset, DNSKEYRecord dnskey) {
        Iterator i = rrset.sigs();
        if (!i.hasNext()) {
            logger.info((Object)"RRset failed to verify due to lack of signatures");
            return SecurityStatus.BOGUS;
        }
        while (i.hasNext()) {
            RRSIGRecord sigrec = (RRSIGRecord)i.next();
            if (sigrec.getFootprint() != dnskey.getFootprint()) continue;
            try {
                DNSSEC.verify((RRset)rrset, (RRSIGRecord)sigrec, (DNSKEYRecord)dnskey);
                return SecurityStatus.SECURE;
            }
            catch (DNSSEC.DNSSECException e) {
                logger.error((Object)"Failed to validate RRset", (Throwable)e);
            }
        }
        logger.info((Object)"RRset failed to verify: all signatures were BOGUS");
        return SecurityStatus.BOGUS;
    }
}

