/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.dnssec.validator;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.jitsi.dnssec.R;
import org.jitsi.dnssec.SMessage;
import org.jitsi.dnssec.SRRset;
import org.jitsi.dnssec.SecurityStatus;
import org.jitsi.dnssec.validator.FindKeyState;
import org.jitsi.dnssec.validator.JustifiedSecStatus;
import org.jitsi.dnssec.validator.KeyCache;
import org.jitsi.dnssec.validator.KeyEntry;
import org.jitsi.dnssec.validator.NSEC3ValUtils;
import org.jitsi.dnssec.validator.ResponseClassification;
import org.jitsi.dnssec.validator.TrustAnchorStore;
import org.jitsi.dnssec.validator.ValUtils;
import org.xbill.DNS.CNAMERecord;
import org.xbill.DNS.DClass;
import org.xbill.DNS.DNAMERecord;
import org.xbill.DNS.Header;
import org.xbill.DNS.Master;
import org.xbill.DNS.Message;
import org.xbill.DNS.NSECRecord;
import org.xbill.DNS.Name;
import org.xbill.DNS.NameTooLongException;
import org.xbill.DNS.Record;
import org.xbill.DNS.Resolver;
import org.xbill.DNS.ResolverListener;
import org.xbill.DNS.TSIG;
import org.xbill.DNS.TXTRecord;
import org.xbill.DNS.Type;

public class ValidatingResolver
implements Resolver {
    public static final int VALIDATION_REASON_QCLASS = 65280;
    private static final Logger logger = Logger.getLogger(ValidatingResolver.class);
    private static final long DEFAULT_TA_BAD_KEY_TTL = 60L;
    private KeyCache keyCache;
    private TrustAnchorStore trustAnchors;
    private ValUtils valUtils;
    private NSEC3ValUtils n3valUtils;
    private Resolver headResolver;

    public ValidatingResolver(Resolver headResolver) {
        this.headResolver = headResolver;
        headResolver.setEDNS(0, 0, 32768, null);
        headResolver.setIgnoreTruncation(false);
        this.keyCache = new KeyCache();
        this.valUtils = new ValUtils();
        this.n3valUtils = new NSEC3ValUtils();
        this.trustAnchors = new TrustAnchorStore();
    }

    public void init(Properties config) throws IOException {
        this.keyCache.init(config);
        this.n3valUtils.init(config);
        this.valUtils.init(config);
        String s = config.getProperty("org.jitsi.dnssec.trust_anchor_file");
        if (s != null) {
            logger.debug((Object)("reading trust anchor file file: " + s));
            this.loadTrustAnchors(new FileInputStream(s));
        }
    }

    public void loadTrustAnchors(InputStream data) throws IOException {
        Record mr;
        Master master = new Master(data, Name.root, 0L);
        ArrayList<Record> records = new ArrayList<Record>();
        while ((mr = master.nextRecord()) != null) {
            records.add(mr);
        }
        Collections.sort(records);
        SRRset currentRrset = new SRRset();
        for (Record r : records) {
            if (r.getType() != 48 && r.getType() != 43) continue;
            if (currentRrset.size() == 0) {
                currentRrset.addRR(r);
                continue;
            }
            if (currentRrset.getName().equals((Object)r.getName()) && currentRrset.getType() == r.getType() && currentRrset.getDClass() == r.getDClass()) {
                currentRrset.addRR(r);
                continue;
            }
            this.trustAnchors.store(currentRrset);
            currentRrset = new SRRset();
            currentRrset.addRR(r);
        }
        if (currentRrset.size() > 0) {
            this.trustAnchors.store(currentRrset);
        }
    }

    public TrustAnchorStore getTrustAnchors() {
        return this.trustAnchors;
    }

    private void validatePositiveResponse(Message request, SMessage response) {
        int qtype = request.getQuestion().getType();
        HashMap<Name, Name> wcs = new HashMap<Name, Name>(1);
        ArrayList<SRRset> nsec3s = new ArrayList<SRRset>(0);
        ArrayList<SRRset> nsecs = new ArrayList<SRRset>(0);
        if (!this.validateAnswerAndGetWildcards(response, qtype, wcs)) {
            return;
        }
        int[] sections = request.getQuestion().getType() == 255 ? new int[]{1, 2} : new int[]{2};
        for (int section : sections) {
            for (SRRset set : response.getSectionRRsets(section)) {
                KeyEntry ke = this.prepareFindKey(set);
                if (!this.processKeyValidate(response, set.getSignerName(), ke)) {
                    return;
                }
                SRRset keyRrset = ke.getRRset();
                SecurityStatus status = this.valUtils.verifySRRset(set, keyRrset);
                if (status != SecurityStatus.SECURE) {
                    response.setBogus(R.get("failed.authority.positive", new Object[]{set}));
                    return;
                }
                if (wcs.size() <= 0) continue;
                if (set.getType() == 47) {
                    nsecs.add(set);
                    continue;
                }
                if (set.getType() != 50) continue;
                nsec3s.add(set);
            }
        }
        if (wcs.size() > 0) {
            Object object = wcs.entrySet().iterator();
            while (object.hasNext()) {
                Map.Entry wc = (Map.Entry)object.next();
                boolean wcNsecOk = false;
                for (SRRset set : nsecs) {
                    NSECRecord nsec = (NSECRecord)set.first();
                    if (!ValUtils.nsecProvesNameError(nsec, (Name)wc.getKey(), set.getSignerName())) continue;
                    try {
                        Name nsecWc = ValUtils.nsecWildcard((Name)wc.getKey(), nsec);
                        if (!((Name)wc.getValue()).equals((Object)nsecWc)) continue;
                        wcNsecOk = true;
                        break;
                    }
                    catch (NameTooLongException e) {
                        throw new RuntimeException(R.get("failed.positive.wildcardgeneration", new Object[0]));
                    }
                }
                if (!wcNsecOk && nsec3s.size() > 0) {
                    if (this.n3valUtils.allNSEC3sIgnoreable(nsec3s, this.keyCache)) {
                        response.setStatus(SecurityStatus.INSECURE, R.get("failed.nsec3_ignored", new Object[0]));
                        return;
                    }
                    SecurityStatus status = this.n3valUtils.proveWildcard(nsec3s, (Name)wc.getKey(), ((SRRset)((Object)nsec3s.get(0))).getSignerName(), (Name)wc.getValue());
                    if (status == SecurityStatus.INSECURE) {
                        response.setStatus(status);
                        return;
                    }
                    if (status == SecurityStatus.SECURE) {
                        wcNsecOk = true;
                    }
                }
                if (wcNsecOk) continue;
                response.setBogus(R.get("failed.positive.wildcard_too_broad", new Object[0]));
                return;
            }
        }
        response.setStatus(SecurityStatus.SECURE);
    }

    private boolean validateAnswerAndGetWildcards(SMessage response, int qtype, Map<Name, Name> wcs) {
        DNAMERecord dname = null;
        for (SRRset set : response.getSectionRRsets(1)) {
            if (set.getType() == 5 && dname != null) {
                if (set.size() > 1) {
                    response.setBogus(R.get("failed.synthesize.multiple", new Object[0]));
                    return false;
                }
                CNAMERecord cname = (CNAMERecord)set.first();
                try {
                    Name expected = Name.concatenate((Name)cname.getName().relativize(dname.getName()), (Name)dname.getTarget());
                    if (!expected.equals((Object)cname.getTarget())) {
                        response.setBogus(R.get("failed.synthesize.nomatch", cname.getTarget(), expected));
                        return false;
                    }
                }
                catch (NameTooLongException e) {
                    response.setBogus(R.get("failed.synthesize.toolong", new Object[0]));
                    return false;
                }
                set.setSecurityStatus(SecurityStatus.SECURE);
                dname = null;
                continue;
            }
            KeyEntry ke = this.prepareFindKey(set);
            if (!this.processKeyValidate(response, set.getSignerName(), ke)) {
                return false;
            }
            SecurityStatus status = this.valUtils.verifySRRset(set, ke.getRRset());
            if (status != SecurityStatus.SECURE) {
                response.setBogus(R.get("failed.answer.positive", new Object[]{set}));
                return false;
            }
            Name wc = null;
            try {
                wc = ValUtils.rrsetWildcard(set);
            }
            catch (RuntimeException ex) {
                response.setBogus(R.get(ex.getMessage(), set.getName()));
                return false;
            }
            if (wc != null) {
                if (set.getType() == 39) {
                    response.setBogus(R.get("failed.dname.wildcard", set.getName()));
                    return false;
                }
                wcs.put(set.getName(), wc);
            }
            if (qtype == 39 || set.getType() != 39) continue;
            dname = (DNAMERecord)set.first();
        }
        return true;
    }

    private void validateNodataResponse(Message request, SMessage response) {
        Name qname = request.getQuestion().getName();
        int qtype = request.getQuestion().getType();
        for (SRRset set : response.getSectionRRsets(1)) {
            if (set.getSecurityStatus() != SecurityStatus.SECURE) {
                response.setBogus(R.get("failed.answer.cname_nodata", set.getName()));
                return;
            }
            if (set.getType() != 5) continue;
            qname = ((CNAMERecord)set.first()).getTarget();
        }
        boolean hasValidNSEC = false;
        Name ce = null;
        ValUtils.NsecProvesNodataResponse ndp = new ValUtils.NsecProvesNodataResponse();
        ArrayList<SRRset> nsec3s = new ArrayList<SRRset>(0);
        Name nsec3Signer = null;
        for (SRRset set : response.getSectionRRsets(2)) {
            KeyEntry ke = this.prepareFindKey(set);
            if (!this.processKeyValidate(response, set.getSignerName(), ke)) {
                return;
            }
            SecurityStatus status = this.valUtils.verifySRRset(set, ke.getRRset());
            if (status != SecurityStatus.SECURE) {
                response.setBogus(R.get("failed.authority.nodata", new Object[]{set}));
                return;
            }
            if (set.getType() == 47) {
                NSECRecord nsec = (NSECRecord)set.first();
                ndp = ValUtils.nsecProvesNodata(nsec, qname, qtype);
                if (ndp.result) {
                    hasValidNSEC = true;
                }
                if (ValUtils.nsecProvesNameError(nsec, qname, set.getSignerName())) {
                    ce = ValUtils.closestEncloser(qname, nsec);
                }
            }
            if (set.getType() != 50) continue;
            nsec3s.add(set);
            nsec3Signer = set.getSignerName();
        }
        if (ndp.wc != null && (ce == null || !ce.equals((Object)ndp.wc) && !qname.equals(ce))) {
            hasValidNSEC = false;
        }
        this.n3valUtils.stripUnknownAlgNSEC3s(nsec3s);
        if (!hasValidNSEC && nsec3s.size() > 0) {
            if (this.n3valUtils.allNSEC3sIgnoreable(nsec3s, this.keyCache)) {
                response.setStatus(SecurityStatus.BOGUS, R.get("failed.nsec3_ignored", new Object[0]));
                return;
            }
            SecurityStatus status = this.n3valUtils.proveNodata(nsec3s, qname, qtype, nsec3Signer);
            if (status == SecurityStatus.INSECURE) {
                response.setStatus(SecurityStatus.INSECURE);
                return;
            }
            boolean bl = hasValidNSEC = status == SecurityStatus.SECURE;
        }
        if (!hasValidNSEC) {
            response.setBogus(R.get("failed.nodata", new Object[0]));
            logger.trace((Object)("Failed NODATA for " + qname));
            return;
        }
        logger.trace((Object)"sucessfully validated NODATA response.");
        response.setStatus(SecurityStatus.SECURE);
    }

    private void validateNameErrorResponse(Message request, SMessage response) {
        Name qname = request.getQuestion().getName();
        for (SRRset set : response.getSectionRRsets(1)) {
            if (set.getSecurityStatus() != SecurityStatus.SECURE) {
                response.setBogus(R.get("failed.nxdomain.cname_nxdomain", new Object[]{set}));
                return;
            }
            if (set.getType() != 5) continue;
            qname = ((CNAMERecord)set.first()).getTarget();
        }
        boolean hasValidNSEC = false;
        boolean hasValidWCNSEC = false;
        ArrayList<SRRset> nsec3s = new ArrayList<SRRset>(0);
        Name nsec3Signer = null;
        for (SRRset set : response.getSectionRRsets(2)) {
            KeyEntry ke = this.prepareFindKey(set);
            if (!this.processKeyValidate(response, set.getSignerName(), ke)) {
                return;
            }
            SRRset keyRrset = ke.getRRset();
            SecurityStatus status = this.valUtils.verifySRRset(set, keyRrset);
            if (status != SecurityStatus.SECURE) {
                response.setBogus(R.get("failed.nxdomain.authority", new Object[]{set}));
                return;
            }
            if (set.getType() == 47) {
                NSECRecord nsec = (NSECRecord)set.first();
                if (ValUtils.nsecProvesNameError(nsec, qname, set.getSignerName())) {
                    hasValidNSEC = true;
                }
                if (ValUtils.nsecProvesNoWC(nsec, qname, set.getSignerName())) {
                    hasValidWCNSEC = true;
                }
            }
            if (set.getType() != 50) continue;
            nsec3s.add(set);
            nsec3Signer = set.getSignerName();
        }
        this.n3valUtils.stripUnknownAlgNSEC3s(nsec3s);
        if (!(hasValidNSEC && hasValidWCNSEC || nsec3s.size() <= 0)) {
            logger.debug((Object)"Validating nxdomain: using NSEC3 records");
            if (this.n3valUtils.allNSEC3sIgnoreable(nsec3s, this.keyCache)) {
                response.setStatus(SecurityStatus.INSECURE, R.get("failed.nsec3_ignored", new Object[0]));
                return;
            }
            SecurityStatus status = this.n3valUtils.proveNameError(nsec3s, qname, nsec3Signer);
            if (status != SecurityStatus.SECURE) {
                if (status == SecurityStatus.INSECURE) {
                    response.setStatus(status, R.get("failed.nxdomain.nsec3_insecure", new Object[0]));
                } else {
                    response.setStatus(status, R.get("failed.nxdomain.nsec3_bogus", new Object[0]));
                }
                return;
            }
            hasValidNSEC = true;
            hasValidWCNSEC = true;
        }
        if (!hasValidNSEC) {
            response.setBogus(R.get("failed.nxdomain.exists", response.getQuestion().getName()));
            return;
        }
        if (!hasValidWCNSEC) {
            response.setBogus(R.get("failed.nxdomain.haswildcard", new Object[0]));
            return;
        }
        logger.trace((Object)"successfully validated NAME ERROR response.");
        response.setStatus(SecurityStatus.SECURE);
    }

    private SMessage sendRequest(Message request) {
        Record q = request.getQuestion();
        logger.trace((Object)("sending request: <" + q.getName() + "/" + Type.string((int)q.getType()) + "/" + DClass.string((int)q.getDClass()) + ">"));
        Message localRequest = (Message)request.clone();
        localRequest.getHeader().setFlag(11);
        try {
            Message resp = this.headResolver.send(localRequest);
            return new SMessage(resp);
        }
        catch (SocketTimeoutException e) {
            logger.error((Object)"Query timed out, returning fail", (Throwable)e);
            return ValidatingResolver.errorMessage(localRequest, 2);
        }
        catch (UnknownHostException e) {
            logger.error((Object)"failed to send query", (Throwable)e);
            return ValidatingResolver.errorMessage(localRequest, 2);
        }
        catch (IOException e) {
            logger.error((Object)"failed to send query", (Throwable)e);
            return ValidatingResolver.errorMessage(localRequest, 2);
        }
    }

    private KeyEntry prepareFindKey(SRRset rrset) {
        SRRset trustAnchorRRset;
        FindKeyState state = new FindKeyState();
        state.signerName = rrset.getSignerName();
        state.qclass = rrset.getDClass();
        if (state.signerName == null) {
            state.signerName = rrset.getName();
        }
        if ((trustAnchorRRset = this.trustAnchors.find(state.signerName, rrset.getDClass())) == null) {
            return KeyEntry.newNullKeyEntry(rrset.getSignerName(), rrset.getDClass(), 60L);
        }
        state.keyEntry = this.keyCache.find(state.signerName, rrset.getDClass());
        if (state.keyEntry == null || !state.keyEntry.getName().equals((Object)state.signerName) && state.keyEntry.isGood()) {
            state.dsRRset = trustAnchorRRset;
            state.keyEntry = null;
            state.currentDSKeyName = new Name(trustAnchorRRset.getName(), 1);
            this.processFindKey(state);
        }
        return state.keyEntry;
    }

    private void processFindKey(FindKeyState state) {
        int currentLabels;
        int targetLabels;
        int l;
        int qclass = state.qclass;
        Name targetKeyName = state.signerName;
        Name currentKeyName = Name.empty;
        if (state.keyEntry != null) {
            currentKeyName = state.keyEntry.getName();
        }
        if (state.currentDSKeyName != null) {
            currentKeyName = state.currentDSKeyName;
            state.currentDSKeyName = null;
        }
        if (currentKeyName.equals((Object)targetKeyName)) {
            return;
        }
        if (state.emptyDSName != null) {
            currentKeyName = state.emptyDSName;
        }
        if ((l = (targetLabels = targetKeyName.labels()) - (currentLabels = currentKeyName.labels()) - 1) < 0) {
            return;
        }
        Name nextKeyName = new Name(targetKeyName, l);
        logger.trace((Object)("findKey: targetKeyName = " + targetKeyName + ", currentKeyName = " + currentKeyName + ", nextKeyName = " + nextKeyName));
        if (state.dsRRset == null || !state.dsRRset.getName().equals((Object)nextKeyName)) {
            Message dsRequest = Message.newQuery((Record)Record.newRecord((Name)nextKeyName, (int)43, (int)qclass));
            SMessage dsResponse = this.sendRequest(dsRequest);
            this.processDSResponse(dsRequest, dsResponse, state);
            return;
        }
        Message dnskeyRequest = Message.newQuery((Record)Record.newRecord((Name)state.dsRRset.getName(), (int)48, (int)qclass));
        SMessage dnskeyResponse = this.sendRequest(dnskeyRequest);
        this.processDNSKEYResponse(dnskeyRequest, dnskeyResponse, state);
    }

    private KeyEntry dsResponseToKE(SMessage response, Message request, SRRset keyRrset) {
        Name qname = request.getQuestion().getName();
        int qclass = request.getQuestion().getDClass();
        ResponseClassification subtype = ValUtils.classifyResponse(response);
        KeyEntry bogusKE = KeyEntry.newBadKeyEntry(qname, qclass, 60L);
        switch (subtype) {
            case POSITIVE: {
                SRRset dsRrset = response.findAnswerRRset(qname, 43, qclass);
                SecurityStatus status = this.valUtils.verifySRRset(dsRrset, keyRrset);
                if (status != SecurityStatus.SECURE) {
                    bogusKE.setBadReason(R.get("failed.ds", new Object[0]));
                    return bogusKE;
                }
                if (!ValUtils.atLeastOneSupportedAlgorithm(dsRrset)) {
                    KeyEntry nullKey = KeyEntry.newNullKeyEntry(qname, qclass, dsRrset.getTTL());
                    nullKey.setBadReason(R.get("insecure.ds.noalgorithms", qname));
                    return nullKey;
                }
                logger.trace((Object)"DS rrset was good.");
                return KeyEntry.newKeyEntry(dsRrset);
            }
            case CNAME: {
                SRRset cnameRrset = response.findAnswerRRset(qname, 5, qclass);
                SecurityStatus status = this.valUtils.verifySRRset(cnameRrset, keyRrset);
                if (status == SecurityStatus.SECURE) {
                    return null;
                }
                bogusKE.setBadReason(R.get("failed.ds.cname", new Object[0]));
                return bogusKE;
            }
            case NODATA: 
            case NAMEERROR: {
                return this.dsReponseToKeForNodata(response, request, keyRrset);
            }
        }
        bogusKE.setBadReason(R.get("failed.ds.notype", new Object[]{subtype}));
        return bogusKE;
    }

    private KeyEntry dsReponseToKeForNodata(SMessage response, Message request, SRRset keyRrset) {
        Name qname = request.getQuestion().getName();
        int qclass = request.getQuestion().getDClass();
        KeyEntry bogusKE = KeyEntry.newBadKeyEntry(qname, qclass, 60L);
        if (!this.valUtils.hasSignedNsecs(response)) {
            bogusKE.setBadReason(R.get("failed.ds.nonsec", qname));
            return bogusKE;
        }
        JustifiedSecStatus status = this.valUtils.nsecProvesNodataDsReply(request, response, keyRrset);
        switch (status.status) {
            case SECURE: {
                KeyEntry nullKey = KeyEntry.newNullKeyEntry(qname, qclass, 60L);
                nullKey.setBadReason(R.get("insecure.ds.nsec", new Object[0]));
                return nullKey;
            }
            case INSECURE: {
                return null;
            }
            case BOGUS: {
                bogusKE.setBadReason(status.reason);
                return bogusKE;
            }
        }
        SRRset[] nsec3Rrsets = response.getSectionRRsets(2, 50);
        ArrayList<SRRset> nsec3s = new ArrayList<SRRset>(0);
        Name nsec3Signer = null;
        long nsec3TTL = -1L;
        if (nsec3Rrsets.length > 0) {
            for (SRRset nsec3set : nsec3Rrsets) {
                SecurityStatus sstatus = this.valUtils.verifySRRset(nsec3set, keyRrset);
                if (sstatus != SecurityStatus.SECURE) {
                    logger.debug((Object)"skipping bad nsec3");
                    continue;
                }
                nsec3Signer = nsec3set.getSignerName();
                if (nsec3TTL < 0L || nsec3set.getTTL() < nsec3TTL) {
                    nsec3TTL = nsec3set.getTTL();
                }
                nsec3s.add(nsec3set);
            }
            switch (this.n3valUtils.proveNoDS(nsec3s, qname, nsec3Signer)) {
                case INSECURE: {
                    logger.debug((Object)"nsec3s proved no delegation.");
                    return null;
                }
                case SECURE: {
                    KeyEntry nullKey = KeyEntry.newNullKeyEntry(qname, qclass, nsec3TTL);
                    nullKey.setBadReason(R.get("insecure.ds.nsec3", new Object[0]));
                    return nullKey;
                }
            }
            bogusKE.setBadReason(R.get("failed.ds.nsec3", new Object[0]));
            return bogusKE;
        }
        bogusKE.setBadReason(R.get("failed.ds.unknown", new Object[0]));
        return bogusKE;
    }

    private void processDSResponse(Message request, SMessage response, FindKeyState state) {
        Name qname = request.getQuestion().getName();
        state.emptyDSName = null;
        state.dsRRset = null;
        KeyEntry dsKE = this.dsResponseToKE(response, request, state.keyEntry.getRRset());
        if (dsKE == null) {
            state.emptyDSName = qname;
        } else if (dsKE.isGood()) {
            state.dsRRset = dsKE.getRRset();
            state.currentDSKeyName = new Name(dsKE.getRRset().getName(), 1);
        } else {
            state.keyEntry = dsKE;
            if (dsKE.isNull()) {
                this.keyCache.store(dsKE);
            }
            return;
        }
        this.processFindKey(state);
    }

    private void processDNSKEYResponse(Message request, SMessage response, FindKeyState state) {
        int qclass;
        Name qname = request.getQuestion().getName();
        SRRset dnskeyRrset = response.findAnswerRRset(qname, 48, qclass = request.getQuestion().getDClass());
        if (dnskeyRrset == null) {
            state.keyEntry = KeyEntry.newBadKeyEntry(qname, qclass, 60L);
            state.keyEntry.setBadReason(R.get("dnskey.no_rrset", qname));
            return;
        }
        state.keyEntry = this.valUtils.verifyNewDNSKEYs(dnskeyRrset, state.dsRRset, 60L);
        if (!state.keyEntry.isGood()) {
            return;
        }
        this.keyCache.store(state.keyEntry);
        this.processFindKey(state);
    }

    private boolean processKeyValidate(SMessage response, Name signerName, KeyEntry keyEntry) {
        if (signerName == null) {
            logger.debug((Object)"processKeyValidate: no signerName.");
            if (keyEntry.isNull()) {
                String reason = keyEntry.getBadReason();
                if (reason == null) {
                    reason = R.get("validate.insecure_unsigned", new Object[0]);
                }
                response.setStatus(SecurityStatus.INSECURE, reason);
                return false;
            }
            if (keyEntry.isGood()) {
                response.setStatus(SecurityStatus.BOGUS, R.get("validate.bogus.missingsig", new Object[0]));
                return false;
            }
            response.setStatus(SecurityStatus.BOGUS, R.get("validate.bogus", keyEntry.getBadReason()));
            return false;
        }
        if (keyEntry.isBad()) {
            response.setStatus(SecurityStatus.BOGUS, R.get("validate.bogus.badkey", keyEntry.getName(), keyEntry.getBadReason()));
            return false;
        }
        if (keyEntry.isNull()) {
            String reason = keyEntry.getBadReason();
            if (reason == null) {
                reason = R.get("validate.insecure", new Object[0]);
            }
            response.setStatus(SecurityStatus.INSECURE, reason);
            return false;
        }
        return true;
    }

    private SMessage processValidate(Message request, SMessage response) {
        ResponseClassification subtype = ValUtils.classifyResponse(response);
        switch (subtype) {
            case POSITIVE: 
            case CNAME: 
            case ANY: {
                logger.trace((Object)"Validating a positive response");
                this.validatePositiveResponse(request, response);
                break;
            }
            case NODATA: {
                logger.trace((Object)"Validating a nodata response");
                this.validateNodataResponse(request, response);
                break;
            }
            case CNAME_NODATA: {
                logger.trace((Object)"Validating a CNAME_NODATA response");
                this.validatePositiveResponse(request, response);
                if (response.getStatus() == SecurityStatus.INSECURE) break;
                response.setStatus(SecurityStatus.UNCHECKED);
                this.validateNodataResponse(request, response);
                break;
            }
            case NAMEERROR: {
                logger.trace((Object)"Validating a nxdomain response");
                this.validateNameErrorResponse(request, response);
                break;
            }
            case CNAME_NAMEERROR: {
                logger.trace((Object)"Validating a cname_nxdomain response");
                this.validatePositiveResponse(request, response);
                if (response.getStatus() == SecurityStatus.INSECURE) break;
                response.setStatus(SecurityStatus.UNCHECKED);
                this.validateNameErrorResponse(request, response);
                break;
            }
            default: {
                response.setStatus(SecurityStatus.BOGUS, R.get("validate.response.unknown", new Object[]{subtype}));
            }
        }
        return this.processFinishedState(request, response);
    }

    private SMessage processFinishedState(Message request, SMessage response) {
        SecurityStatus status = response.getStatus();
        String reason = response.getBogusReason();
        switch (status) {
            case BOGUS: {
                int code = response.getHeader().getRcode();
                if (code == 0 || code == 3 || code == 6) {
                    code = 2;
                }
                response = ValidatingResolver.errorMessage(request, code);
                break;
            }
            case SECURE: {
                response.getHeader().setFlag(10);
                break;
            }
            case INSECURE: 
            case UNCHECKED: {
                break;
            }
            default: {
                throw new RuntimeException("unexpected security status");
            }
        }
        response.setStatus(status, reason);
        return response;
    }

    public void setPort(int port) {
        this.headResolver.setPort(port);
    }

    public void setTCP(boolean flag) {
        this.headResolver.setTCP(flag);
    }

    public void setIgnoreTruncation(boolean flag) {
    }

    public void setEDNS(int level) {
    }

    public void setEDNS(int level, int payloadSize, int flags, List options) {
        this.headResolver.setEDNS(0, payloadSize, flags | 0x8000, options);
    }

    public void setTSIGKey(TSIG key) {
        this.headResolver.setTSIGKey(key);
    }

    public void setTimeout(int secs, int msecs) {
        this.headResolver.setTimeout(secs, msecs);
    }

    public void setTimeout(int secs) {
        this.headResolver.setTimeout(secs);
    }

    public Message send(Message query) throws IOException {
        SMessage response = this.sendRequest(query);
        response.getHeader().unsetFlag(10);
        if (query.getHeader().getFlag(11)) {
            return response.getMessage();
        }
        Message rrsigResponse = response.getMessage();
        if (query.getQuestion().getType() == 46 && rrsigResponse.getHeader().getRcode() == 0 && rrsigResponse.getSectionRRsets(1).length > 0) {
            rrsigResponse.getHeader().unsetFlag(10);
            return rrsigResponse;
        }
        SMessage validated = this.processValidate(query, response);
        Message m = validated.getMessage();
        if (validated.getBogusReason() != null) {
            m.addRecord((Record)new TXTRecord(Name.root, 65280, 0L, Arrays.asList(validated.getBogusReason().split("(?<=\\G.{255})"))), 3);
        }
        return m;
    }

    public Object sendAsync(Message query, ResolverListener listener) {
        throw new UnsupportedOperationException("Not implemented");
    }

    private static SMessage errorMessage(Message request, int rcode) {
        SMessage m = new SMessage(request.getHeader().getID(), request.getQuestion());
        Header h = m.getHeader();
        h.setRcode(rcode);
        h.setFlag(0);
        return m;
    }
}

