/**
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jledit.utils;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;


public final class Urls {

    private Urls() {
        //Utility Class
    }

    public static URL create(final String input) {
        if (input == null) {
            return null;
        }
        try {
            return new URL(input);
        } catch (MalformedURLException e) {
            return create(new File(input));
        }
    }

    public static URL create(final File file) {
        try {
            return file != null ? file.toURI().toURL() : null;
        } catch (MalformedURLException e) {
            throw new IllegalStateException(e);
        }
    }
}
