/*
 * Decompiled with CFR 0.152.
 */
package jodd.typeconverter.impl;

import jodd.typeconverter.ConvertBean;
import jodd.typeconverter.TypeConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassArrayConverter
implements TypeConverter<Class[]> {
    protected final ConvertBean convertBean;

    public ClassArrayConverter(ConvertBean convertBean) {
        this.convertBean = convertBean;
    }

    @Override
    public Class[] convert(Object value) {
        if (value == null) {
            return null;
        }
        Class<?> type = value.getClass();
        if (type == Class[].class) {
            return (Class[])value;
        }
        if (type == Class.class) {
            return new Class[]{(Class)value};
        }
        String[] classNames = this.convertBean.toStringArray(value);
        Class[] result = new Class[classNames.length];
        for (int i = 0; i < classNames.length; ++i) {
            result[i] = this.convertBean.toClass(classNames[i]);
        }
        return result;
    }
}

