/*
 * Decompiled with CFR 0.152.
 */
package jodd.util;

import java.io.ByteArrayOutputStream;
import jodd.Jodd;
import jodd.io.StreamGobbler;

public class RuntimeUtil {
    public static final String ERROR_PREFIX = "err> ";
    public static final String OUTPUT_PREFIX = "out> ";

    public static long availableMemory() {
        return Runtime.getRuntime().freeMemory() + (Runtime.getRuntime().maxMemory() - Runtime.getRuntime().totalMemory());
    }

    public static float availableMemoryPercent() {
        return (float)RuntimeUtil.availableMemory() * 100.0f / (float)Runtime.getRuntime().maxMemory();
    }

    public static void compactMemory() {
        try {
            byte[][] unused = new byte[128][];
            int i = unused.length;
            while (i-- != 0) {
                unused[i] = new byte[2000000000];
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            // empty catch block
        }
        System.gc();
    }

    public static String classLocation(Class clazz) {
        return clazz.getProtectionDomain().getCodeSource().getLocation().getPath();
    }

    public static String joddLocation() {
        return RuntimeUtil.classLocation(Jodd.class);
    }

    public static ProcessResult run(Process process) throws InterruptedException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        StreamGobbler outputGobbler = new StreamGobbler(process.getInputStream(), baos, OUTPUT_PREFIX);
        StreamGobbler errorGobbler = new StreamGobbler(process.getErrorStream(), baos, ERROR_PREFIX);
        outputGobbler.start();
        errorGobbler.start();
        int result = process.waitFor();
        outputGobbler.waitFor();
        errorGobbler.waitFor();
        return new ProcessResult(result, baos.toString());
    }

    public static class ProcessResult {
        private final int exitCode;
        private final String output;

        protected ProcessResult(int existCode, String output) {
            this.exitCode = existCode;
            this.output = output;
        }

        public int getExitCode() {
            return this.exitCode;
        }

        public String getOutput() {
            return this.output;
        }
    }
}

