/*
 * Decompiled with CFR 0.152.
 */
package org.jxls.command;

import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.jxls.area.Area;
import org.jxls.command.AbstractCommand;
import org.jxls.command.Command;
import org.jxls.common.CellRef;
import org.jxls.common.Context;
import org.jxls.common.Size;
import org.jxls.transform.poi.PoiTransformer;

public class MergeCellsCommand
extends AbstractCommand {
    public static final String COMMAND_NAME = "mergeCells";
    private String cols;
    private String rows;
    private String minCols;
    private String minRows;
    private Area area;

    public String getName() {
        return COMMAND_NAME;
    }

    public String getCols() {
        return this.cols;
    }

    public void setCols(String cols) {
        this.cols = cols;
    }

    public String getRows() {
        return this.rows;
    }

    public void setRows(String rows) {
        this.rows = rows;
    }

    public String getMinCols() {
        return this.minCols;
    }

    public void setMinCols(String minCols) {
        this.minCols = minCols;
    }

    public String getMinRows() {
        return this.minRows;
    }

    public void setMinRows(String minRows) {
        this.minRows = minRows;
    }

    public Command addArea(Area area) {
        if (super.getAreaList().size() >= 1) {
            throw new IllegalArgumentException("You can only add 1 area to 'mergeCells' command!");
        }
        this.area = area;
        return super.addArea(area);
    }

    public Size applyAt(CellRef cellRef, Context context) {
        int rows = this.getVal(this.rows, context);
        int cols = this.getVal(this.cols, context);
        rows = Math.max(this.getVal(this.minRows, context), rows);
        cols = Math.max(this.getVal(this.minCols, context), cols);
        rows = rows > 0 ? rows : this.area.getSize().getHeight();
        int n = cols = cols > 0 ? cols : this.area.getSize().getWidth();
        if (rows > 1 || cols > 1) {
            this.mergeCells(((PoiTransformer)this.getTransformer()).getWorkbook(), cellRef, rows, cols);
        }
        this.area.applyAt(cellRef, context);
        return new Size(cols, rows);
    }

    private int getVal(String expression, Context context) {
        if (expression != null && expression.trim().length() > 0) {
            Object obj = context.evaluate(expression);
            try {
                return Integer.parseInt(obj.toString());
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Expression: " + expression + " failed to resolve");
            }
        }
        return 0;
    }

    private void mergeCells(Workbook workbook, CellRef cellRef, int rows, int cols) {
        Sheet sheet = workbook.getSheet(cellRef.getSheetName());
        CellRangeAddress region = new CellRangeAddress(cellRef.getRow(), cellRef.getRow() + rows - 1, cellRef.getCol(), cellRef.getCol() + cols - 1);
        sheet.addMergedRegion(region);
        CellStyle cellStyle = null;
        try {
            cellStyle = ((PoiTransformer)this.getTransformer()).getCellStyle(cellRef);
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (int i = region.getFirstRow(); i <= region.getLastRow(); ++i) {
            Row row = sheet.getRow(i);
            if (row == null) {
                row = sheet.createRow(i);
            }
            for (int j = region.getFirstColumn(); j <= region.getLastColumn(); ++j) {
                Cell cell = row.getCell(j);
                if (cell == null) {
                    cell = row.createCell(j);
                }
                if (cellStyle == null) {
                    cell.getCellStyle().setAlignment(HorizontalAlignment.CENTER);
                    cell.getCellStyle().setVerticalAlignment(VerticalAlignment.CENTER);
                    continue;
                }
                cell.setCellStyle(cellStyle);
            }
        }
    }
}

