/*
 * Decompiled with CFR 0.152.
 */
package org.jxls.transform.poi;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.Map;
import org.apache.poi.ss.formula.FormulaParseException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.jxls.common.CellData;
import org.jxls.common.CellRef;
import org.jxls.common.Context;
import org.jxls.common.JxlsException;
import org.jxls.transform.poi.PoiRowData;
import org.jxls.transform.poi.PoiTransformer;
import org.jxls.transform.poi.PoiUtil;
import org.jxls.transform.poi.WritableCellValue;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCell;

public class PoiCellData
extends CellData {
    private PoiRowData poiRowData;
    private RichTextString richTextString;
    private CellStyle cellStyle;
    private Hyperlink hyperlink;
    private Comment comment;
    private String commentAuthor;
    private Cell cell;

    public PoiCellData(CellRef cellRef) {
        super(cellRef);
    }

    public PoiCellData(CellRef cellRef, Cell cell) {
        super(cellRef);
        this.cell = cell;
    }

    public static PoiCellData createCellData(PoiRowData poiRowData, CellRef cellRef, Cell cell) {
        PoiCellData cellData = new PoiCellData(cellRef, cell);
        cellData.poiRowData = poiRowData;
        cellData.readCell(cell);
        cellData.updateFormulaValue();
        return cellData;
    }

    public void readCell(Cell cell) {
        this.readCellGeneralInfo(cell);
        this.readCellContents(cell);
        this.readCellStyle(cell);
    }

    private void readCellGeneralInfo(Cell cell) {
        this.hyperlink = cell.getHyperlink();
        try {
            this.comment = cell.getCellComment();
        }
        catch (Exception e) {
            throw new JxlsException("Failed to read cell comment at " + new CellReference(cell).formatAsString(), (Throwable)e);
        }
        if (this.comment != null) {
            this.commentAuthor = this.comment.getAuthor();
        }
        if (this.comment != null && this.comment.getString() != null && this.comment.getString().getString() != null) {
            String[] commentLines;
            String commentString = this.comment.getString().getString();
            for (String commentLine : commentLines = commentString.split("\\n")) {
                if (!this.isJxlsParamsComment(commentLine)) continue;
                this.processJxlsParams(commentLine);
                this.comment = null;
                return;
            }
            this.setCellComment(commentString);
        }
    }

    public CellStyle getCellStyle() {
        return this.cellStyle;
    }

    public void setCellStyle(CellStyle cellStyle) {
        this.cellStyle = cellStyle;
    }

    private void readCellContents(Cell cell) {
        switch (cell.getCellType()) {
            case STRING: {
                this.richTextString = cell.getRichStringCellValue();
                this.cellValue = this.richTextString.getString();
                this.cellType = CellData.CellType.STRING;
                break;
            }
            case BOOLEAN: {
                this.cellValue = cell.getBooleanCellValue();
                this.cellType = CellData.CellType.BOOLEAN;
                break;
            }
            case NUMERIC: {
                this.readNumericCellContents(cell);
                break;
            }
            case FORMULA: {
                this.formula = cell.getCellFormula();
                this.cellValue = this.formula;
                this.cellType = CellData.CellType.FORMULA;
                break;
            }
            case ERROR: {
                this.cellValue = cell.getErrorCellValue();
                this.cellType = CellData.CellType.ERROR;
                break;
            }
            case BLANK: 
            case _NONE: {
                this.cellValue = null;
                this.cellType = CellData.CellType.BLANK;
            }
        }
        this.evaluationResult = this.cellValue;
    }

    private void readNumericCellContents(Cell cell) {
        if (DateUtil.isCellDateFormatted((Cell)cell)) {
            this.cellValue = cell.getDateCellValue();
            this.cellType = CellData.CellType.DATE;
        } else {
            this.cellValue = cell.getNumericCellValue();
            this.cellType = CellData.CellType.NUMBER;
        }
    }

    private void readCellStyle(Cell cell) {
        this.cellStyle = cell.getCellStyle();
    }

    public void writeToCell(Cell cell, Context context, PoiTransformer transformer) {
        this.evaluate(context);
        Object object = this.evaluationResult;
        if (object instanceof WritableCellValue) {
            WritableCellValue e = (WritableCellValue)object;
            cell.setCellStyle(this.cellStyle);
            e.writeToCell(cell, context);
        } else {
            CellStyle dataFormatCellStyle;
            this.updateCellGeneralInfo(cell);
            this.updateCellContents(cell);
            CellStyle targetCellStyle = this.cellStyle;
            if (context.isIgnoreSourceCellStyle() && (dataFormatCellStyle = this.findCellStyle(this.evaluationResult, context.getCellStyleMap(), transformer)) != null) {
                targetCellStyle = dataFormatCellStyle;
            }
            this.updateCellStyle(cell, targetCellStyle);
            this.poiRowData.getPoiSheetData().updateConditionalFormatting(this, cell);
        }
    }

    private CellStyle findCellStyle(Object evaluationResult, Map<String, String> cellStyleMap, PoiTransformer transformer) {
        if (evaluationResult == null || cellStyleMap == null) {
            return null;
        }
        String cellName = cellStyleMap.get(evaluationResult.getClass().getSimpleName());
        if (cellName == null) {
            return null;
        }
        Sheet sheet = this.cell.getSheet();
        CellRef cellRef = new CellRef(cellName);
        if (cellRef.getSheetName() == null) {
            cellRef.setSheetName(sheet.getSheetName());
        }
        return transformer.getCellStyle(cellRef);
    }

    private void updateCellGeneralInfo(Cell cell) {
        if (this.hyperlink != null) {
            cell.setHyperlink(this.hyperlink);
        }
        if (this.comment != null && !PoiUtil.isJxComment(this.getCellComment())) {
            PoiUtil.setCellComment(cell, this.getCellComment(), this.commentAuthor, null);
        }
    }

    private void updateCellContents(Cell cell) {
        switch (this.targetCellType) {
            case STRING: {
                this.updateStringCellContents(cell);
                break;
            }
            case BOOLEAN: {
                Boolean tf = (Boolean)this.evaluationResult;
                cell.setCellValue(tf.booleanValue());
                break;
            }
            case DATE: {
                cell.setCellValue((Date)this.evaluationResult);
                break;
            }
            case LOCAL_DATE: {
                cell.setCellValue((LocalDate)this.evaluationResult);
                break;
            }
            case LOCAL_TIME: {
                cell.setCellValue(((LocalTime)this.evaluationResult).atDate(LocalDate.now()));
                break;
            }
            case LOCAL_DATETIME: {
                cell.setCellValue((LocalDateTime)this.evaluationResult);
                break;
            }
            case ZONED_DATETIME: {
                cell.setCellValue(((ZonedDateTime)this.evaluationResult).toLocalDateTime());
                break;
            }
            case INSTANT: {
                cell.setCellValue(((Instant)this.evaluationResult).atZone(ZoneId.systemDefault()).toLocalDateTime());
                break;
            }
            case NUMBER: {
                cell.setCellValue(((Number)this.evaluationResult).doubleValue());
                break;
            }
            case FORMULA: {
                this.updateFormulaCellContents(cell);
                break;
            }
            case ERROR: {
                Byte b = (Byte)this.evaluationResult;
                cell.setCellErrorValue(b.byteValue());
                break;
            }
            case BLANK: {
                cell.setBlank();
            }
        }
    }

    private void updateStringCellContents(Cell cell) {
        String result;
        if (this.evaluationResult instanceof byte[]) {
            return;
        }
        String string = result = this.evaluationResult != null ? this.evaluationResult.toString() : "";
        if (this.cellValue != null && this.cellValue.equals(result)) {
            cell.setCellValue(this.richTextString);
        } else {
            cell.setCellValue(result);
        }
    }

    private void updateFormulaCellContents(Cell cell) {
        try {
            if (this.formulaContainsJointedCellRef((String)this.evaluationResult)) {
                cell.setCellValue((String)this.evaluationResult);
            } else {
                cell.setCellFormula((String)this.evaluationResult);
                this.clearCellValue(cell);
            }
        }
        catch (FormulaParseException e) {
            try {
                String formulaString = this.evaluationResult.toString();
                this.getTransformer().getLogger().warn((Throwable)e, "Failed to set cell formula " + formulaString + " for cell " + this.toString());
                cell.setCellValue(formulaString);
            }
            catch (Exception ex) {
                this.getTransformer().getLogger().error((Throwable)ex, "Failed to convert formula to string for cell " + this.toString());
            }
        }
    }

    protected void clearCellValue(Cell poiCell) {
        XSSFCell xcell;
        CTCell cell;
        if (poiCell instanceof XSSFCell && (cell = (xcell = (XSSFCell)poiCell).getCTCell()).isSetV()) {
            cell.unsetV();
        }
    }

    private void updateCellStyle(Cell cell, CellStyle cellStyle) {
        cell.setCellStyle(cellStyle);
    }
}

