/*
 * Decompiled with CFR 0.152.
 */
package org.jxls.transform.poi;

import java.util.Set;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.jxls.common.CellData;
import org.jxls.common.CellRef;
import org.jxls.common.Context;
import org.jxls.transform.poi.PoiTransformer;
import org.jxls.transform.poi.PoiUtil;

public class SelectSheetsForStreamingPoiTransformer
extends PoiTransformer {
    protected Set<String> dataSheetsToUseStreaming = null;
    protected boolean allSheets = false;

    public SelectSheetsForStreamingPoiTransformer(Workbook workbook) {
        super(workbook, true);
    }

    public SelectSheetsForStreamingPoiTransformer(Workbook workbook, boolean allSheets, int rowAccessWindowSize, boolean compressTmpFiles, boolean useSharedStringsTable) {
        super(workbook, true, rowAccessWindowSize, compressTmpFiles, useSharedStringsTable);
        this.allSheets = allSheets;
    }

    public SelectSheetsForStreamingPoiTransformer(Workbook workbook, Set<String> sheetNames, int rowAccessWindowSize, boolean compressTmpFiles, boolean useSharedStringsTable) {
        super(workbook, true, rowAccessWindowSize, compressTmpFiles, useSharedStringsTable);
        this.dataSheetsToUseStreaming = sheetNames;
    }

    public void setDataSheetsToUseStreaming(Set<String> sheetNames) {
        this.dataSheetsToUseStreaming = sheetNames;
    }

    @Override
    public void transform(CellRef srcCellRef, CellRef targetCellRef, Context context, boolean updateRowHeightFlag) {
        Row destRow;
        boolean useStreamingForThisSheet;
        CellData cellData = this.isTransformable(srcCellRef, targetCellRef);
        if (cellData == null) {
            return;
        }
        Sheet destSheet = this.getWorkbook().getSheet(targetCellRef.getSheetName());
        if (destSheet == null) {
            destSheet = this.getWorkbook().createSheet(targetCellRef.getSheetName());
            PoiUtil.copySheetProperties(this.getWorkbook().getSheet(srcCellRef.getSheetName()), destSheet);
        }
        if (!(useStreamingForThisSheet = this.useStreaming(targetCellRef.getSheetName())) && this.isStreaming()) {
            destSheet = ((SXSSFWorkbook)this.getWorkbook()).getXSSFWorkbook().getSheet(targetCellRef.getSheetName());
        }
        if ((destRow = destSheet.getRow(targetCellRef.getRow())) == null) {
            if (useStreamingForThisSheet && this.isStreaming()) {
                XSSFSheet _sh = ((SXSSFWorkbook)this.getWorkbook()).getXSSFWorkbook().getSheet(targetCellRef.getSheetName());
                if (_sh.getPhysicalNumberOfRows() > 0 && targetCellRef.getRow() <= _sh.getLastRowNum()) {
                    destRow = _sh.getRow(targetCellRef.getRow());
                    destSheet = _sh;
                    if (destRow == null) {
                        destRow = destSheet.createRow(targetCellRef.getRow());
                    }
                } else {
                    destRow = destSheet.createRow(targetCellRef.getRow());
                }
            } else {
                destRow = destSheet.createRow(targetCellRef.getRow());
            }
        }
        this.transformCell(srcCellRef, targetCellRef, context, updateRowHeightFlag, cellData, destSheet, destRow);
    }

    protected boolean useStreaming(String sheetName) {
        return this.allSheets || this.dataSheetsToUseStreaming != null && this.dataSheetsToUseStreaming.contains(sheetName);
    }

    @Override
    protected Row getRowForClearCell(Sheet sheet, CellRef cellRef) {
        XSSFSheet _sh;
        Row row = super.getRowForClearCell(sheet, cellRef);
        if (row == null && this.isStreaming() && (_sh = this.getXSSFWorkbook().getSheet(cellRef.getSheetName())).getPhysicalNumberOfRows() > 0 && cellRef.getRow() <= _sh.getLastRowNum()) {
            row = _sh.getRow(cellRef.getRow());
        }
        return row;
    }
}

