/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2;

import java.util.Map;
import org.mvel2.CompileException;
import org.mvel2.MVELRuntime;
import org.mvel2.ParseException;
import org.mvel2.ast.ASTNode;
import org.mvel2.ast.Substatement;
import org.mvel2.compiler.AbstractParser;
import org.mvel2.compiler.EndWithValue;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.integration.impl.ClassImportResolverFactory;
import org.mvel2.integration.impl.MapVariableResolverFactory;
import org.mvel2.util.ExecutionStack;
import org.mvel2.util.ParseTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MVELInterpretedRuntime
extends AbstractParser {
    private boolean returnBigDecimal = false;
    private int roundingMode = 5;
    private Object holdOverRegister;

    Object parse() {
        this.debugSymbols = false;
        try {
            this.stk = new ExecutionStack();
            this.dStack = new ExecutionStack();
            this.cursor = 0;
            this.parseAndExecuteInterpreted();
            if (parserContext != null) {
                MVELInterpretedRuntime.contextControl(1, null, null);
            }
            return this.stk.pop();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            e.printStackTrace();
            throw new ParseException("unexpected end of statement", this.expr, this.length);
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            if (this.cursor >= this.length) {
                throw new ParseException("unexpected end of statement", this.expr, this.length);
            }
            throw e;
        }
        catch (EndWithValue end) {
            return end.getValue();
        }
    }

    private void parseAndExecuteInterpreted() {
        ASTNode tk = null;
        this.lastWasIdentifier = false;
        try {
            block12: while ((tk = this.nextToken()) != null) {
                int operator;
                this.holdOverRegister = null;
                if (this.lastWasIdentifier && this.lastNode.isDiscard()) {
                    this.stk.discard();
                }
                if (this.stk.isEmpty()) {
                    this.stk.push(tk.getReducedValue(this.ctx, this.ctx, this.variableFactory));
                    if (!(tk instanceof Substatement) || (tk = this.nextToken()) == null) continue;
                    operator = tk.getOperator();
                    if (MVELInterpretedRuntime.isArithmeticOperator(operator)) {
                        this.stk.push(this.nextToken().getReducedValue(this.ctx, this.ctx, this.variableFactory), operator);
                        if (this.procBooleanOperator(this.arithmeticFunctionReduction(operator)) != -1) continue;
                        return;
                    }
                }
                operator = tk.getOperator();
                switch (this.procBooleanOperator(operator)) {
                    case -1: {
                        return;
                    }
                    case 0: {
                        continue block12;
                    }
                    case -2: {
                        if (tk.isOperator()) continue block12;
                        if (!(this.stk.peek() instanceof Class)) {
                            throw new CompileException("unexpected token: " + tk.getName());
                        }
                        this.variableFactory.createVariable(tk.getName(), null, (Class)this.stk.peek());
                        continue block12;
                    }
                }
                this.stk.push(this.nextToken().getReducedValue(this.ctx, this.ctx, this.variableFactory), operator);
                operator = this.arithmeticFunctionReduction(operator);
                switch (operator) {
                    case -1: {
                        return;
                    }
                    case 0: {
                        continue block12;
                    }
                }
                if (this.procBooleanOperator(operator) != -1) continue;
                return;
            }
            if (this.holdOverRegister != null) {
                this.stk.push(this.holdOverRegister);
            }
        }
        catch (CompileException e) {
            e.setExpr(this.expr);
            e.setLineNumber(this.line);
            e.setColumn(this.cursor - this.lastLineStart);
            throw e;
        }
        catch (NullPointerException e) {
            if (tk != null && tk.isOperator()) {
                throw new CompileException("incomplete statement: " + tk.getName() + " (possible use of reserved keyword as identifier: " + tk.getName() + ")", e);
            }
            throw e;
        }
    }

    private int procBooleanOperator(int operator) {
        switch (operator) {
            case -1: {
                return -2;
            }
            case 21: {
                this.reduceRight();
                if (!this.stk.peekBoolean().booleanValue()) {
                    if (this.unwindStatement(operator)) {
                        return -1;
                    }
                    this.stk.clear();
                    return 0;
                }
                this.stk.discard();
                return 0;
            }
            case 22: {
                this.reduceRight();
                if (this.stk.peekBoolean().booleanValue()) {
                    if (this.unwindStatement(operator)) {
                        return -1;
                    }
                    this.stk.clear();
                    return 0;
                }
                this.stk.discard();
                return 0;
            }
            case 29: {
                if (!this.stk.popBoolean().booleanValue()) {
                    ASTNode tk;
                    this.stk.clear();
                    while ((tk = this.nextToken()) != null && !tk.isOperator(30)) {
                    }
                }
                return 0;
            }
            case 30: {
                this.captureToEOS();
                return 0;
            }
            case 37: {
                if (this.hasMore()) {
                    this.holdOverRegister = this.stk.pop();
                    this.stk.clear();
                }
                return 0;
            }
        }
        return 1;
    }

    private void reduceRight() {
        if (this.dStack.isEmpty()) {
            return;
        }
        Object o = this.stk.pop();
        this.stk.push(this.dStack.pop());
        this.stk.push(o);
        this.stk.push(this.dStack.pop());
        this.reduce();
    }

    private boolean hasMore() {
        return this.cursor <= this.length;
    }

    private boolean unwindStatement(int operator) {
        ASTNode tk;
        switch (operator) {
            case 21: {
                while ((tk = this.nextToken()) != null && !tk.isOperator(37) && !tk.isOperator(22)) {
                }
                break;
            }
            default: {
                while ((tk = this.nextToken()) != null && !tk.isOperator(37)) {
                }
                break block0;
            }
        }
        return tk == null;
    }

    public MVELInterpretedRuntime setExpressionArray(char[] expressionArray) {
        this.expr = expressionArray;
        this.length = expressionArray.length;
        return this;
    }

    public int getRoundingMode() {
        return this.roundingMode;
    }

    public void setRoundingMode(int roundingMode) {
        this.roundingMode = roundingMode;
    }

    public boolean isReturnBigDecimal() {
        return this.returnBigDecimal;
    }

    public void setReturnBigDecimal(boolean returnBigDecimal) {
        this.returnBigDecimal = returnBigDecimal;
    }

    MVELInterpretedRuntime(char[] expression, Object ctx, Map<String, Object> variables) {
        this.expr = expression;
        this.length = this.expr.length;
        this.ctx = ctx;
        this.variableFactory = new MapVariableResolverFactory(variables);
    }

    MVELInterpretedRuntime(char[] expression, Object ctx) {
        this.expr = expression;
        this.length = this.expr.length;
        this.ctx = ctx;
        this.variableFactory = MVELRuntime.IMMUTABLE_DEFAULT_FACTORY;
    }

    MVELInterpretedRuntime(String expression, Object ctx, Map<String, Object> variables) {
        this.setExpression(expression);
        this.ctx = ctx;
        this.variableFactory = new MapVariableResolverFactory(variables);
    }

    MVELInterpretedRuntime(String expression) {
        this.setExpression(expression);
    }

    MVELInterpretedRuntime(char[] expression) {
        this.expr = expression;
        this.length = expression.length;
    }

    MVELInterpretedRuntime(char[] expr, Object ctx, VariableResolverFactory resolverFactory) {
        this.expr = expr;
        this.length = expr.length;
        this.ctx = ctx;
        this.variableFactory = resolverFactory;
    }

    MVELInterpretedRuntime(char[] expr, Object ctx, VariableResolverFactory resolverFactory, boolean returnBigDecimal) {
        this.expr = expr;
        this.length = expr.length;
        this.ctx = ctx;
        this.variableFactory = resolverFactory;
        this.returnBigDecimal = returnBigDecimal;
    }

    MVELInterpretedRuntime(Object ctx, Map<String, Object> variables) {
        this.ctx = ctx;
        this.variableFactory = new MapVariableResolverFactory(variables);
    }

    MVELInterpretedRuntime(String expression, Object ctx, VariableResolverFactory resolverFactory) {
        this.setExpression(expression);
        this.ctx = ctx;
        this.variableFactory = resolverFactory;
    }

    MVELInterpretedRuntime(String expression, Object ctx, VariableResolverFactory resolverFactory, boolean returnBigDecimal) {
        this.setExpression(expression);
        this.ctx = ctx;
        this.variableFactory = resolverFactory;
        this.returnBigDecimal = returnBigDecimal;
    }

    MVELInterpretedRuntime(String expression, VariableResolverFactory resolverFactory) {
        this.setExpression(expression);
        this.variableFactory = resolverFactory;
    }

    MVELInterpretedRuntime(String expression, Object ctx) {
        this.setExpression(expression);
        this.ctx = ctx;
    }

    protected boolean hasImport(String name) {
        if (this.pCtx == null) {
            this.pCtx = this.getParserContext();
        }
        if (this.pCtx.hasImport(name)) {
            return true;
        }
        ClassImportResolverFactory vrf = ParseTools.findClassImportResolverFactory(this.variableFactory);
        return vrf != null && vrf.isResolveable(name);
    }

    protected Class getImport(String name) {
        if (this.pCtx == null) {
            this.pCtx = this.getParserContext();
        }
        if (this.pCtx.hasImport(name)) {
            return this.pCtx.getImport(name);
        }
        return (Class)ParseTools.findClassImportResolverFactory(this.variableFactory).getVariableResolver(name).getValue();
    }
}

