/*
 * Decompiled with CFR 0.152.
 */
package org.netpreserve.jwarc.net;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netpreserve.jwarc.HttpResponse;
import org.netpreserve.jwarc.LengthedBody;
import org.netpreserve.jwarc.MediaType;
import org.netpreserve.jwarc.MessageBody;
import org.netpreserve.jwarc.WarcReader;
import org.netpreserve.jwarc.WarcResponse;
import org.netpreserve.jwarc.net.Browser;
import org.netpreserve.jwarc.net.Capture;
import org.netpreserve.jwarc.net.CaptureIndex;
import org.netpreserve.jwarc.net.HttpExchange;
import org.netpreserve.jwarc.net.HttpHandler;
import org.netpreserve.jwarc.net.HttpServer;

public class WarcServer
extends HttpServer {
    private static final DateTimeFormatter ARC_DATE = DateTimeFormatter.ofPattern("yyyyMMddHHmmss").withZone(ZoneOffset.UTC);
    private static final DateTimeFormatter RFC_1123_UTC = DateTimeFormatter.RFC_1123_DATE_TIME.withZone(ZoneOffset.UTC);
    private static final MediaType LINK_FORMAT = MediaType.parse("application/link-format");
    private static final Pattern USER_AGENT_DATE_REGEX = Pattern.compile(".*\\(arcdate/([0-9]{14})\\).*");
    private final CaptureIndex index;
    private String script = "<!doctype html><script src='/__jwarc__/inject.js'></script>\n";

    public WarcServer(ServerSocket serverSocket, List<Path> warcs) throws IOException {
        this(serverSocket, new CaptureIndex(warcs));
    }

    WarcServer(ServerSocket serverSocket, CaptureIndex index) throws IOException {
        super(serverSocket);
        this.index = index;
        this.on("GET", "/", this::home);
        this.on("GET", "/__jwarc__/sw\\.js", this.resource("sw.js"));
        this.on("GET", "/__jwarc__/inject\\.js", this.resource("inject.js"));
        this.on("GET", "/replay/([0-9]{14})/(.*)", this::replay);
        this.on("GET", "/render/([0-9]{14})/(.*)", this::render);
        this.on("GET", "/timemap/(.*)", this::timemap);
        this.on(null, ".*", this::proxy);
    }

    private void home(HttpExchange exchange) throws IOException {
        Capture entrypoint = this.index.entrypoint();
        if (entrypoint == null) {
            exchange.send(404, "Empty collection");
            return;
        }
        exchange.redirect("/replay/" + ARC_DATE.format(entrypoint.date()) + "/" + entrypoint.uri());
    }

    private void proxy(HttpExchange exchange) throws IOException {
        Instant date = this.parseAcceptDatetime(exchange);
        if (date == null) {
            date = this.parseUserAgentDate(exchange);
        }
        if (date == null) {
            date = Instant.EPOCH;
        }
        this.replay(exchange, exchange.param(0), date, true);
    }

    private Instant parseAcceptDatetime(HttpExchange exchange) {
        Optional<String> field = exchange.request().headers().first("Accept-Datetime");
        return field.map(s -> Instant.from(RFC_1123_UTC.parse((CharSequence)s))).orElse(null);
    }

    private Instant parseUserAgentDate(HttpExchange exchange) {
        Optional<String> field = exchange.request().headers().first("User-Agent");
        if (!field.isPresent()) {
            return null;
        }
        Matcher m = USER_AGENT_DATE_REGEX.matcher(field.get());
        if (!m.matches()) {
            return null;
        }
        return Instant.from(ARC_DATE.parse(m.group(1)));
    }

    private void timemap(HttpExchange exchange) throws IOException {
        URI uri = URI.create(exchange.param(1));
        NavigableSet<Capture> versions = this.index.query(uri);
        if (versions.isEmpty()) {
            exchange.send(404, "Not found in archive");
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<").append(((Capture)versions.first()).uri()).append(">;rel=\"original\"");
        for (Capture entry : versions) {
            sb.append(",\n</replay/").append(ARC_DATE.format(entry.date())).append("/").append(entry.uri()).append(">;rel=\"memento\",datetime=\"").append(RFC_1123_UTC.format(entry.date()) + "\"");
        }
        sb.append("\n");
        exchange.send(200, LINK_FORMAT, sb.toString());
    }

    private void replay(HttpExchange exchange) throws IOException {
        if (!exchange.request().headers().first("x-serviceworker").isPresent()) {
            exchange.send(200, this.script);
            return;
        }
        Instant date = Instant.from(ARC_DATE.parse(exchange.param(1)));
        this.replay(exchange, exchange.param(2), date, false);
    }

    private void render(HttpExchange exchange) throws IOException {
        Instant date = Instant.from(ARC_DATE.parse(exchange.param(1)));
        URI uri = URI.create(exchange.param(2));
        NavigableSet<Capture> versions = this.index.query(uri);
        if (versions.isEmpty()) {
            exchange.send(404, "Not found in archive");
            return;
        }
        Capture capture = this.closest(versions, uri, date);
        if (!capture.date().equals(date)) {
            exchange.redirect("/render/" + ARC_DATE.format(capture.date()) + "/" + capture.uri());
            return;
        }
        Browser browser = new Browser("chromium-browser", (InetSocketAddress)this.serverSocket.getLocalSocketAddress(), "render (arcdate/" + ARC_DATE.format(date) + ")");
        try (FileChannel channel = browser.screenshot(uri);){
            exchange.send(((HttpResponse.Builder)new HttpResponse.Builder(200, " ").body(MediaType.parse("image/png"), channel, channel.size())).build());
        }
    }

    private void replay(HttpExchange exchange, String target, Instant date, boolean proxy) throws IOException {
        URI uri = URI.create(target);
        NavigableSet<Capture> versions = this.index.query(uri);
        if (versions.isEmpty()) {
            exchange.send(404, "Not found in archive");
            return;
        }
        Capture capture = this.closest(versions, uri, date);
        try (FileChannel channel = FileChannel.open(capture.file(), StandardOpenOption.READ);){
            channel.position(capture.position());
            WarcReader reader = new WarcReader(channel);
            WarcResponse record = (WarcResponse)reader.next().get();
            HttpResponse http = record.http();
            HttpResponse.Builder b = new HttpResponse.Builder(http.status(), http.reason());
            for (Map.Entry<String, List<String>> e : http.headers().map().entrySet()) {
                if (e.getKey().equalsIgnoreCase("Strict-Transport-Security") || e.getKey().equalsIgnoreCase("Transfer-Encoding") || e.getKey().equalsIgnoreCase("Public-Key-Pins")) continue;
                for (String value : e.getValue()) {
                    b.addHeader(e.getKey(), value);
                }
            }
            b.setHeader("Connection", "keep-alive");
            b.setHeader("Memento-Datetime", RFC_1123_UTC.format(record.date()));
            if (!proxy) {
                b.setHeader("Link", this.mementoLinks(versions, capture));
            }
            if (proxy) {
                b.setHeader("Vary", "Accept-Datetime");
            }
            MessageBody body = http.body();
            if (!proxy && MediaType.HTML.equals(http.contentType().base())) {
                body = LengthedBody.create(body, ByteBuffer.wrap(this.script.getBytes(StandardCharsets.US_ASCII)), (long)this.script.length() + body.size());
            }
            b.body(http.contentType(), body, body.size());
            exchange.send(b.build());
        }
    }

    private String mementoLinks(NavigableSet<Capture> versions, Capture current) {
        StringBuilder sb = new StringBuilder();
        sb.append("<").append(current.uri()).append(">;rel=\"original\",");
        sb.append("</timemap/").append(current.uri()).append(">;rel=\"timemap\";type=\"").append(LINK_FORMAT).append('\"');
        this.mementoLink(sb, "first ", current, (Capture)versions.first());
        this.mementoLink(sb, "prev ", current, versions.lower(current));
        this.mementoLink(sb, "next ", current, versions.higher(current));
        this.mementoLink(sb, "last ", current, (Capture)versions.last());
        return sb.toString();
    }

    private void mementoLink(StringBuilder sb, String rel, Capture current, Capture capture) {
        if (capture == null || capture.date().equals(current.date())) {
            return;
        }
        if (sb.length() != 0) {
            sb.append(',');
        }
        sb.append("</replay/").append(ARC_DATE.format(capture.date())).append("/").append(capture.uri()).append(">;rel=\"").append(rel).append("memento\";datetime=\"").append(RFC_1123_UTC.format(capture.date())).append("\"");
    }

    private Capture closest(NavigableSet<Capture> versions, URI uri, Instant date) {
        Duration db;
        Capture key = new Capture(uri, date);
        Capture a = versions.floor(key);
        Capture b = versions.higher(key);
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        Duration da = Duration.between(a.date(), date);
        return da.compareTo(db = Duration.between(b.date(), date)) < 0 ? a : b;
    }

    private HttpHandler resource(String name) throws IOException {
        URL url = this.getClass().getResource(name);
        if (url == null) {
            throw new NoSuchFileException(name);
        }
        return exchange -> {
            URLConnection conn = url.openConnection();
            long length = conn.getContentLengthLong();
            if (length == -1L) {
                byte[] buf = new byte[8192];
                try (InputStream stream = conn.getInputStream();){
                    int n;
                    length = 0L;
                    while ((n = stream.read(buf)) != -1) {
                        length += (long)n;
                    }
                }
            }
            try (InputStream stream = conn.getInputStream();){
                exchange.send(((HttpResponse.Builder)((HttpResponse.Builder)new HttpResponse.Builder(200, "OK").body(MediaType.parse("application/javascript"), Channels.newChannel(stream), length)).setHeader("Service-Worker-Allowed", "/")).build());
            }
        };
    }
}

