/*
 * Decompiled with CFR 0.152.
 */
package org.noear.java_websocket.client;

import java.net.URI;
import java.util.concurrent.ScheduledFuture;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.handshake.ServerHandshake;
import org.noear.java_websocket.client.HeartbeatHandlerDefault;
import org.noear.java_websocket.utils.ConsumerEx;
import org.noear.java_websocket.utils.RunUtils;

public class SimpleWebSocketClient
extends WebSocketClient {
    private boolean autoReconnect;
    private long heartbeatInterval = 20000L;
    private ConsumerEx<SimpleWebSocketClient> heartbeatHandler = new HeartbeatHandlerDefault();
    private ScheduledFuture<?> heartbeatScheduledFuture;

    public SimpleWebSocketClient(URI serverUri) {
        super(serverUri);
    }

    public SimpleWebSocketClient(String serverUri) {
        super(URI.create(serverUri));
    }

    public boolean isAutoReconnect() {
        return this.autoReconnect;
    }

    public long getHeartbeatInterval() {
        return this.heartbeatInterval;
    }

    public SimpleWebSocketClient heartbeat(long millisInterval, boolean autoReconnect) {
        this.heartbeatInterval = millisInterval;
        this.autoReconnect = autoReconnect;
        this.heartbeatFutureInit();
        return this;
    }

    public SimpleWebSocketClient heartbeatHandler(ConsumerEx<SimpleWebSocketClient> heartbeatHandler) {
        if (heartbeatHandler != null) {
            this.heartbeatHandler = heartbeatHandler;
        }
        return this;
    }

    private void heartbeatFutureInit() {
        if (this.heartbeatScheduledFuture != null) {
            this.heartbeatScheduledFuture.cancel(true);
        }
        this.heartbeatScheduledFuture = RunUtils.delayAndRepeat(() -> {
            try {
                this.heartbeatHandler.accept(this);
            }
            catch (Exception e) {
                this.onError(e);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }, this.heartbeatInterval);
    }

    private void heartbeatFutureStop() {
        if (this.heartbeatScheduledFuture != null) {
            this.heartbeatScheduledFuture.cancel(true);
            this.heartbeatScheduledFuture = null;
        }
    }

    public void release() {
        this.heartbeatFutureStop();
        this.close();
    }

    public void onOpen(ServerHandshake handshakedata) {
    }

    public void onMessage(String message) {
    }

    public void onClose(int code, String reason, boolean remote) {
        if (this.isAutoReconnect()) {
            try {
                Thread.sleep(3000L);
                this.reconnectBlocking();
            }
            catch (Exception e) {
                this.onError(e);
            }
        }
    }

    public void onError(Exception ex) {
    }
}

