/*
 * Decompiled with CFR 0.152.
 */
package org.noear.weed;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.noear.weed.Command;
import org.noear.weed.DataItem;
import org.noear.weed.DataList;
import org.noear.weed.DbContext;
import org.noear.weed.IBinder;
import org.noear.weed.IQuery;
import org.noear.weed.IWeedKey;
import org.noear.weed.SQLer;
import org.noear.weed.VarHolder;
import org.noear.weed.Variate;
import org.noear.weed.WeedConfig;
import org.noear.weed.cache.CacheUsing;
import org.noear.weed.cache.ICacheService;
import org.noear.weed.ext.Act1;
import org.noear.weed.ext.Act2;

public abstract class DbAccess<T extends DbAccess>
implements IWeedKey,
IQuery,
Serializable {
    public String commandText = null;
    public DbContext context;
    public List<Variate> paramS = new ArrayList<Variate>();
    private Act1<Command> onCommandExpr = null;
    protected String _weedKey;
    private int _isLog;
    protected CacheUsing _cache = null;

    protected abstract Command getCommand() throws SQLException;

    protected abstract String getCommandID();

    public T onCommandBuilt(Act1<Command> expr) {
        this.onCommandExpr = expr;
        return (T)this;
    }

    protected void runCommandBuiltEvent(Command cmd) {
        cmd.isLog = this._isLog;
        if (this.onCommandExpr != null) {
            this.onCommandExpr.run(cmd);
        }
        WeedConfig.runCommandBuiltEvent(cmd);
    }

    public DbAccess(DbContext context) {
        this.context = context;
    }

    @Override
    public String getWeedKey() {
        return this.buildWeedKey(this.paramS);
    }

    protected String buildWeedKey(Collection<Variate> args) {
        if (this._weedKey == null) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getCommandID()).append(":");
            for (Variate p : args) {
                sb.append("_").append(p.getValue());
            }
            this._weedKey = sb.toString();
        }
        return this._weedKey;
    }

    protected Variate doGet(String paramName) {
        for (Variate p1 : this.paramS) {
            if (!paramName.equals(p1._name)) continue;
            return p1;
        }
        return null;
    }

    protected Variate doGet(int index) {
        return this.paramS.get(index);
    }

    protected void doSet(String param, Object value) {
        this.paramS.add(new Variate(param, value));
    }

    protected void doSet(Variate value) {
        this.paramS.add(value);
    }

    public T log(boolean isLog) {
        this._isLog = isLog ? 1 : -1;
        return (T)this;
    }

    public long insert() throws SQLException {
        Command cmd = this.getCommand();
        return new SQLer().insert(cmd);
    }

    public int update() throws SQLException {
        return this.execute();
    }

    public int delete() throws SQLException {
        return this.execute();
    }

    public int execute() throws SQLException {
        Command cmd = this.getCommand();
        return new SQLer().execute(cmd);
    }

    public int[] executeBatch() throws SQLException {
        Command cmd = this.getCommand();
        cmd.isBatch = true;
        return new SQLer().executeBatch(cmd);
    }

    @Override
    public long getCount() throws SQLException {
        return this.getVariate().longValue(0L);
    }

    @Override
    public Object getValue() throws SQLException {
        return this.getVariate().getValue();
    }

    @Override
    public <T> T getValue(T def) throws SQLException {
        return this.getVariate().value(def);
    }

    @Override
    public Variate getVariate() throws SQLException {
        return this.getVariate(null);
    }

    @Override
    public Variate getVariate(Act2<CacheUsing, Variate> cacheCondition) throws SQLException {
        Variate rst;
        Command cmd = this.getCommand();
        if (this._cache == null) {
            rst = new SQLer().getVariate(cmd);
        } else {
            this._cache.usingCache(cacheCondition);
            rst = this._cache.getEx(this.getWeedKey(), () -> new SQLer().getVariate(cmd));
        }
        if (rst == null) {
            return new Variate();
        }
        return rst;
    }

    @Override
    @Deprecated
    public <T extends IBinder> T getItem(T model) throws SQLException {
        DataItem item = this.getDataItem();
        if (item.count() == 0 && WeedConfig.isSelectItemEmptyAsNull) {
            return null;
        }
        return item.toItem(model);
    }

    @Override
    @Deprecated
    public <T extends IBinder> T getItem(T model, Act2<CacheUsing, T> cacheCondition) throws SQLException {
        if (cacheCondition == null) {
            return this.getItem(model);
        }
        VarHolder _tmp = new VarHolder();
        DataItem item = this.getDataItem((cu, di) -> {
            _tmp.value = di;
            _tmp.value = di.toItem(model);
            cacheCondition.run((CacheUsing)cu, (Object)((IBinder)_tmp.value));
        });
        if (item.count() == 0 && WeedConfig.isSelectItemEmptyAsNull) {
            return null;
        }
        if (_tmp.value == null) {
            return item.toItem(model);
        }
        return (T)((IBinder)_tmp.value);
    }

    @Override
    @Deprecated
    public <T extends IBinder> List<T> getList(T model) throws SQLException {
        return this.getDataList().toList(model);
    }

    @Override
    @Deprecated
    public <T extends IBinder> List<T> getList(T model, Act2<CacheUsing, List<T>> cacheCondition) throws SQLException {
        if (cacheCondition == null) {
            return this.getList(model);
        }
        VarHolder _tmp = new VarHolder();
        DataList list = this.getDataList((cu, dl) -> {
            _tmp.value = dl.toList(model);
            cacheCondition.run((CacheUsing)cu, (List)_tmp.value);
        });
        if (_tmp == null) {
            return list.toList(model);
        }
        return (List)_tmp.value;
    }

    @Override
    public <T> List<T> getArray(String column) throws SQLException {
        return this.getDataList().toArray(column);
    }

    @Override
    public <T> List<T> getArray(int columnIndex) throws SQLException {
        return this.getDataList().toArray(columnIndex);
    }

    @Override
    public <T> List<T> getList(Class<T> cls) throws SQLException {
        return this.getDataList().toEntityList(cls);
    }

    @Override
    public <T> List<T> getList(Class<T> cls, Act2<CacheUsing, List<T>> cacheCondition) throws SQLException {
        if (cacheCondition == null) {
            return this.getList(cls);
        }
        VarHolder _tmp = new VarHolder();
        DataList list = this.getDataList((cu, dl) -> {
            _tmp.value = dl.toEntityList(cls);
            cacheCondition.run((CacheUsing)cu, (List)_tmp.value);
        });
        if (_tmp.value == null) {
            return list.toEntityList(cls);
        }
        return (List)_tmp.value;
    }

    @Override
    public <T> T getItem(Class<T> cls) throws SQLException {
        DataItem item = this.getDataItem();
        if (item.count() == 0 && WeedConfig.isSelectItemEmptyAsNull) {
            return null;
        }
        return item.toEntity(cls);
    }

    @Override
    public <T> T getItem(Class<T> cls, Act2<CacheUsing, T> cacheCondition) throws SQLException {
        if (cacheCondition == null) {
            return this.getItem(cls);
        }
        VarHolder _tmp = new VarHolder();
        DataItem item = this.getDataItem((cu, di) -> {
            _tmp.value = di.toEntity(cls);
            cacheCondition.run((CacheUsing)cu, _tmp.value);
        });
        if (item.count() == 0 && WeedConfig.isSelectItemEmptyAsNull) {
            return null;
        }
        if (_tmp.value == null) {
            return item.toEntity(cls);
        }
        return _tmp.value;
    }

    @Override
    public DataList getDataList() throws SQLException {
        return this.getDataList(null);
    }

    @Override
    public DataList getDataList(Act2<CacheUsing, DataList> cacheCondition) throws SQLException {
        DataList rst;
        Command cmd = this.getCommand();
        if (this._cache == null) {
            rst = new SQLer().getTable(cmd);
        } else {
            this._cache.usingCache(cacheCondition);
            rst = this._cache.getEx(this.getWeedKey(), () -> new SQLer().getTable(cmd));
        }
        if (rst == null) {
            return new DataList();
        }
        return rst;
    }

    @Override
    public List<Map<String, Object>> getMapList() throws SQLException {
        return this.getDataList().getMapList();
    }

    @Override
    public DataItem getDataItem() throws SQLException {
        return this.getDataItem(null);
    }

    @Override
    public DataItem getDataItem(Act2<CacheUsing, DataItem> cacheCondition) throws SQLException {
        DataItem rst;
        Command cmd = this.getCommand();
        if (this._cache == null) {
            rst = new SQLer().getRow(cmd);
        } else {
            this._cache.usingCache(cacheCondition);
            rst = this._cache.getEx(this.getWeedKey(), () -> new SQLer().getRow(cmd));
        }
        if (rst == null) {
            return new DataItem();
        }
        return rst;
    }

    @Override
    public Map<String, Object> getMap() throws SQLException {
        return this.getDataItem().getMap();
    }

    @Override
    public IQuery caching(ICacheService service) {
        this._cache = new CacheUsing(service);
        return this;
    }

    @Override
    public IQuery usingCache(boolean isCache) {
        this._cache.usingCache(isCache);
        return this;
    }

    @Override
    public IQuery usingCache(int seconds) {
        this._cache.usingCache(seconds);
        return this;
    }

    @Override
    public IQuery cacheTag(String tag) {
        this._cache.cacheTag(tag);
        return this;
    }

    protected T cache(CacheUsing cacheUsing) {
        this._cache = cacheUsing;
        return (T)this;
    }
}

