/*
 * Decompiled with CFR 0.152.
 */
package org.noear.weed;

import java.util.Map;
import org.noear.weed.DbContext;
import org.noear.weed.MapperWhereQ;
import org.noear.weed.SQLBuilder;
import org.noear.weed.ext.Fun2;
import org.noear.weed.utils.EntityUtils;
import org.noear.weed.wrap.DbType;

public abstract class WhereBase<T extends WhereBase> {
    protected DbContext _context;
    protected SQLBuilder _builder;
    protected StringBuilder _orderBy;

    protected WhereBase() {
    }

    public WhereBase(DbContext context) {
        this._context = context;
        this._builder = new SQLBuilder();
    }

    protected DbType dbType() {
        return this._context.getMetaData().getType();
    }

    protected String fmtSchema(String name) {
        return this._context.formater().formatSchema(name);
    }

    protected String fmtObject(String name) {
        return this._context.formater().formatTable(name);
    }

    protected String fmtColumn(String name) {
        return this._context.formater().formatColumn(name);
    }

    protected String fmtMutColumns(String columns) {
        return this._context.formater().formatMultipleColumns(columns);
    }

    protected String fmtCondition(String condition) {
        return this._context.formater().formatCondition(condition);
    }

    public T whereTrue() {
        return this.where("1=1", new Object[0]);
    }

    public T where(String code, Object ... args) {
        this._builder.append(" WHERE ").append(this.fmtCondition(code), args);
        return (T)this;
    }

    public T whereIf(boolean condition, String code, Object ... args) {
        if (condition) {
            this.where(code, args);
        }
        return (T)this;
    }

    public T where() {
        this._builder.append(" WHERE ");
        return (T)this;
    }

    public T where(MapperWhereQ whereQ) {
        this._builder.append(whereQ._builder);
        return (T)this;
    }

    public T whereMap(Map<String, Object> columnMap) {
        return this.whereMapIf(columnMap, (k, v) -> v != null);
    }

    public T whereMapIf(Map<String, Object> columnMap, Fun2<Boolean, String, Object> condition) {
        if (columnMap != null && columnMap.size() > 0) {
            this.where("1=1", new Object[0]);
            columnMap.forEach((k, v) -> {
                if (((Boolean)condition.run((String)k, v)).booleanValue()) {
                    this.andEq((String)k, v);
                }
            });
        }
        return (T)this;
    }

    public T whereEntity(Object entity) {
        return this.whereEntityIf(entity, (k, v) -> v != null);
    }

    public T whereEntityIf(Object entity, Fun2<Boolean, String, Object> condition) {
        if (entity != null) {
            this.where("1=1", new Object[0]);
            EntityUtils.fromEntity(entity, (k, v) -> {
                if (((Boolean)condition.run((String)k, v)).booleanValue()) {
                    this.andEq((String)k, v);
                }
            });
        }
        return (T)this;
    }

    public T whereEq(String column, Object val) {
        this._builder.append(" WHERE ").append(this.fmtColumn(column));
        if (val == null) {
            this._builder.append(" IS NULL ");
        } else {
            this._builder.append(" = ? ", val);
        }
        return (T)this;
    }

    public T whereNeq(String column, Object val) {
        this._builder.append(" WHERE ").append(this.fmtColumn(column));
        if (val == null) {
            this._builder.append(" IS NOT NULL ");
        } else {
            this._builder.append(" != ? ", val);
        }
        return (T)this;
    }

    public T whereLt(String column, Object val) {
        this._builder.append(" WHERE ").append(this.fmtColumn(column)).append(" < ? ", val);
        return (T)this;
    }

    public T whereLte(String column, Object val) {
        this._builder.append(" WHERE ").append(this.fmtColumn(column)).append(" <= ? ", val);
        return (T)this;
    }

    public T whereGt(String column, Object val) {
        this._builder.append(" WHERE ").append(this.fmtColumn(column)).append(" > ? ", val);
        return (T)this;
    }

    public T whereGte(String column, Object val) {
        this._builder.append(" WHERE ").append(this.fmtColumn(column)).append(" >= ? ", val);
        return (T)this;
    }

    public T whereLk(String column, String val) {
        this._builder.append(" WHERE ").append(this.fmtColumn(column)).append(" LIKE ? ", val);
        return (T)this;
    }

    public T whereNlk(String column, String val) {
        this._builder.append(" WHERE ").append(this.fmtColumn(column)).append(" NOT LIKE ? ", val);
        return (T)this;
    }

    public T whereBtw(String column, Object start, Object end) {
        this._builder.append(" WHERE ").append(this.fmtColumn(column)).append(" BETWEEN ? AND ? ", start, end);
        return (T)this;
    }

    public T whereNbtw(String column, Object start, Object end) {
        this._builder.append(" WHERE ").append(this.fmtColumn(column)).append(" NOT BETWEEN ? AND ? ", start, end);
        return (T)this;
    }

    public T whereIn(String column, Iterable ary) {
        this._builder.append(" WHERE ").append(this.fmtColumn(column)).append(" IN (?...) ", ary);
        return (T)this;
    }

    public T whereNin(String column, Iterable ary) {
        this._builder.append(" WHERE ").append(this.fmtColumn(column)).append(" NOT IN (?...) ", ary);
        return (T)this;
    }

    public T and(String code, Object ... args) {
        this._builder.append(" AND ").append(this.fmtCondition(code), args);
        return (T)this;
    }

    public T andIf(boolean condition, String code, Object ... args) {
        if (condition) {
            this.and(code, args);
        }
        return (T)this;
    }

    public T and() {
        this._builder.append(" AND ");
        return (T)this;
    }

    public T andEq(String column, Object val) {
        this._builder.append(" AND ").append(this.fmtColumn(column));
        if (val == null) {
            this._builder.append(" IS NULL ");
        } else {
            this._builder.append(" = ? ", val);
        }
        return (T)this;
    }

    public T andNeq(String column, Object val) {
        this._builder.append(" AND ").append(this.fmtColumn(column));
        if (val == null) {
            this._builder.append(" IS NOT NULL ");
        } else {
            this._builder.append(" != ? ", val);
        }
        return (T)this;
    }

    public T andLt(String column, Object val) {
        this._builder.append(" AND ").append(this.fmtColumn(column)).append(" < ? ", val);
        return (T)this;
    }

    public T andLte(String column, Object val) {
        this._builder.append(" AND ").append(this.fmtColumn(column)).append(" <= ? ", val);
        return (T)this;
    }

    public T andGt(String column, Object val) {
        this._builder.append(" AND ").append(this.fmtColumn(column)).append(" > ? ", val);
        return (T)this;
    }

    public T andGte(String column, Object val) {
        this._builder.append(" AND ").append(this.fmtColumn(column)).append(" >= ? ", val);
        return (T)this;
    }

    public T andLk(String column, String val) {
        this._builder.append(" AND ").append(this.fmtColumn(column)).append(" LIKE ? ", val);
        return (T)this;
    }

    public T andNlk(String column, String val) {
        this._builder.append(" AND ").append(this.fmtColumn(column)).append(" NOT LIKE ? ", val);
        return (T)this;
    }

    public T andBtw(String column, Object start, Object end) {
        this._builder.append(" AND ").append(this.fmtColumn(column)).append(" BETWEEN ? AND ? ", start, end);
        return (T)this;
    }

    public T andNbtw(String column, Object start, Object end) {
        this._builder.append(" AND ").append(this.fmtColumn(column)).append(" NOT BETWEEN ? AND ? ", start, end);
        return (T)this;
    }

    public T andIn(String column, Iterable ary) {
        this._builder.append(" AND ").append(this.fmtColumn(column)).append(" IN (?...) ", ary);
        return (T)this;
    }

    public T andNin(String column, Iterable ary) {
        this._builder.append(" AND ").append(this.fmtColumn(column)).append(" NOT IN (?...) ", ary);
        return (T)this;
    }

    public T or(String code, Object ... args) {
        this._builder.append(" OR ").append(this.fmtCondition(code), args);
        return (T)this;
    }

    public T orIf(boolean condition, String code, Object ... args) {
        if (condition) {
            this.or(code, args);
        }
        return (T)this;
    }

    public T or() {
        this._builder.append(" OR ");
        return (T)this;
    }

    public T orEq(String column, Object val) {
        this._builder.append(" OR ").append(this.fmtColumn(column));
        if (val == null) {
            this._builder.append(" IS NULL ");
        } else {
            this._builder.append(" = ? ", val);
        }
        return (T)this;
    }

    public T orNeq(String column, Object val) {
        this._builder.append(" OR ").append(this.fmtColumn(column));
        if (val == null) {
            this._builder.append(" IS NOT NULL ");
        } else {
            this._builder.append(" != ? ", val);
        }
        return (T)this;
    }

    public T orLt(String column, Object val) {
        this._builder.append(" OR ").append(this.fmtColumn(column)).append(" < ? ", val);
        return (T)this;
    }

    public T orLte(String column, Object val) {
        this._builder.append(" OR ").append(this.fmtColumn(column)).append(" <= ? ", val);
        return (T)this;
    }

    public T orGt(String column, Object val) {
        this._builder.append(" OR ").append(this.fmtColumn(column)).append(" > ? ", val);
        return (T)this;
    }

    public T orGte(String column, Object val) {
        this._builder.append(" OR ").append(this.fmtColumn(column)).append(" >= ? ", val);
        return (T)this;
    }

    public T orLk(String column, String val) {
        this._builder.append(" OR ").append(this.fmtColumn(column)).append(" LIKE ? ", val);
        return (T)this;
    }

    public T orNlk(String column, String val) {
        this._builder.append(" OR ").append(this.fmtColumn(column)).append(" NOT LIKE ? ", val);
        return (T)this;
    }

    public T orBtw(String column, Object start, Object end) {
        this._builder.append(" OR ").append(this.fmtColumn(column)).append(" BETWEEN ? AND ? ", start, end);
        return (T)this;
    }

    public T orNbtw(String column, Object start, Object end) {
        this._builder.append(" OR ").append(this.fmtColumn(column)).append(" NOT BETWEEN ? AND ? ", start, end);
        return (T)this;
    }

    public T orIn(String column, Iterable ary) {
        this._builder.append(" OR ").append(this.fmtColumn(column)).append(" IN (?...) ", ary);
        return (T)this;
    }

    public T orNin(String column, Iterable ary) {
        this._builder.append(" OR ").append(this.fmtColumn(column)).append(" NOT IN (?...) ", ary);
        return (T)this;
    }

    public T begin() {
        this._builder.append(" ( ");
        return (T)this;
    }

    public T begin(String code, Object ... args) {
        this._builder.append(" ( ").append(this.fmtCondition(code), args);
        return (T)this;
    }

    public T beginEq(String column, Object val) {
        this._builder.append(" ( ").append(this.fmtColumn(column));
        if (val == null) {
            this._builder.append(" IS NULL ");
        } else {
            this._builder.append(" = ? ", val);
        }
        return (T)this;
    }

    public T beginNeq(String column, Object val) {
        this._builder.append(" ( ").append(this.fmtColumn(column));
        if (val == null) {
            this._builder.append(" IS NOT NULL ");
        } else {
            this._builder.append(" != ? ", val);
        }
        return (T)this;
    }

    public T beginLt(String column, Object val) {
        this._builder.append(" ( ").append(this.fmtColumn(column)).append(" < ? ", val);
        return (T)this;
    }

    public T beginLte(String column, Object val) {
        this._builder.append(" ( ").append(this.fmtColumn(column)).append(" <= ? ", val);
        return (T)this;
    }

    public T beginGt(String column, Object val) {
        this._builder.append(" ( ").append(this.fmtColumn(column)).append(" > ? ", val);
        return (T)this;
    }

    public T beginGte(String column, Object val) {
        this._builder.append(" ( ").append(this.fmtColumn(column)).append(" >= ? ", val);
        return (T)this;
    }

    public T beginLk(String column, String val) {
        this._builder.append(" ( ").append(this.fmtColumn(column)).append(" LIKE ? ", val);
        return (T)this;
    }

    public T beginNlk(String column, String val) {
        this._builder.append(" ( ").append(this.fmtColumn(column)).append(" NOT LIKE ? ", val);
        return (T)this;
    }

    public T beginBtw(String column, Object start, Object end) {
        this._builder.append(" ( ").append(this.fmtColumn(column)).append(" BETWEEN ? AND ? ", start, end);
        return (T)this;
    }

    public T beginNbtw(String column, Object start, Object end) {
        this._builder.append(" ( ").append(this.fmtColumn(column)).append(" NOT BETWEEN ? AND ? ", start, end);
        return (T)this;
    }

    public T beginIn(String column, Iterable ary) {
        this._builder.append(" ( ").append(this.fmtColumn(column)).append(" IN (?...) ", ary);
        return (T)this;
    }

    public T beginNin(String column, Iterable ary) {
        this._builder.append(" ( ").append(this.fmtColumn(column)).append(" NOT IN (?...) ", ary);
        return (T)this;
    }

    public T end() {
        this._builder.append(" ) ");
        return (T)this;
    }

    protected T orderByDo(String code) {
        if (this._orderBy == null) {
            this._orderBy = new StringBuilder(" ORDER BY ");
        } else {
            this._orderBy.append(", ");
        }
        this._orderBy.append(code);
        return (T)this;
    }

    public T orderBy(String code) {
        return this.orderByDo(this.fmtMutColumns(code));
    }

    public T orderByAsc(String fileds) {
        return this.orderByDo(this.fmtMutColumns(fileds) + " ASC ");
    }

    public T orderByDesc(String fileds) {
        return this.orderByDo(this.fmtMutColumns(fileds) + " DESC ");
    }

    public T andByAsc(String fileds) {
        return this.orderByDo(this.fmtMutColumns(fileds) + " ASC ");
    }

    public T andByDesc(String fileds) {
        return this.orderByDo(this.fmtMutColumns(fileds) + " DESC ");
    }

    public T groupBy(String code) {
        this._builder.append(" GROUP BY ").append(this.fmtMutColumns(code));
        return (T)this;
    }

    public T having(String code) {
        this._builder.append(" HAVING ").append(code);
        return (T)this;
    }
}

