/*
 * Decompiled with CFR 0.152.
 */
package org.noear.weed.cache;

import java.util.ArrayList;
import java.util.List;
import org.noear.weed.IWeedKey;
import org.noear.weed.cache.ICacheService;
import org.noear.weed.ext.Fun1;

public class CacheTags {
    private ICacheService _Cache;
    private List<String> asynTags = null;

    public CacheTags(ICacheService caching) {
        this._Cache = caching;
    }

    public void beginAdd(String tag) {
        if (this.asynTags == null) {
            this.asynTags = new ArrayList<String>();
        }
        this.asynTags.add(tag);
    }

    public void endAdd(IWeedKey target) {
        this.endAdd(target.getWeedKey());
    }

    public void endAdd(String targetCacheKey) {
        if (this.asynTags == null) {
            return;
        }
        if (targetCacheKey != null && targetCacheKey.length() > 0) {
            for (String tag : this.asynTags) {
                this.add(tag, targetCacheKey);
            }
        }
        this.asynTags.clear();
    }

    public void add(String tag, String targetCacheKey) {
        List<String> temp = this.$(this.KEY(tag));
        if (temp.contains(targetCacheKey)) {
            return;
        }
        temp.add(targetCacheKey);
        this.$(this.KEY(tag), temp);
    }

    public CacheTags clear(String tag) {
        List<String> keys = this.$(this.KEY(tag));
        for (String cacheKey : keys) {
            this._Cache.remove(cacheKey);
        }
        this._Cache.remove(this.KEY(tag));
        return this;
    }

    public <T> void update(String tag, Fun1<T, T> setter) {
        List<String> keys = this.getCacheKeys(tag);
        for (String key : keys) {
            Object temp = this._Cache.get(key);
            if (temp == null) continue;
            try {
                Object obj = temp;
                if (obj == null) continue;
                obj = setter.run(obj);
                this._Cache.store(key, obj, this._Cache.getDefalutSeconds());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public int count(String tag) {
        return this.$(this.KEY(tag)).size();
    }

    public String getCacheKey(String tag, int index) {
        List<String> temp = this.$(this.KEY(tag));
        if (temp.size() > index) {
            return temp.get(index);
        }
        return null;
    }

    public List<String> getCacheKeys(String tag) {
        return this.$(this.KEY(tag));
    }

    public void removeTag(String tag, String val, IWeedKey target) {
        this.removeTag(tag, val, target.getWeedKey());
    }

    public void removeTag(String tag, String val, String targetCacheKey) {
        List<String> temp = this.$(this.KEY(tag));
        temp.remove(targetCacheKey);
        this.$(this.KEY(tag), temp);
        this._Cache.remove(targetCacheKey);
    }

    private List<String> $(String key) {
        Object temp = this._Cache.get(key);
        if (temp == null) {
            return new ArrayList<String>();
        }
        return (List)temp;
    }

    private void $(String key, List<String> value) {
        this._Cache.store(key, value, this._Cache.getDefalutSeconds());
    }

    private String KEY(String tag) {
        return ("@" + tag).toUpperCase();
    }
}

