/*
 * Decompiled with CFR 0.152.
 */
package org.noear.weed.cache;

import org.noear.weed.cache.CacheTags;
import org.noear.weed.cache.ICacheServiceEx;
import org.noear.weed.ext.Fun1;

public class SecondCache
implements ICacheServiceEx {
    private ICacheServiceEx cache1;
    private ICacheServiceEx cache2;
    private int bufferSeconds;

    public SecondCache(ICacheServiceEx cache1, ICacheServiceEx cache2) {
        this(cache1, cache2, 5);
    }

    public SecondCache(ICacheServiceEx cache1, ICacheServiceEx cache2, int bufferSeconds) {
        this.cache1 = cache1;
        this.cache2 = cache2;
        this.bufferSeconds = bufferSeconds;
    }

    @Override
    public void store(String key, Object obj, int seconds) {
        this.cache1.store(key, obj, seconds);
        this.cache2.store(key, obj, seconds);
    }

    @Override
    public Object get(String key) {
        Object temp = this.cache1.get(key);
        if (temp == null) {
            temp = this.cache2.get(key);
            if (this.bufferSeconds > 0 && temp != null) {
                this.cache1.store(key, temp, this.bufferSeconds);
            }
        }
        return temp;
    }

    @Override
    public void remove(String key) {
        this.cache1.remove(key);
        this.cache2.remove(key);
    }

    @Override
    public int getDefalutSeconds() {
        return this.cache1.getDefalutSeconds();
    }

    @Override
    public String getCacheKeyHead() {
        return this.cache1.getCacheKeyHead();
    }

    @Override
    public CacheTags tags() {
        return this.cache1.tags();
    }

    @Override
    public void clear(String tag) {
        this.cache1.clear(tag);
        this.cache2.clear(tag);
    }

    @Override
    public <T> void update(String tag, Fun1<T, T> setter) {
        this.cache1.update(tag, setter);
        this.cache2.update(tag, setter);
    }
}

