/*
 * Decompiled with CFR 0.152.
 */
package org.noear.weed.mongo;

import java.io.IOException;
import java.util.Properties;
import org.noear.weed.mongo.MgTableQuery;
import org.noear.weed.mongo.MongoX;
import org.noear.weed.utils.StringUtils;

public class MgContext
implements AutoCloseable {
    private MongoX mongoX;

    public MgContext(Properties properties) {
        String schema = properties.getProperty("schema");
        if (StringUtils.isEmpty(schema)) {
            schema = properties.getProperty("db");
        }
        this.mongoX = new MongoX(properties, schema);
    }

    public MgContext(Properties properties, String schema) {
        this.mongoX = new MongoX(properties, schema);
    }

    public MgContext(String url, String schema) {
        this.mongoX = new MongoX(url, schema);
    }

    public MgTableQuery table(String table) {
        return new MgTableQuery(this.mongoX).table(table);
    }

    public MongoX mongo() {
        return this.mongoX;
    }

    @Override
    public void close() throws IOException {
        if (this.mongoX != null) {
            this.mongoX.close();
        }
    }
}

