/*
 * Decompiled with CFR 0.152.
 */
package org.noear.weed.utils;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;

public final class ThrowableUtils {
    public static String throwableToString(Throwable ex) {
        StringWriter sw = new StringWriter();
        ex.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    public static Throwable throwableUnwrap(Throwable ex) {
        Throwable th = ex;
        while (true) {
            if (th instanceof InvocationTargetException) {
                th = ((InvocationTargetException)th).getTargetException();
                continue;
            }
            if (th instanceof UndeclaredThrowableException) {
                th = ((UndeclaredThrowableException)th).getUndeclaredThrowable();
                continue;
            }
            if (th.getClass() != RuntimeException.class || th.getMessage() != null || th.getCause() == null) break;
            th = th.getCause();
        }
        return th;
    }

    public static boolean throwableHas(Throwable ex, Class<? extends Throwable> clz) {
        Throwable th = ex;
        while (true) {
            if (clz.isAssignableFrom(th.getClass())) {
                return true;
            }
            if (th instanceof InvocationTargetException) {
                th = ((InvocationTargetException)th).getTargetException();
                continue;
            }
            if (th instanceof UndeclaredThrowableException) {
                th = ((UndeclaredThrowableException)th).getUndeclaredThrowable();
                continue;
            }
            if (th.getCause() == null) break;
            th = th.getCause();
        }
        return false;
    }
}

